/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.ux.extension.xxd.ui.views;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.chemclipse.ux.extension.csd.ui.editors.ChromatogramEditorCSD;
import org.eclipse.chemclipse.ux.extension.msd.ui.editors.ChromatogramEditorMSD;
import org.eclipse.chemclipse.ux.extension.ui.views.AbstractChromatogramSelectionView;
import org.eclipse.chemclipse.ux.extension.wsd.ui.editors.ChromatogramEditorWSD;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;

public abstract class AbstractChromatogramOverlayView
extends AbstractChromatogramSelectionView {
    private EPartService partService;

    public AbstractChromatogramOverlayView(MPart part, EPartService partService, IEventBroker eventBroker) {
        super(part, partService, eventBroker);
        this.partService = partService;
    }

    public List<IChromatogramSelection> getChromatogramSelections(IChromatogramSelection masterChromatogramSelection, boolean ignoreOverlaySelection) {
        ArrayList<IChromatogramSelection> chromatogramSelections = new ArrayList<IChromatogramSelection>();
        if (ignoreOverlaySelection) {
            chromatogramSelections.add(masterChromatogramSelection);
        } else if (masterChromatogramSelection.isOverlaySelected()) {
            chromatogramSelections.add(masterChromatogramSelection);
        }
        Collection parts = this.partService.getParts();
        for (MPart part : parts) {
            ChromatogramEditorMSD editor;
            Object object;
            if (!this.isChromatogramEditor(part) || (object = part.getObject()) == null) continue;
            IChromatogramSelectionMSD selection = null;
            if (object instanceof ChromatogramEditorMSD) {
                editor = (ChromatogramEditorMSD)object;
                selection = editor.getChromatogramSelection();
            } else if (object instanceof ChromatogramEditorCSD) {
                editor = (ChromatogramEditorCSD)object;
                selection = editor.getChromatogramSelection();
            } else if (object instanceof ChromatogramEditorWSD) {
                editor = (ChromatogramEditorWSD)object;
                selection = editor.getChromatogramSelection();
            }
            if (selection == null || selection == masterChromatogramSelection) continue;
            if (ignoreOverlaySelection) {
                chromatogramSelections.add((IChromatogramSelection)selection);
                continue;
            }
            if (!selection.isOverlaySelected()) continue;
            chromatogramSelections.add((IChromatogramSelection)selection);
        }
        return chromatogramSelections;
    }

    private boolean isChromatogramEditor(MPart part) {
        return part.getElementId().equals("org.eclipse.chemclipse.ux.extension.msd.ui.part.chromatogramEditor") || part.getElementId().equals("org.eclipse.chemclipse.ux.extension.csd.ui.part.chromatogramEditor") || part.getElementId().equals("org.eclipse.chemclipse.ux.extension.wsd.ui.part.chromatogramEditor");
    }
}

