/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.ui.internal.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.core.PeakDetectorCSD;
import org.eclipse.chemclipse.chromatogram.csd.peak.detector.settings.IPeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.core.PeakDetectorMSD;
import org.eclipse.chemclipse.chromatogram.msd.peak.detector.settings.IPeakDetectorMSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.preferences.PreferenceSupplier;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.IFirstDerivativePeakDetectorCSDSettings;
import org.eclipse.chemclipse.chromatogram.xxd.peak.detector.supplier.firstderivative.settings.IFirstDerivativePeakDetectorMSDSettings;
import org.eclipse.chemclipse.csd.model.core.selection.ChromatogramSelectionCSD;
import org.eclipse.chemclipse.csd.model.core.selection.IChromatogramSelectionCSD;
import org.eclipse.chemclipse.model.selection.IChromatogramSelection;
import org.eclipse.chemclipse.msd.model.core.selection.ChromatogramSelectionMSD;
import org.eclipse.chemclipse.msd.model.core.selection.IChromatogramSelectionMSD;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DetectorRunnable
implements IRunnableWithProgress {
    private static final String PEAK_DETECTOR_MSD_ID = "org.eclipse.chemclipse.chromatogram.msd.peak.detector.supplier.firstderivative";
    private static final String PEAK_DETECTOR_CSD_ID = "org.eclipse.chemclipse.chromatogram.csd.peak.detector.supplier.firstderivative";
    private IChromatogramSelection chromatogramSelection;
    private int detectedPeaks;

    public DetectorRunnable(IChromatogramSelection chromatogramSelection) {
        this.chromatogramSelection = chromatogramSelection;
    }

    public int getDetectedPeaks() {
        return this.detectedPeaks;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            monitor.beginTask("Peak Detector First Derivative", -1);
            if (this.chromatogramSelection instanceof ChromatogramSelectionMSD) {
                final ChromatogramSelectionMSD chromatogramSelectionMSD = (ChromatogramSelectionMSD)this.chromatogramSelection;
                IFirstDerivativePeakDetectorMSDSettings peakDetectorSettings = PreferenceSupplier.getPeakDetectorMSDSettings();
                PeakDetectorMSD.detect((IChromatogramSelectionMSD)chromatogramSelectionMSD, (IPeakDetectorMSDSettings)peakDetectorSettings, (String)PEAK_DETECTOR_MSD_ID, (IProgressMonitor)monitor);
                this.detectedPeaks = chromatogramSelectionMSD.getChromatogramMSD().getNumberOfPeaks();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        chromatogramSelectionMSD.update(true);
                    }
                });
            } else if (this.chromatogramSelection instanceof ChromatogramSelectionCSD) {
                final ChromatogramSelectionCSD chromatogramSelectionCSD = (ChromatogramSelectionCSD)this.chromatogramSelection;
                IFirstDerivativePeakDetectorCSDSettings peakDetectorSettings = PreferenceSupplier.getPeakDetectorCSDSettings();
                PeakDetectorCSD.detect((IChromatogramSelectionCSD)chromatogramSelectionCSD, (IPeakDetectorCSDSettings)peakDetectorSettings, (String)PEAK_DETECTOR_CSD_ID, (IProgressMonitor)monitor);
                this.detectedPeaks = chromatogramSelectionCSD.getChromatogramCSD().getNumberOfPeaks();
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        chromatogramSelectionCSD.update(true);
                    }
                });
            }
        }
        finally {
            monitor.done();
        }
    }
}

