/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.office.model;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.capra.ui.office.utils.CapraOfficeUtils;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CapraWordRequirement
extends CapraOfficeObject {
    private static final Logger LOG = LoggerFactory.getLogger(CapraWordRequirement.class);
    private static final String LINE_BREAKS_AND_CONTROL_REGEX = "[\r\n\t\\p{C}]+";
    private static final String WORD_FIELD_SPLIT_DELIMITERS = "(\")|(\\\\\\*)";
    private static final String FIELD_TAG = "w:instrText";

    public CapraWordRequirement(File officeFile, XWPFParagraph paragraph, String fieldName) {
        String[] parts;
        Document doc;
        String rText = "";
        String rId = "";
        CTP pCtp = paragraph.getCTP();
        try {
            doc = CapraOfficeUtils.createDOMDocument(pCtp.toString());
        }
        catch (IOException e) {
            LOG.info("Could not create DOM document: error reading file.", (Throwable)e);
            return;
        }
        catch (ParserConfigurationException e) {
            LOG.info("Could not create DOM document: parser not configured properly.", (Throwable)e);
            return;
        }
        catch (SAXException e) {
            LOG.info("Could not create DOM document: malformed XML.", (Throwable)e);
            return;
        }
        NodeList nodeList = doc.getElementsByTagName(FIELD_TAG);
        if (nodeList.getLength() > 0 && Arrays.asList(parts = nodeList.item(0).getTextContent().split(WORD_FIELD_SPLIT_DELIMITERS)).contains(fieldName) && parts.length > 2) {
            rText = paragraph.getText();
            rId = parts[2].trim();
        }
        if (!(rText = rText.replaceAll(LINE_BREAKS_AND_CONTROL_REGEX, " ").trim()).isEmpty()) {
            rText = "ID " + rId + ": " + rText;
            String pUri = CapraWordRequirement.createUri(officeFile.getAbsolutePath(), rId);
            this.setData(rText);
            this.setUri(pUri);
        }
    }
}

