/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ElementKind implements Enumerator
{
    TYPE(0, "TYPE", "TYPE"),
    MEMBER(1, "MEMBER", "MEMBER");

    public static final int TYPE_VALUE = 0;
    public static final int MEMBER_VALUE = 1;
    private static final ElementKind[] VALUES_ARRAY;
    public static final List<ElementKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ElementKind[]{TYPE, MEMBER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ElementKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ElementKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ElementKind get(int value) {
        switch (value) {
            case 0: {
                return TYPE;
            }
            case 1: {
                return MEMBER;
            }
        }
        return null;
    }

    private ElementKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

