/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.semantic.data.information;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AggregationKind implements Enumerator
{
    UNSET(0, "UNSET", "UNSET"),
    ASSOCIATION(1, "ASSOCIATION", "ASSOCIATION"),
    AGGREGATION(2, "AGGREGATION", "AGGREGATION"),
    COMPOSITION(3, "COMPOSITION", "COMPOSITION");

    public static final int UNSET_VALUE = 0;
    public static final int ASSOCIATION_VALUE = 1;
    public static final int AGGREGATION_VALUE = 2;
    public static final int COMPOSITION_VALUE = 3;
    private static final AggregationKind[] VALUES_ARRAY;
    public static final List<AggregationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AggregationKind[]{UNSET, ASSOCIATION, AGGREGATION, COMPOSITION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AggregationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AggregationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AggregationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AggregationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AggregationKind get(int value) {
        switch (value) {
            case 0: {
                return UNSET;
            }
            case 1: {
                return ASSOCIATION;
            }
            case 2: {
                return AGGREGATION;
            }
            case 3: {
                return COMPOSITION;
            }
        }
        return null;
    }

    private AggregationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

