/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.docgen.util;

import java.io.IOException;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.sirius.business.api.session.resource.AirdResource;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.capellamodeller.util.CapellamodellerResourceImpl;
import org.polarsys.capella.docgen.Activator;
import org.polarsys.capella.docgen.util.CapellaServices;
import org.polarsys.capella.docgen.util.DocGenHtmlCapellaUtil;
import org.polarsys.capella.docgen.util.ImageHandlerService;
import org.polarsys.capella.docgen.util.ImageHelper;
import org.polarsys.capella.shared.id.handler.IScope;
import org.polarsys.capella.shared.id.handler.IdManager;
import org.polarsys.kitalpha.doc.gen.business.core.util.DocGenHtmlUtil;
import org.polarsys.kitalpha.doc.gen.business.core.util.LabelProviderHelper;

public class StringUtil {
    private static final String ELEMENT_LINK_REGEX = "hlink://(.+)";
    private static final String REGEX = "<[\\s]*[aA][\\s]+href[\\s]*=[\\s]*\"([^>]+)\"[\\s]*>(.*?)<[\\s]*/[\\s]*[aA][\\s]*>";
    private static final String REGEX_FILEPATH = "<[aA][\\s]+href=\"(.+?)\">";
    private static final String ERROR_CPY = "Error during project relative file copy: {0}";
    private static final String ERROR_COPY_PART_2 = " referenced in the description of the element: {0} ";
    private static final String ERROR_DECODE_FILE_LOCATION = "Error while decoding file location: {0}";
    private static final String ERROR_READ_FILE_LOCATION = "Error while reading decoded file location: {0}";
    static final String WARNING_IMAGE_SERIALIZATION_FAILED = "Image serialization failed, default to keep img serialized value for element if id: {0}";
    static final String WARNING_NETWORK_IMAGE_NO_TREATMENT = "Network images are left as is and not copied to the generated documentation: {0}. Element id: {1}";
    private static final String ERROR_STRING_PATH_URI_UNENCODE = "String to URI unencode failed with string: {0}";
    static final String IMAGES_FOLDER = "/images/";
    private static final String ERROR_HYPERLINK_OBJECT_UNREACHABLE = "Hyperlink to object {0} in {1} cannot be reached";

    public static String transformAREFString(EObject eObject, String input, String projectName, String outputFolder) {
        if (input != null) {
            input = StringUtil.manageModelAndDiagramElementsLinks(input, eObject);
            input = StringUtil.manageImages(eObject, input, projectName, outputFolder);
            input = StringUtil.manageFileLinks(eObject, input, projectName, outputFolder);
            return input;
        }
        return "";
    }

    protected static String getResourceCopyError(EObject element, String resourcePath) {
        StringBuilder result = new StringBuilder();
        if (element != null) {
            StringBuilder elementFQN = StringUtil.getElementFQN(element);
            String part1 = MessageFormat.format(ERROR_CPY, resourcePath);
            String part2 = MessageFormat.format(ERROR_COPY_PART_2, elementFQN);
            result.append(part1);
            result.append(part2);
        } else {
            result.insert(0, ERROR_CPY);
        }
        return result.toString();
    }

    private static StringBuilder getElementFQN(EObject element) {
        StringBuilder elementFQN = new StringBuilder();
        String elementLabel = LabelProviderHelper.getText((EObject)element);
        if (!"".equals(elementLabel)) {
            elementFQN.append(elementLabel);
            EObject currentElement = element;
            while (currentElement.eContainer() != null) {
                currentElement = currentElement.eContainer();
                elementFQN.insert(0, "::");
                elementFQN.insert(0, LabelProviderHelper.getText((EObject)currentElement));
            }
        }
        return elementFQN;
    }

    private static String manageModelAndDiagramElementsLinks(String input, EObject eObject) {
        Pattern pattern = Pattern.compile(REGEX, 32);
        Matcher matcher = pattern.matcher(input);
        while (matcher.find()) {
            if (matcher.groupCount() != 2) continue;
            String akB = "<a href=\"";
            String akE = "</a>";
            String link = "<a href=\"" + StringUtil.switchToDocPath(matcher.group(1), eObject) + "\">" + matcher.group(2) + "</a>";
            input = input.replace(matcher.group(0), link);
        }
        return input;
    }

    private static String manageFileLinks(EObject eObject, String input, String projectName, String outputFolder) {
        if (input.trim().length() == 0) {
            return input;
        }
        Pattern pattern = Pattern.compile(REGEX_FILEPATH, 32);
        Matcher matcher = pattern.matcher(input);
        Path parentSrcFolder = new Path(eObject.eResource().getURI().segment(1));
        IPath parentTargetFolderPath = new Path(projectName).append(outputFolder);
        while (matcher.find()) {
            String firstMatchGroup = matcher.group(1);
            if (!firstMatchGroup.startsWith("file://") && !firstMatchGroup.startsWith("local://")) continue;
            input = StringUtil.manageFileLink(eObject, input, (IPath)parentSrcFolder, parentTargetFolderPath, firstMatchGroup);
        }
        return input;
    }

    private static String manageFileLink(EObject eObject, String input, IPath parentSrcFolder, IPath parentTargetFolderPath, String firstMatchGroup) {
        ILog logger = Activator.getDefault().getLog();
        String id = eObject.eGet(eObject.eClass().getEStructuralFeature("id")).toString();
        id = id.replace("-", "");
        String decodedFirstMatchGroup = StringUtil.decodeHtmlFilePath(firstMatchGroup, logger);
        if (decodedFirstMatchGroup == null) {
            return input;
        }
        Path patha = new Path(decodedFirstMatchGroup.replaceAll("%20", " "));
        String iconName = String.valueOf(id) + "/" + patha.lastSegment();
        StringBuilder iconSourcePath = new StringBuilder();
        if (decodedFirstMatchGroup.startsWith("file://")) {
            String[] stringArray = patha.segments();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String segment = stringArray[n2];
                iconSourcePath.append("/").append(segment);
                ++n2;
            }
        } else {
            IPath path = parentSrcFolder.append(decodedFirstMatchGroup.substring(8, decodedFirstMatchGroup.length()));
            IFile iconFile = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            if (iconFile.exists()) {
                iconSourcePath.append(iconFile.getLocationURI().getPath());
            } else {
                logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", StringUtil.getResourceCopyError(eObject, path.toString())));
                return input;
            }
        }
        IFolder parentTargetFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parentTargetFolderPath);
        input = input.replace(firstMatchGroup, "./files/" + iconName + "\"");
        try {
            ImageHelper.INSTANCE.copyProjectImageToSystemLocation(iconSourcePath.toString(), String.valueOf(parentTargetFolder.getLocationURI().getPath()) + "/files/" + iconName);
        }
        catch (Exception e) {
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", StringUtil.getResourceCopyError(eObject, iconSourcePath.toString()), (Throwable)e));
        }
        return input;
    }

    private static String manageImages(EObject eObject, String input, String projectName, String outputFolder) {
        if (input.trim().isEmpty()) {
            return input;
        }
        Pattern pattern = Pattern.compile("<img.*?src=\"(.*?)\".*?/>", 32);
        Matcher matcher = pattern.matcher(input);
        IPath parentTargetFolderPath = new Path(projectName).append(outputFolder);
        IFolder parentTargetFolder = ResourcesPlugin.getWorkspace().getRoot().getFolder(parentTargetFolderPath);
        ArrayList<String> imageFileNames = new ArrayList<String>();
        ILog logger = Activator.getDefault().getLog();
        String id = eObject.eGet(eObject.eClass().getEStructuralFeature("id")).toString();
        id = DocGenHtmlUtil.getValidFileName((String)id);
        while (matcher.find()) {
            String iconPath;
            String firstMatchGroup;
            if (matcher.groupCount() != 1 || !input.contains(firstMatchGroup = matcher.group(1)) || (iconPath = ImageHandlerService.eINSTANCE.getTargetIconPath(logger, eObject, firstMatchGroup, parentTargetFolder, imageFileNames)) == null) continue;
            input = input.replace(firstMatchGroup, "./images/" + iconPath);
        }
        return input;
    }

    public static String unencodeURIString(String stringToUnencode, ILog logger) {
        try {
            URI uri = new URI(stringToUnencode);
            stringToUnencode = URIUtil.toUnencodedString((URI)uri);
        }
        catch (URISyntaxException e) {
            logger.log((IStatus)new Status(2, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_STRING_PATH_URI_UNENCODE, stringToUnencode), (Throwable)e));
        }
        return stringToUnencode;
    }

    public static String decodeHtmlFilePath(String filePath, ILog logger) {
        try {
            HTMLDocument doc = new HTMLDocument();
            new HTMLEditorKit().read(new StringReader("<html><body>" + filePath), (Document)doc, 0);
            String decodedFirstMatchGroup = doc.getText(1, doc.getLength()).trim();
            return decodedFirstMatchGroup;
        }
        catch (BadLocationException e) {
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_DECODE_FILE_LOCATION, filePath), (Throwable)e));
        }
        catch (IOException e) {
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_READ_FILE_LOCATION, filePath), (Throwable)e));
        }
        return null;
    }

    private static String switchToDocPath(String group, EObject object) {
        Pattern pattern = Pattern.compile(ELEMENT_LINK_REGEX);
        Matcher matcher = pattern.matcher(group);
        String id = null;
        if (matcher.find() && matcher.groupCount() == 1 && (id = matcher.group(1)) != null && id.trim().length() > 0 && id.contains("/")) {
            id = id.substring(0, id.length() - 1);
        }
        if (id != null) {
            return StringUtil.buildResourceRepresentationString(object, id);
        }
        return group;
    }

    private static String buildResourceRepresentationString(EObject object, String id) {
        ResourceSet rs;
        StringBuilder stringBuilder = new StringBuilder();
        Resource resource = object.eResource();
        EObject eObject = resource.getEObject(id);
        if (eObject == null) {
            rs = resource.getResourceSet();
            String searchId = id;
            eObject = rs.getResources().stream().filter(iResource -> {
                EObject eObj = null;
                if (iResource instanceof CapellamodellerResourceImpl || iResource instanceof AirdResource) {
                    eObj = iResource.getEObject(searchId);
                }
                return eObj != null;
            }).findAny().orElse((Resource)new ResourceImpl()).getEObject(id);
        }
        if (eObject == null) {
            rs = resource.getResourceSet();
            eObject = IdManager.getInstance().getEObject(id, new IScope(){

                public List<Resource> getResources() {
                    return rs.getResources();
                }
            });
        }
        if (eObject != null) {
            if (eObject instanceof DSemanticDiagram) {
                stringBuilder.append(CapellaServices.getPathFromElement(((DSemanticDiagram)eObject).getTarget()));
                stringBuilder.append("#");
                stringBuilder.append(CapellaServices.getDiagramUid((DSemanticDiagram)eObject));
            } else {
                stringBuilder.append(CapellaServices.getPathFromElement(eObject));
            }
        } else {
            ILog logger = Activator.getDefault().getLog();
            StringBuilder elementLabel = StringUtil.getElementFQN(object);
            logger.log((IStatus)new Status(4, "org.polarsys.capella.docgen", MessageFormat.format(ERROR_HYPERLINK_OBJECT_UNREACHABLE, id, elementLabel)));
        }
        return stringBuilder.toString();
    }

    protected static String getPath(Resource resource, String id) {
        String newID = id.replaceAll("#", "");
        EObject eObject = resource.getEObject(newID);
        if (eObject != null) {
            String fileName = DocGenHtmlCapellaUtil.SERVICE.getFileName(eObject);
            String modelName = DocGenHtmlUtil.getModelName((EObject)eObject);
            return "../" + modelName + "/" + DocGenHtmlUtil.getValidFileName((String)fileName) + "." + "html";
        }
        return "#";
    }

    public static String stringListToBulette(Collection<String> list_p) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list_p.isEmpty()) {
            stringBuilder.append("None");
        } else {
            stringBuilder.append("<ul class=\"generatedList\">");
            for (String str : list_p) {
                StringUtil.buletteItem(stringBuilder, str);
            }
            stringBuilder.append("</ul>");
        }
        return stringBuilder.toString();
    }

    public static String stringListToBulette(EList<? extends AbstractNamedElement> list_elts, String projectName, String outputFolder) {
        StringBuilder stringBuilder = new StringBuilder();
        if (list_elts.isEmpty()) {
            stringBuilder.append("None");
        } else {
            stringBuilder.append("<ul class=\"generatedList\">");
            for (AbstractNamedElement elt : list_elts) {
                stringBuilder.append("<li>");
                stringBuilder.append(CapellaServices.getImageLinkFromElement((EObject)elt, projectName, outputFolder));
                stringBuilder.append(" ");
                stringBuilder.append(CapellaServices.getHyperlinkFromElement((EObject)elt));
                stringBuilder.append("</li>");
            }
            stringBuilder.append("</ul>");
        }
        return stringBuilder.toString();
    }

    private static void buletteItem(StringBuilder buffer, String str) {
        buffer.append("<li>");
        buffer.append(str);
        buffer.append("</li>");
    }

    public static String mapToHTMLTable(Map<String, String> map, String firstColTitle, String secondColTitle) {
        boolean generateTableHeader = firstColTitle != null && !firstColTitle.isEmpty() || secondColTitle != null && !secondColTitle.isEmpty();
        firstColTitle = firstColTitle == null ? "" : firstColTitle;
        secondColTitle = secondColTitle == null ? "" : secondColTitle;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<table>");
        if (generateTableHeader) {
            stringBuilder.append("<tr>").append("<th>");
            stringBuilder.append(firstColTitle).append("</th>");
            stringBuilder.append("<th>");
            stringBuilder.append(secondColTitle);
            stringBuilder.append("</th></tr>");
        }
        for (Map.Entry<String, String> e : map.entrySet()) {
            stringBuilder.append("<tr>");
            stringBuilder.append("<td>").append(e.getKey()).append("</td><td>").append(e.getValue()).append("</td>");
            stringBuilder.append("</tr>");
        }
        stringBuilder.append("</table>");
        return stringBuilder.toString();
    }

    public static boolean containsNotEmptyString(Collection<String> stringSet) {
        for (String string : stringSet) {
            if (string == null || string.isEmpty()) continue;
            return true;
        }
        return false;
    }
}

