/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.model.helpers;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;

public class TraceHelper {
    private static final String TRACE_FILE_EXTENSION = "bridgetraces";

    public static URI getTraceURI(URI uri) {
        return uri.appendFileExtension(TRACE_FILE_EXTENSION);
    }

    private static boolean hasTraceExtension(IResource resource) {
        return resource != null && 1 == resource.getType() && TRACE_FILE_EXTENSION.equals(resource.getFileExtension());
    }

    private static boolean hasSecondaryExtension(IResource resource, String expectedExtension) {
        if (expectedExtension != null && TraceHelper.hasTraceExtension(resource)) {
            IPath resourcePath = resource.getFullPath();
            IPath capellaResourcePath = resourcePath.removeFileExtension();
            String capellaResourceExtension = capellaResourcePath.getFileExtension();
            return expectedExtension.equals(capellaResourceExtension);
        }
        return false;
    }

    public static boolean isLegacyTraceResource(IResource resource) {
        return TraceHelper.hasSecondaryExtension(resource, "melodymodeller");
    }

    public static boolean isTraceResource(IResource resource) {
        return TraceHelper.hasSecondaryExtension(resource, "capella");
    }

    public static IPath convertLegacyTracePathToModern(IPath tracePath) {
        IPath legacyCapellaResourcePath = tracePath.removeFileExtension();
        IPath modernCapellaResourcePath = CapellaResourceHelper.convertLegacyResourcePathToModern((IPath)legacyCapellaResourcePath);
        return modernCapellaResourcePath.addFileExtension(TRACE_FILE_EXTENSION);
    }

    public static void renameLegacyTraceFile(IFile traceFile) throws CoreException {
        IPath legacyTracePath = traceFile.getFullPath();
        IPath modernTracePath = TraceHelper.convertLegacyTracePathToModern(legacyTracePath);
        traceFile.move(modernTracePath, true, (IProgressMonitor)new NullProgressMonitor());
    }
}

