/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.log4j;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.bridge.log4j.BridgeElementLink;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IHyperlink;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.console.PatternMatchEvent;
import org.eclipse.ui.console.TextConsole;

public class BridgeConsole
extends MessageConsole {
    protected static final Logger logger = Logger.getLogger(BridgeConsole.class);
    private MessageConsoleStream _infoStream;
    private MessageConsoleStream _warningStream;
    private MessageConsoleStream _errorStream;
    private final PatternMatchListener _notifier;
    private Map<String, URI> _fragmentToURIMap = new HashMap<String, URI>();

    public BridgeConsole(String name_p, ImageDescriptor imageDescriptor_p) {
        super(name_p, imageDescriptor_p);
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.initializeInfoStream(display);
        this.initializeWarningStream(display);
        this.initializeErrorStream(display);
        this._notifier = new PatternMatchListener();
        this.addPatternMatchListener(this._notifier);
    }

    protected void dispose() {
        super.dispose();
        try {
            this.removePatternMatchListener(this._notifier);
            this._infoStream.flush();
            this._infoStream.close();
            this._warningStream.flush();
            this._warningStream.close();
            this._errorStream.flush();
            this._errorStream.close();
        }
        catch (IOException ex) {
            logger.error((Object)ex.getStackTrace(), (Throwable)ex);
        }
    }

    public MessageConsoleStream getErrorStream() {
        return this._errorStream;
    }

    public Map<String, URI> getFragmentToURIMap() {
        return this._fragmentToURIMap;
    }

    public MessageConsoleStream getInfoStream() {
        return this._infoStream;
    }

    public MessageConsoleStream getWarningStream() {
        return this._warningStream;
    }

    private void initializeInfoStream(Display display_p) {
        Color color = Display.getDefault().getSystemColor(2);
        this._infoStream = this.newMessageStream();
        this._infoStream.setColor(color);
    }

    private void initializeWarningStream(Display display_p) {
        Color color = Display.getDefault().getSystemColor(8);
        this._warningStream = this.newMessageStream();
        this._warningStream.setColor(color);
    }

    private void initializeErrorStream(Display display_p) {
        Color color = Display.getDefault().getSystemColor(3);
        this._errorStream = this.newMessageStream();
        this._errorStream.setColor(color);
    }

    public static class PatternMatchListener
    implements IPatternMatchListener {
        private static final String BRIDGE_ELEMENT_ID_PATTERN = "\\[([a-zA-Z\\d_$-][a-zA-Z\\d_$-]*\\.)*[a-zA-Z\\d_$-][a-zA-Z\\d_$-]*\\]";
        private static final String BRIDGE_ELEMENT_FRAGMENT_PATTERN = "\\[(\\/(\\/)?\\@[a-zA-Z\\d_][a-zA-Z\\d_]*(\\.[0-9]+)?)+\\]";
        private static final String BRIDGE_ELEMENT_COMBINED_PATTERN = "(\\[([a-zA-Z\\d_$-][a-zA-Z\\d_$-]*\\.)*[a-zA-Z\\d_$-][a-zA-Z\\d_$-]*\\]|\\[(\\/(\\/)?\\@[a-zA-Z\\d_][a-zA-Z\\d_]*(\\.[0-9]+)?)+\\])";
        private TextConsole _console = null;

        public void connect(TextConsole console_p) {
            this._console = console_p;
        }

        public void disconnect() {
            this._console = null;
        }

        public int getCompilerFlags() {
            return 32;
        }

        public String getLineQualifier() {
            return null;
        }

        public String getPattern() {
            return BRIDGE_ELEMENT_COMBINED_PATTERN;
        }

        public boolean isValid(URI uri_p) {
            return uri_p != null && !uri_p.isEmpty() && uri_p.scheme() != null;
        }

        public void matchFound(PatternMatchEvent event_p) {
            int offset = event_p.getOffset();
            int length = event_p.getLength();
            try {
                IDocument document = this._console.getDocument();
                String identifier = document.get(offset, length);
                String identifierWithoutBrackets = identifier.substring(1, identifier.length() - 1);
                URI uri = ((BridgeConsole)this._console).getFragmentToURIMap().get(identifierWithoutBrackets);
                if (this.isValid(uri)) {
                    BridgeElementLink link = new BridgeElementLink(uri.appendFragment(identifierWithoutBrackets));
                    this._console.addHyperlink((IHyperlink)link, offset + 1, identifierWithoutBrackets.length());
                }
            }
            catch (BadLocationException ex) {
                logger.error((Object)ex.getStackTrace(), (Throwable)ex);
            }
        }
    }
}

