/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.diffdata.EElementPresence;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.session.Session;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaIncomingRelation;
import org.polarsys.capella.vp.requirements.CapellaRequirements.CapellaOutgoingRelation;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;
import org.polarsys.kitalpha.vp.requirements.Requirements.Requirement;

public class ModelDiffWithManuallyCreatedElements
extends BasicTestCase {
    public static final String SYSTEM_ANALYSIS = "f02bb545-b9de-4f49-8a99-60d9ad390b3e";
    private static final String INPUT_REQUIF_FILE_NAME = "model/inputs/model1.reqif";
    private static final String MODEL_NAME = "model-with-manually-created-elements";
    private static final int TARGET_CAPELLA_INCOMING_RELATIONS_NUMBER = 4;
    private static final int TARGET_CAPELLA_OUTGOING_RELATIONS_NUMBER = 3;
    private static final int TARGET_CAPELLA_REQUIREMENTS_NUMBER = 1;
    private static final int REFERENCE_CAPELLA_INCOMING_RELATIONS_NUMBER = 0;
    private static final int REFERENCE_CAPELLA_OUTGOING_RELATIONS_NUMBER = 0;
    private static final int REFERENCE_CAPELLA_REQUIREMENTS_NUMBER = 1;

    public List<String> getRequiredTestModels() {
        return Arrays.asList(MODEL_NAME);
    }

    public void test() throws Exception {
        Session session = this.getSession(MODEL_NAME);
        ModelDiffWithManuallyCreatedElements.assertNotNull((Object)session);
        SessionContext sessionContext = new SessionContext(session);
        final BlockArchitecture systemAnalysis = (BlockArchitecture)sessionContext.getSemanticElement(SYSTEM_ANALYSIS);
        final TestRequirementsImportLauncher requirementsImportLauncher = new TestRequirementsImportLauncher();
        TransactionHelper.getExecutionManager((EObject)systemAnalysis).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                File requifFile = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)ModelDiffWithManuallyCreatedElements.INPUT_REQUIF_FILE_NAME);
                URI requifFileURI = URI.createFileURI((String)requifFile.getPath());
                requirementsImportLauncher.launch(requifFileURI, systemAnalysis, (IProgressMonitor)new NullProgressMonitor());
            }
        });
        IContext context = requirementsImportLauncher.getContext();
        Collection targetScopeDifferences = (Collection)context.get((Object)"DIFFERENCES_FROM_TARGET_SCOPE");
        this.assertScopeDifferences(targetScopeDifferences, 4, 3, 1);
        Collection referenceScopeDifferences = (Collection)context.get((Object)"DIFFERENCES_FROM_REFERENCE_SCOPE");
        this.assertScopeDifferences(referenceScopeDifferences, 0, 0, 1);
    }

    private void assertScopeDifferences(Collection<IDifference<EObject>> differences, int incomingRelationsNumber, int outgoingRelationsNumber, int requirementsNumber) {
        ArrayList<CapellaIncomingRelation> incomingRelations = new ArrayList<CapellaIncomingRelation>();
        ArrayList<CapellaOutgoingRelation> outgoingRelations = new ArrayList<CapellaOutgoingRelation>();
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        for (IDifference<EObject> difference : differences) {
            if (!(difference instanceof EElementPresence)) continue;
            EElementPresence elementPresence = (EElementPresence)difference;
            EObject element = (EObject)elementPresence.getElement();
            if (element instanceof CapellaIncomingRelation) {
                incomingRelations.add((CapellaIncomingRelation)element);
                continue;
            }
            if (element instanceof CapellaOutgoingRelation) {
                outgoingRelations.add((CapellaOutgoingRelation)element);
                continue;
            }
            if (!(element instanceof Requirement)) continue;
            requirements.add((Requirement)element);
        }
        ModelDiffWithManuallyCreatedElements.assertEquals((int)incomingRelationsNumber, (int)incomingRelations.size());
        ModelDiffWithManuallyCreatedElements.assertEquals((int)outgoingRelationsNumber, (int)outgoingRelations.size());
        ModelDiffWithManuallyCreatedElements.assertEquals((int)requirementsNumber, (int)requirements.size());
    }
}

