/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.vp.requirements.ju.testcases;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.diffmerge.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.compare.CapellaMatchPolicy;
import org.polarsys.capella.core.compare.CapellaScopeFactory;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.test.framework.api.BasicTestCase;
import org.polarsys.capella.test.framework.context.SessionContext;
import org.polarsys.capella.test.framework.helpers.IResourceHelpers;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFImporterDiffPolicy;
import org.polarsys.capella.vp.requirements.importer.transposer.policies.ReqIFMergePolicy;
import org.polarsys.capella.vp.requirements.ju.transposer.TestRequirementsImportLauncher;

public class ModelDiffTestCase3
extends BasicTestCase {
    private static final String operationalAnalysis = "19fef609-7a17-4a16-8c4d-563ae4cfd1c4";
    private static final String inputFileName = "model/inputs/Sample3.reqif";
    private static final String projectTestName = "sample3";
    private static final String projectWithImportedReqifTestName = "sample3WithImportedReqif";

    public List<String> getRequiredTestModels() {
        return Arrays.asList(projectTestName, projectWithImportedReqifTestName);
    }

    public void test() throws Exception {
        SessionContext session = new SessionContext(this.getSession(projectTestName));
        this.getSession(projectWithImportedReqifTestName);
        final EObject target = session.getSemanticElement(operationalAnalysis);
        if (target instanceof BlockArchitecture) {
            TransactionHelper.getExecutionManager((EObject)target).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    File file = IResourceHelpers.getFileOrFolderInTestPlugin(((Object)((Object)this)).getClass(), (String)ModelDiffTestCase3.inputFileName);
                    URI model = URI.createFileURI((String)file.getPath());
                    new TestRequirementsImportLauncher().launch(model, (BlockArchitecture)target, (IProgressMonitor)new NullProgressMonitor());
                }
            });
        }
        IModelScopeDefinition testFixtureScope = new CapellaScopeFactory().createScopeDefinition((Object)this.getTestModel(projectWithImportedReqifTestName).getUriSemanticFile(), "testFixtureModel", true);
        IModelScopeDefinition modelToTestScope = new CapellaScopeFactory().createScopeDefinition((Object)this.getTestModel(projectTestName).getUriSemanticFile(), "toTestModel", true);
        EComparisonImpl comparison = new EComparisonImpl(testFixtureScope.createScope((Object)this.getTestModel(projectWithImportedReqifTestName).getEditingDomain()), modelToTestScope.createScope((Object)this.getTestModel(projectTestName).getEditingDomain()));
        CapellaMatchPolicy custoMatchPolicy = new CapellaMatchPolicy();
        List<ConfigurableMatchPolicy.MatchCriterionKind> criteria = Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.NAME, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE);
        custoMatchPolicy.setAllUsedCriteria(criteria);
        List<ConfigurableMatchPolicy.FineGrainedMatchCriterion> fineGrainedCriteria = Arrays.asList(ConfigurableMatchPolicy.CRITERION_QNAMES_LABELS, ConfigurableMatchPolicy.CRITERION_STRUCTURE_ROOTS, ConfigurableMatchPolicy.CRITERION_STRUCTURE_CONTAINMENTS);
        custoMatchPolicy.setAllUsedFineGrainedCriteria(fineGrainedCriteria);
        comparison.compute((IMatchPolicy)custoMatchPolicy, (IDiffPolicy)new ReqIFImporterDiffPolicy(), (IMergePolicy)new ReqIFMergePolicy(), (IProgressMonitor)new NullProgressMonitor());
        List differencesFromReference = comparison.getDifferences(Role.REFERENCE);
        List differencesFromTarget = comparison.getDifferences(Role.TARGET);
        if (differencesFromReference.size() > 0 || differencesFromTarget.size() > 0) {
            ModelDiffTestCase3.fail((String)"There should not be any differences between the test model with ReqIf imported and the reference model");
        }
    }
}

