/**
 *
 *  Copyright (c) 2016, 2017 THALES GLOBAL SERVICES.
 *  All rights reserved. This program and the accompanying materials
 *  are made available under the terms of the Eclipse Public License v1.0
 *  which accompanies this distribution, and is available at
 *  http://www.eclipse.org/legal/epl-v10.html
 * 
 *  Contributors:
 *     Thales - initial API and implementation
 */

package org.polarsys.kitalpha.vp.requirements.Requirements.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.util.ResourceLocator;

import org.eclipse.emf.edit.domain.EditingDomain;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IChildCreationExtender;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.polarsys.kitalpha.emde.extension.edit.ChildCreationExtenderManager;

import org.polarsys.kitalpha.vp.requirements.Requirements.RequirementsPackage;

import org.polarsys.kitalpha.vp.requirements.Requirements.util.RequirementsAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class RequirementsItemProviderAdapterFactory extends RequirementsAdapterFactory
		implements ComposeableAdapterFactory, IChangeNotifier, IDisposable, IChildCreationExtender {
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = " Copyright (c) 2016 THALES GLOBAL SERVICES.\r\n All rights reserved. This program and the accompanying materials\r\n are made available under the terms of the Eclipse Public License v1.0\r\n which accompanies this distribution, and is available at\r\n http://www.eclipse.org/legal/epl-v10.html\r\n\r\n Contributors:\r\n    Thales - initial API and implementation"; //$NON-NLS-1$

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This helps manage the child creation extenders.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ChildCreationExtenderManager childCreationExtenderManager = new ChildCreationExtenderManager(
			RequirementsEditPlugin.INSTANCE, RequirementsPackage.eNS_URI);

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RequirementsItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InternalRelationItemProvider internalRelationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.InternalRelation}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createInternalRelationAdapter() {
		if (internalRelationItemProvider == null) {
			internalRelationItemProvider = new InternalRelationItemProvider(this);
		}

		return internalRelationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.StringValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected StringValueAttributeItemProvider stringValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.StringValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStringValueAttributeAdapter() {
		if (stringValueAttributeItemProvider == null) {
			stringValueAttributeItemProvider = new StringValueAttributeItemProvider(this);
		}

		return stringValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.IntegerValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IntegerValueAttributeItemProvider integerValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.IntegerValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createIntegerValueAttributeAdapter() {
		if (integerValueAttributeItemProvider == null) {
			integerValueAttributeItemProvider = new IntegerValueAttributeItemProvider(this);
		}

		return integerValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.BooleanValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected BooleanValueAttributeItemProvider booleanValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.BooleanValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBooleanValueAttributeAdapter() {
		if (booleanValueAttributeItemProvider == null) {
			booleanValueAttributeItemProvider = new BooleanValueAttributeItemProvider(this);
		}

		return booleanValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.RealValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RealValueAttributeItemProvider realValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.RealValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRealValueAttributeAdapter() {
		if (realValueAttributeItemProvider == null) {
			realValueAttributeItemProvider = new RealValueAttributeItemProvider(this);
		}

		return realValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.DateValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DateValueAttributeItemProvider dateValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.DateValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDateValueAttributeAdapter() {
		if (dateValueAttributeItemProvider == null) {
			dateValueAttributeItemProvider = new DateValueAttributeItemProvider(this);
		}

		return dateValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.Requirement} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RequirementItemProvider requirementItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.Requirement}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRequirementAdapter() {
		if (requirementItemProvider == null) {
			requirementItemProvider = new RequirementItemProvider(this);
		}

		return requirementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.Folder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected FolderItemProvider folderItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.Folder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createFolderAdapter() {
		if (folderItemProvider == null) {
			folderItemProvider = new FolderItemProvider(this);
		}

		return folderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.Module} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleItemProvider moduleItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.Module}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleAdapter() {
		if (moduleItemProvider == null) {
			moduleItemProvider = new ModuleItemProvider(this);
		}

		return moduleItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.TypesFolder} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected TypesFolderItemProvider typesFolderItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.TypesFolder}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTypesFolderAdapter() {
		if (typesFolderItemProvider == null) {
			typesFolderItemProvider = new TypesFolderItemProvider(this);
		}

		return typesFolderItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.ModuleType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ModuleTypeItemProvider moduleTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.ModuleType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createModuleTypeAdapter() {
		if (moduleTypeItemProvider == null) {
			moduleTypeItemProvider = new ModuleTypeItemProvider(this);
		}

		return moduleTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.RequirementType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RequirementTypeItemProvider requirementTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.RequirementType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRequirementTypeAdapter() {
		if (requirementTypeItemProvider == null) {
			requirementTypeItemProvider = new RequirementTypeItemProvider(this);
		}

		return requirementTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.RelationType} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RelationTypeItemProvider relationTypeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.RelationType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRelationTypeAdapter() {
		if (relationTypeItemProvider == null) {
			relationTypeItemProvider = new RelationTypeItemProvider(this);
		}

		return relationTypeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.DataTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DataTypeDefinitionItemProvider dataTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.DataTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createDataTypeDefinitionAdapter() {
		if (dataTypeDefinitionItemProvider == null) {
			dataTypeDefinitionItemProvider = new DataTypeDefinitionItemProvider(this);
		}

		return dataTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeDefinitionItemProvider attributeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeDefinitionAdapter() {
		if (attributeDefinitionItemProvider == null) {
			attributeDefinitionItemProvider = new AttributeDefinitionItemProvider(this);
		}

		return attributeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinitionEnumeration} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected AttributeDefinitionEnumerationItemProvider attributeDefinitionEnumerationItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.AttributeDefinitionEnumeration}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAttributeDefinitionEnumerationAdapter() {
		if (attributeDefinitionEnumerationItemProvider == null) {
			attributeDefinitionEnumerationItemProvider = new AttributeDefinitionEnumerationItemProvider(this);
		}

		return attributeDefinitionEnumerationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationValueAttribute} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumerationValueAttributeItemProvider enumerationValueAttributeItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationValueAttribute}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumerationValueAttributeAdapter() {
		if (enumerationValueAttributeItemProvider == null) {
			enumerationValueAttributeItemProvider = new EnumerationValueAttributeItemProvider(this);
		}

		return enumerationValueAttributeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationDataTypeDefinition} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumerationDataTypeDefinitionItemProvider enumerationDataTypeDefinitionItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumerationDataTypeDefinition}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumerationDataTypeDefinitionAdapter() {
		if (enumerationDataTypeDefinitionItemProvider == null) {
			enumerationDataTypeDefinitionItemProvider = new EnumerationDataTypeDefinitionItemProvider(this);
		}

		return enumerationDataTypeDefinitionItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EnumValueItemProvider enumValueItemProvider;

	/**
	 * This creates an adapter for a {@link org.polarsys.kitalpha.vp.requirements.Requirements.EnumValue}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createEnumValueAdapter() {
		if (enumValueItemProvider == null) {
			enumValueItemProvider = new EnumValueItemProvider(this);
		}

		return enumValueItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public List<IChildCreationExtender> getChildCreationExtenders() {
		return childCreationExtenderManager.getChildCreationExtenders();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain) {
		return childCreationExtenderManager.getNewChildDescriptors(object, editingDomain);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ResourceLocator getResourceLocator() {
		return childCreationExtenderManager;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void dispose() {
		if (internalRelationItemProvider != null)
			internalRelationItemProvider.dispose();
		if (stringValueAttributeItemProvider != null)
			stringValueAttributeItemProvider.dispose();
		if (integerValueAttributeItemProvider != null)
			integerValueAttributeItemProvider.dispose();
		if (booleanValueAttributeItemProvider != null)
			booleanValueAttributeItemProvider.dispose();
		if (realValueAttributeItemProvider != null)
			realValueAttributeItemProvider.dispose();
		if (dateValueAttributeItemProvider != null)
			dateValueAttributeItemProvider.dispose();
		if (requirementItemProvider != null)
			requirementItemProvider.dispose();
		if (folderItemProvider != null)
			folderItemProvider.dispose();
		if (moduleItemProvider != null)
			moduleItemProvider.dispose();
		if (typesFolderItemProvider != null)
			typesFolderItemProvider.dispose();
		if (moduleTypeItemProvider != null)
			moduleTypeItemProvider.dispose();
		if (requirementTypeItemProvider != null)
			requirementTypeItemProvider.dispose();
		if (relationTypeItemProvider != null)
			relationTypeItemProvider.dispose();
		if (dataTypeDefinitionItemProvider != null)
			dataTypeDefinitionItemProvider.dispose();
		if (attributeDefinitionItemProvider != null)
			attributeDefinitionItemProvider.dispose();
		if (attributeDefinitionEnumerationItemProvider != null)
			attributeDefinitionEnumerationItemProvider.dispose();
		if (enumerationValueAttributeItemProvider != null)
			enumerationValueAttributeItemProvider.dispose();
		if (enumerationDataTypeDefinitionItemProvider != null)
			enumerationDataTypeDefinitionItemProvider.dispose();
		if (enumValueItemProvider != null)
			enumValueItemProvider.dispose();
	}

}