/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.diffmerge.defer.helpers;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.EMapping;
import org.eclipse.emf.diffmerge.diffdata.EMatch;
import org.eclipse.emf.diffmerge.diffdata.EReferenceValuePresence;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.generic.api.diff.IDifference;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GdiffdataPackage;
import org.eclipse.emf.diffmerge.structures.common.FHashSet;
import org.eclipse.emf.diffmerge.structures.common.FLinkedList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;

public class TrimmingCopier
extends EcoreUtil.Copier {
    private static final long serialVersionUID = 1L;
    protected static final EReference EMATCH_CONTAINMENT = GdiffdataPackage.eINSTANCE.getGMapping_ModifiableContents();
    protected static final Role TARGET = Role.TARGET;
    protected final EComparison originalComparison;
    protected final List<EMatch> copyMatches;
    protected final Set<EObject> originalSourceElements;
    protected final Set<DRepresentationDescriptor> originalRepresentationDescriptors;

    public TrimmingCopier(EComparison comparison) {
        super(true, true);
        this.originalComparison = comparison;
        this.copyMatches = new FLinkedList();
        this.originalSourceElements = new FHashSet();
        this.originalRepresentationDescriptors = new FHashSet();
    }

    public EComparison copy() {
        EComparison result = (EComparison)this.copy((EObject)this.originalComparison);
        this.copyComparedContainments();
        this.copyReferences();
        return result;
    }

    public EObject copy(EObject originalElement) {
        return this.copy(originalElement, true);
    }

    protected EObject copy(EObject originalElement, boolean copyContents) {
        EObject result = null;
        if (originalElement != null && (result = this.createCopy(originalElement)) != null) {
            boolean isEMatch = result instanceof EMatch;
            if (isEMatch) {
                this.initMatch((EMatch)originalElement, (EMatch)result);
            }
            this.put(originalElement, result);
            this.copyFeatures(originalElement, result, copyContents);
            this.copyProxyURI(originalElement, result);
            if (isEMatch) {
                this.copyMatchHierarchy((EMatch)originalElement);
            }
        }
        return result;
    }

    protected void copyComparedContainments() {
        for (EObject originalElement : this.originalSourceElements) {
            try {
                this.copyComparedContainment(originalElement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void copyComparedContainment(EObject originalElement) {
        EObject copyContainer;
        EReference containment = originalElement.eContainmentFeature();
        EObject originalContainer = originalElement.eContainer();
        if (originalContainer != null && containment != null && (copyContainer = (EObject)this.get(originalContainer)) != null) {
            EObject copyElement = (EObject)this.get(originalElement);
            EStructuralFeature.Setting copyContainerSetting = ((InternalEObject)copyContainer).eSetting((EStructuralFeature)containment);
            if (containment.isMany()) {
                Object value = copyContainerSetting.get(true);
                ((List)value).add(copyElement);
            } else {
                copyContainerSetting.set((Object)copyElement);
            }
        }
    }

    protected void copyContainment(EReference containment, EObject originalElement, EObject copyElement) {
        if (originalElement == this.originalComparison.getMapping() && containment == EMATCH_CONTAINMENT) {
            this.copyMatchContainment((EMapping)originalElement, (EMapping)copyElement);
        } else {
            super.copyContainment(containment, originalElement, copyElement);
        }
    }

    protected void copyFeatures(EObject originalElement, EObject copyElement, boolean copyContents) {
        EClass eClass = originalElement.eClass();
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature eStructuralFeature = eClass.getEStructuralFeature(i);
            if (eStructuralFeature.isChangeable() && !eStructuralFeature.isDerived() || eStructuralFeature == EMATCH_CONTAINMENT) {
                if (eStructuralFeature instanceof EAttribute) {
                    this.copyAttribute((EAttribute)eStructuralFeature, originalElement, copyElement);
                } else {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment() && copyContents) {
                        this.copyContainment(eReference, originalElement, copyElement);
                    }
                }
            }
            ++i;
        }
    }

    protected void copyMatchContainment(EMapping originalMapping, EMapping copyMapping) {
        EStructuralFeature.Setting setting;
        if (originalMapping.eIsSet((EStructuralFeature)EMATCH_CONTAINMENT) && (setting = ((InternalEObject)copyMapping).eSetting((EStructuralFeature)EMATCH_CONTAINMENT)) != null) {
            Object rawValue = originalMapping.eGet((EStructuralFeature)EMATCH_CONTAINMENT);
            List sourceValues = (List)rawValue;
            for (EObject sourceValue : sourceValues) {
                Collection<EMatch> selectedOriginalMatches = this.getSelectedOriginalMatches((EMatch)sourceValue);
                for (EMatch selectedOriginalMatch : selectedOriginalMatches) {
                    if (this.get(selectedOriginalMatch) != null) continue;
                    this.copy((EObject)selectedOriginalMatch);
                }
            }
            setting.set(this.copyMatches);
        }
    }

    protected void copyMatchHierarchy(EMatch originalMatch) {
        EMatch sourceContainerMatch;
        IEditableTreeDataScope originalScope;
        EObject comparedContainer;
        Role side = TARGET;
        EObject comparedElement = (EObject)originalMatch.get(side);
        if (comparedElement == null) {
            side = side.opposite();
            comparedElement = (EObject)originalMatch.get(side);
        }
        if ((comparedContainer = (EObject)(originalScope = this.originalComparison.getScope(side)).getContainer((Object)comparedElement)) != null && (sourceContainerMatch = this.originalComparison.getMapping().getMatchFor((Object)comparedContainer, side)) != null && this.get(sourceContainerMatch) == null) {
            this.copy((EObject)sourceContainerMatch);
        }
    }

    protected void copyReference(EReference eReference, EObject eObject, EObject copyEObject) {
        EStructuralFeature.Setting setting;
        if (eObject.eIsSet((EStructuralFeature)eReference) && (setting = this.getTarget((EStructuralFeature)eReference, eObject, copyEObject)) != null) {
            Object value = eObject.eGet((EStructuralFeature)eReference, this.resolveProxies);
            if (eReference.isMany()) {
                InternalEList source = (InternalEList)value;
                InternalEList target = (InternalEList)setting;
                if (source.isEmpty()) {
                    target.clear();
                } else {
                    boolean isBidirectional = eReference.getEOpposite() != null;
                    int index = 0;
                    Iterator k = this.resolveProxies ? source.iterator() : source.basicIterator();
                    while (k.hasNext()) {
                        EObject referencedEObject = (EObject)k.next();
                        EObject copyReferencedEObject = (EObject)this.get(referencedEObject);
                        if (copyReferencedEObject == null) {
                            if (!this.useOriginalReferences || isBidirectional) continue;
                            EMatch match = this.originalComparison.getMapping().getMatchFor((Object)referencedEObject, TARGET.opposite());
                            if (match != null && !match.isPartial()) {
                                referencedEObject = (EObject)match.get(TARGET);
                            }
                            target.addUnique(index, (Object)referencedEObject);
                            ++index;
                            continue;
                        }
                        if (isBidirectional) {
                            int position = target.indexOf((Object)copyReferencedEObject);
                            if (position == -1) {
                                target.addUnique(index, (Object)copyReferencedEObject);
                            } else if (index != position) {
                                target.move(index, (Object)copyReferencedEObject);
                            }
                        } else {
                            target.addUnique(index, (Object)copyReferencedEObject);
                        }
                        ++index;
                    }
                }
            } else if (value == null) {
                setting.set(null);
            } else {
                EObject copyReferencedEObject = (EObject)this.get(value);
                if (copyReferencedEObject == null) {
                    if (this.useOriginalReferences && eReference.getEOpposite() == null) {
                        EMatch match = this.originalComparison.getMapping().getMatchFor(value, TARGET.opposite());
                        if (match != null && !match.isPartial()) {
                            value = match.get(TARGET);
                        }
                        setting.set(value);
                    }
                } else {
                    setting.set((Object)copyReferencedEObject);
                }
            }
        }
    }

    protected EObject createCopy(EObject eObject) {
        EObject result = super.createCopy(eObject);
        if (eObject instanceof DRepresentationDescriptor && result instanceof DRepresentationDescriptor) {
            this.originalRepresentationDescriptors.add((DRepresentationDescriptor)eObject);
        }
        return result;
    }

    public Set<DRepresentationDescriptor> getOriginalRepresentationDescriptors() {
        return this.originalRepresentationDescriptors;
    }

    public Collection<EObject> getOriginalSourceElements() {
        return this.originalSourceElements;
    }

    protected Collection<EMatch> getSelectedOriginalMatches(EMatch originalMatch) {
        FHashSet result = new FHashSet();
        if (!originalMatch.getAllDifferences().isEmpty()) {
            result.add(originalMatch);
            for (IDifference difference : originalMatch.getRelatedDifferences()) {
                if (!(difference instanceof EReferenceValuePresence)) continue;
                EMatch valueMatch = ((EReferenceValuePresence)difference).getValueMatch();
                result.add(valueMatch);
            }
        }
        return result;
    }

    protected void initMatch(EMatch originalMatch, EMatch copyMatch) {
        copyMatch.set(TARGET, (Object)((EObject)originalMatch.get(TARGET)));
        EObject originalComparedElement = (EObject)originalMatch.get(TARGET.opposite());
        if (originalComparedElement != null) {
            EObject copyComparedElement = this.copy(originalComparedElement, false);
            copyMatch.set(TARGET.opposite(), (Object)copyComparedElement);
            this.originalSourceElements.add(originalComparedElement);
        }
        this.copyMatches.add(copyMatch);
    }
}

