/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.cybersecurity.test.queries;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.junit.Assert;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.cybersecurity.business.queries.EnterprisePrimaryAsset_PrimaryAssets;
import org.polarsys.capella.cybersecurity.model.CybersecurityFactory;
import org.polarsys.capella.cybersecurity.model.CybersecurityPkg;
import org.polarsys.capella.cybersecurity.model.EnterprisePrimaryAsset;
import org.polarsys.capella.cybersecurity.model.FunctionalPrimaryAsset;
import org.polarsys.capella.cybersecurity.model.InformationPrimaryAsset;
import org.polarsys.capella.cybersecurity.sirius.analysis.CybersecurityServices;
import org.polarsys.capella.cybersecurity.test.queries.CybersecurityQueriesTest;

public class EnterprisePrimaryAsset_PrimaryAssetsTest
extends CybersecurityQueriesTest {
    private void executeTestQueryOnArh(final BlockArchitecture arh) {
        final EnterprisePrimaryAsset epa = CybersecurityFactory.eINSTANCE.createEnterprisePrimaryAsset();
        final InformationPrimaryAsset ipa = CybersecurityFactory.eINSTANCE.createInformationPrimaryAsset();
        final FunctionalPrimaryAsset fpa = CybersecurityFactory.eINSTANCE.createFunctionalPrimaryAsset();
        AbstractReadWriteCommand cmd = new AbstractReadWriteCommand(){

            public void run() {
                CybersecurityPkg cyberPkg = new CybersecurityServices().getDefaultCyberSecurityPackage((EObject)arh, true);
                cyberPkg.getOwnedPrimaryAssets().add((Object)epa);
                cyberPkg.getOwnedPrimaryAssets().add((Object)ipa);
                cyberPkg.getOwnedPrimaryAssets().add((Object)fpa);
            }
        };
        TransactionHelper.getExecutionManager((EObject)this.project).execute((ICommand)cmd);
        List elements = new EnterprisePrimaryAsset_PrimaryAssets().getAvailableElements((EObject)epa);
        ArrayList<Object> expectedElements = new ArrayList<Object>();
        expectedElements.add(ipa);
        expectedElements.add(fpa);
        Assert.assertEquals(expectedElements, (Object)elements);
    }

    @Override
    protected void doTest() {
        this.executeTestQueryOnArh(this.laArch);
        this.executeTestQueryOnArh(this.saArch);
        this.executeTestQueryOnArh(this.paArch);
    }
}

