/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.model2ecore.command;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.information.AggregationKind;
import org.polarsys.capella.core.data.information.Association;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Operation;
import org.polarsys.capella.core.data.information.Parameter;
import org.polarsys.capella.core.data.information.ParameterDirection;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.information.datavalue.LiteralNumericValue;
import org.polarsys.capella.model2ecore.command.AbstractEcoreExporterCommand;
import org.polarsys.capella.model2ecore.internal.converters.ClassConverter;
import org.polarsys.capella.model2ecore.internal.converters.DataTypeConverter;
import org.polarsys.capella.model2ecore.internal.util.AbstractModelElementHandler;
import org.polarsys.capella.model2ecore.internal.util.ModelHelper;

public class DataPkgToEcoreExporterCommand
extends AbstractEcoreExporterCommand {
    private List<Association> _capellaAssociations = new ArrayList<Association>(0);

    public DataPkgToEcoreExporterCommand() {
    }

    public DataPkgToEcoreExporterCommand(Map<ModelElement, EClassifier> capellaToEcoreMappings, Map<AbstractDependenciesPkg, EPackage> packagesMappings) {
        super(capellaToEcoreMappings, packagesMappings);
    }

    private void addDelegationAnnotation(AbstractDependenciesPkg pkg, EPackage ecorePackage) {
        EAnnotation delegationAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        ecorePackage.getEAnnotations().add((Object)delegationAnnotation);
        delegationAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore");
        EMap annotationEntries = delegationAnnotation.getDetails();
        annotationEntries.put((Object)"invocationDelegates", (Object)ModelHelper.getPackageDelegationAnnotationName(pkg));
    }

    protected void createEAttribute(EClass ownerClass, Property capellaAttribute) {
        EAttribute ecoreAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        ownerClass.getEStructuralFeatures().add((Object)ecoreAttribute);
        ecoreAttribute.setName(ModelHelper.forceCharactersToEcoreNamingConventions(capellaAttribute.getName()));
        ecoreAttribute.setUpperBound(ModelHelper.getValue((LiteralNumericValue)capellaAttribute.getOwnedMaxCard()));
        ecoreAttribute.setLowerBound(ModelHelper.getValue((LiteralNumericValue)capellaAttribute.getOwnedMinCard()));
        AbstractType capellaAttributeType = capellaAttribute.getAbstractType();
        EClassifier ecoreDataType = this.getEcoreType(capellaAttributeType);
        ecoreAttribute.setEType(ecoreDataType);
        ecoreAttribute.setID(capellaAttribute.isUnique());
    }

    protected void createEOperation(EClass ownerClass, Operation capellaOperation) {
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        eOperation.setName(ModelHelper.forceCharactersToEcoreNamingConventions(capellaOperation.getName()));
        ownerClass.getEOperations().add((Object)eOperation);
        EAnnotation delegationAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        AbstractDependenciesPkg capellaPackage = (AbstractDependenciesPkg)EcoreUtil2.getFirstContainer((EObject)capellaOperation, (EClass)CapellacorePackage.Literals.ABSTRACT_DEPENDENCIES_PKG);
        delegationAnnotation.setSource(ModelHelper.getPackageDelegationAnnotationName(capellaPackage));
        eOperation.getEAnnotations().add((Object)delegationAnnotation);
        for (Parameter currentParameter : capellaOperation.getOwnedParameters()) {
            EOperation ecoreElement = null;
            String name = null;
            if (ParameterDirection.RETURN.equals((Object)currentParameter.getDirection())) {
                ecoreElement = eOperation;
            } else {
                EParameter ecoreParameter = EcoreFactory.eINSTANCE.createEParameter();
                eOperation.getEParameters().add((Object)ecoreParameter);
                ecoreElement = ecoreParameter;
                name = currentParameter.getName();
            }
            AbstractType capellaType = currentParameter.getAbstractType();
            EClassifier ecoreType = this.getEcoreType(capellaType);
            ecoreElement.setEType(ecoreType);
            if (name != null) {
                ecoreElement.setName(ModelHelper.forceCharactersToEcoreNamingConventions(name));
            }
            ecoreElement.setLowerBound(ModelHelper.getValue((LiteralNumericValue)currentParameter.getOwnedMinCard()));
            ecoreElement.setUpperBound(ModelHelper.getValue((LiteralNumericValue)currentParameter.getOwnedMaxCard()));
        }
    }

    protected EReference createEReference(ModelElement capellaClassOwner, Property relationProperty) {
        EReference reference = EcoreFactory.eINSTANCE.createEReference();
        EClass ecoreClassOwner = (EClass)this.getEcoreType((AbstractType)capellaClassOwner);
        ecoreClassOwner.getEStructuralFeatures().add((Object)reference);
        AbstractType capellaTargetClass = relationProperty.getAbstractType();
        reference.setEType(this.getEcoreType(capellaTargetClass));
        reference.setUpperBound(ModelHelper.getValue((LiteralNumericValue)relationProperty.getOwnedMaxCard()));
        reference.setLowerBound(ModelHelper.getValue((LiteralNumericValue)relationProperty.getOwnedMinCard()));
        reference.setName(ModelHelper.forceCharactersToEcoreNamingConventions(relationProperty.getName()));
        AggregationKind aggregationKind = relationProperty.getAggregationKind();
        reference.setContainment(AggregationKind.COMPOSITION == aggregationKind || AggregationKind.AGGREGATION == aggregationKind);
        return reference;
    }

    @Override
    protected void dispose() {
        super.dispose();
        this._capellaAssociations.clear();
    }

    protected void handleAttributes(Class capellaClass, EClass relatedEcoreClass) {
        for (Property currentProperty : capellaClass.getContainedProperties()) {
            AbstractType abstractType = currentProperty.getAbstractType();
            EClassifier ecoreDataType = this.getEcoreType(abstractType);
            if (!(abstractType instanceof DataType)) continue;
            if (ecoreDataType instanceof EDataType) {
                this.createEAttribute(relatedEcoreClass, currentProperty);
                continue;
            }
            if (!(ecoreDataType instanceof EClass)) continue;
            this.createEReference((ModelElement)capellaClass, currentProperty);
        }
    }

    protected void handleClasses() {
        HashMap<ModelElement, EClassifier> capellaToEcoreMappings = new HashMap<ModelElement, EClassifier>(this.getCapellaToEcoreMappings());
        for (Map.Entry entry : capellaToEcoreMappings.entrySet()) {
            EObject key = (EObject)entry.getKey();
            if (!(key instanceof Class)) continue;
            Class currentCapellaClass = (Class)key;
            this.handleAttributes(currentCapellaClass, (EClass)entry.getValue());
            this.handleEClassSuperType(currentCapellaClass, (EClass)entry.getValue());
            this.handleEOperations(currentCapellaClass, (EClass)entry.getValue());
        }
    }

    protected void handleEClassSuperType(Class currentCapellaClass, EClass relatedEcoreClass) {
        for (Generalization currentGeneralization : currentCapellaClass.getOwnedGeneralizations()) {
            GeneralizableElement superType = currentGeneralization.getSuper();
            EClassifier ecoreSuperType = this.getEcoreType((AbstractType)superType);
            if (!(ecoreSuperType instanceof EClass)) continue;
            relatedEcoreClass.getESuperTypes().add((Object)((EClass)ecoreSuperType));
        }
    }

    protected void handleEOperations(Class capellaClass, EClass value) {
        for (Operation currentOperation : capellaClass.getContainedOperations()) {
            this.createEOperation(value, currentOperation);
        }
    }

    protected void handlePackageContentWalk(DataPkg pkg, EPackage ecorePackage) {
        this.addDelegationAnnotation((AbstractDependenciesPkg)pkg, ecorePackage);
        AbstractModelElementHandler handler = new AbstractModelElementHandler(){
            private ClassConverter _informationSwitch = new ClassConverter();
            private DataTypeConverter _dataTypeEcoreSwitch = new DataTypeConverter();

            @Override
            public Couple<EClassifier, Boolean> handleElement(ModelElement element, EPackage parentPackage, AbstractEcoreExporterCommand exporter) {
                boolean shouldPersistInResultingEcore = true;
                EClassifier classifier = null;
                if (element instanceof Class) {
                    classifier = (EClassifier)this._informationSwitch.doSwitch((EObject)element);
                } else if (element instanceof DataType) {
                    classifier = (EClassifier)this._dataTypeEcoreSwitch.doSwitch((EObject)element);
                    shouldPersistInResultingEcore = !EcorePackage.eINSTANCE.equals(classifier.eContainer());
                } else if (element instanceof Association) {
                    DataPkgToEcoreExporterCommand.this._capellaAssociations.add((Association)element);
                } else if (element instanceof DataPkg) {
                    DataPkg subCapellaPackage = (DataPkg)element;
                    EPackage subEcorePackage = DataPkgToEcoreExporterCommand.this.createEPackage((AbstractDependenciesPkg)subCapellaPackage);
                    DataPkgToEcoreExporterCommand.this.addDelegationAnnotation((AbstractDependenciesPkg)subCapellaPackage, subEcorePackage);
                    exporter.walkThroughPackageContent((AbstractDependenciesPkg)subCapellaPackage, subEcorePackage, this);
                    parentPackage.getESubpackages().add((Object)subEcorePackage);
                }
                return new Couple((Object)classifier, (Object)shouldPersistInResultingEcore);
            }
        };
        this.walkThroughPackageContent((AbstractDependenciesPkg)pkg, ecorePackage, handler);
    }

    protected void handleReferences() {
        for (Association currentAssociation : this._capellaAssociations) {
            EList ownedMembers = currentAssociation.getOwnedMembers();
            if (ownedMembers.isEmpty()) {
                Property property = (Property)currentAssociation.getNavigableMembers().get(0);
                AbstractType type = property.getAbstractType();
                Property oppositeProperty = (Property)currentAssociation.getNavigableMembers().get(1);
                AbstractType oppositeType = oppositeProperty.getAbstractType();
                EReference reference = this.createEReference((ModelElement)oppositeType, property);
                EReference oppositeReference = this.createEReference((ModelElement)type, oppositeProperty);
                reference.setEOpposite(oppositeReference);
                oppositeReference.setEOpposite(reference);
                continue;
            }
            Property sourceProperty = (Property)ownedMembers.get(0);
            AbstractType capellaSourceContainer = sourceProperty.getAbstractType();
            Property targetProperty = (Property)currentAssociation.getNavigableMembers().get(0);
            this.createEReference((ModelElement)capellaSourceContainer, targetProperty);
        }
    }

    @Override
    protected void exportPackage(AbstractDependenciesPkg capellaRootPackage, EPackage ecorePackage) {
        this.handlePackageContentWalk((DataPkg)capellaRootPackage, ecorePackage);
        this.handleClasses();
        this.handleReferences();
    }
}

