/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.ui.view;

import java.io.File;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.polarsys.capella.command.recorder.core.manager.AbstractRecorderManager;
import org.polarsys.capella.command.recorder.core.writer.TXTRecordReader;
import org.polarsys.capella.command.recorder.ui.handler.CapellaRecorderHandler;
import org.polarsys.capella.command.recorder.ui.messages.CapellaRecorderUIMessages;
import org.polarsys.capella.command.recorder.ui.view.AbstractRecorderView;
import org.polarsys.capella.command.recorder.ui.view.CapellaRecorderContentProvider;
import org.polarsys.capella.command.recorder.ui.view.CapellaRecorderLabelProvider;

public class CapellaRecorderView
extends AbstractRecorderView {
    protected ITreeContentProvider _contentProvider = new CapellaRecorderContentProvider();
    protected ITableLabelProvider _labelProvider = new CapellaRecorderLabelProvider();

    @Override
    protected TreeViewer createTreeViewer(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent);
        Tree tree = treeViewer.getTree();
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        TreeColumn column1 = new TreeColumn(tree, 16384);
        column1.setText(CapellaRecorderUIMessages.capellaRecorderView_column1);
        column1.setWidth(300);
        TreeColumn column2 = new TreeColumn(tree, 0x1000000);
        column2.setText(CapellaRecorderUIMessages.capellaRecorderView_column2);
        column2.setWidth(200);
        return treeViewer;
    }

    @Override
    protected ITreeContentProvider getContentProvider() {
        return this._contentProvider;
    }

    @Override
    protected ITableLabelProvider getLabelProvider() {
        return this._labelProvider;
    }

    @Override
    protected boolean loadRecord(File file) {
        TXTRecordReader reader = new TXTRecordReader(file);
        reader.parse();
        this._treeViewer.setInput((Object)reader.getData());
        return true;
    }

    @Override
    protected AbstractRecorderManager getRecorderManager() {
        return (AbstractRecorderManager)CapellaRecorderHandler.INSTANCE.getRecorder();
    }
}

