/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.view.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class DropDownAction
extends Action
implements IMenuCreator {
    private Menu menu;
    private List<IAction> actions = new ArrayList<IAction>();
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if ("checked".equals(event.getProperty()) && Boolean.TRUE.equals(event.getNewValue())) {
                DropDownAction.this.actionChecked((IAction)event.getSource());
            }
        }
    };

    public DropDownAction() {
        this.setMenuCreator(this);
    }

    public void addAction(IAction action) {
        this.actions.add(action);
        action.addPropertyChangeListener(this.listener);
        if (action.isChecked()) {
            this.actionChecked(action);
        }
    }

    private void actionChecked(IAction action) {
        this.setImageDescriptor(action.getImageDescriptor());
        this.setText(action.getText());
    }

    public Menu getMenu(Control parent) {
        if (this.menu == null) {
            this.menu = new Menu(parent);
            for (IAction action : this.actions) {
                this.addAction(this.menu, action);
            }
        }
        return this.menu;
    }

    private void addAction(Menu m, IAction action) {
        ActionContributionItem contrib = new ActionContributionItem(action);
        contrib.fill(m, -1);
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public void run() {
        for (IAction action : this.actions) {
            if (!action.isChecked()) continue;
            action.run();
        }
    }
}

