/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.patterns.templates;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.expressions.Variable;

public class OperationSignature {
    private final EClassifier _owner;
    private final String _name;
    private final EClassifier _type;
    private final boolean _isMany;
    private final List<Variable<EClassifier, EParameter>> _parameters;

    public OperationSignature(EClassifier owner, String name, EClassifier type, boolean isMany, List<Variable<EClassifier, EParameter>> parameters) {
        this._owner = owner;
        this._name = name;
        this._type = type;
        this._isMany = isMany;
        this._parameters = parameters;
    }

    public OperationSignature(EClassifier owner, String name, EClassifier type, boolean isMany) {
        this(owner, name, type, isMany, Collections.emptyList());
    }

    public OperationSignature(EOperation operation) {
        this((EClassifier)operation.getEContainingClass(), operation.getName(), operation.getEType(), operation.isMany());
    }

    private Constraint createConstraint() {
        return EcoreFactory.eINSTANCE.createConstraint();
    }

    public void defineIn(EcoreEnvironment env) {
        EOperation op = env.defineOperation(this.getOwner(), this.getName(), this.getType(), this.getParameters(), this.createConstraint());
        if (this._isMany) {
            op.setUpperBound(-1);
        }
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof OperationSignature) {
            OperationSignature peer = (OperationSignature)obj;
            result = this.getName().equals(peer.getName());
        }
        return result;
    }

    public String getName() {
        return this._name;
    }

    public EClassifier getOwner() {
        return this._owner;
    }

    public List<Variable<EClassifier, EParameter>> getParameters() {
        return Collections.unmodifiableList(this._parameters);
    }

    public EClassifier getType() {
        return this._type;
    }

    public boolean isMany() {
        return this._isMany;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }
}

