/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.level;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.helper.ConstraintKind;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.utilities.UMLReflection;
import org.polarsys.capella.ocl.requester.console.IOCLFactory;
import org.polarsys.capella.ocl.requester.internal.l10n.OCLInterpreterMessages;

public enum ModelingLevel {
    M2,
    M2Simplified,
    M1;


    public <C, O, P> ConstraintKind setContext(OCLHelper<C, O, P, ?> helper, EObject element, IOCLFactory<C> factory) throws ParserException {
        switch (this) {
            case M2: 
            case M2Simplified: {
                C contextClassifier = factory.getContextClassifier(element);
                if (contextClassifier == null) {
                    throw new ParserException(OCLInterpreterMessages.console_badContextForQuery);
                }
                helper.setContext(contextClassifier);
                return ConstraintKind.INVARIANT;
            }
            case M1: {
                UMLReflection uml = helper.getOCL().getEnvironment().getUMLReflection();
                if (uml.isClassifier((Object)element)) {
                    EObject classifier = element;
                    helper.setContext((Object)classifier);
                    return ConstraintKind.INVARIANT;
                }
                if (uml.isOperation((Object)element)) {
                    EObject operation = element;
                    Object classifier = uml.getOwningClassifier((Object)operation);
                    helper.setOperationContext(classifier, (Object)operation);
                    return ConstraintKind.POSTCONDITION;
                }
                if (uml.isProperty((Object)element)) {
                    EObject property = element;
                    Object classifier = uml.getOwningClassifier((Object)property);
                    helper.setAttributeContext(classifier, (Object)property);
                    return ConstraintKind.DERIVATION;
                }
                throw new ParserException(OCLInterpreterMessages.console_badContextForConstraint);
            }
        }
        return null;
    }
}

