/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.ocl.requester.console.text;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCL;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.helper.Choice;
import org.eclipse.ocl.helper.OCLHelper;
import org.eclipse.ocl.utilities.OCLFactory;
import org.eclipse.ocl.utilities.UMLReflection;
import org.polarsys.capella.ocl.requester.console.IOCLFactory;
import org.polarsys.capella.ocl.requester.console.text.OCLPartitionScanner;
import org.polarsys.capella.ocl.requester.level.ModelingLevel;

public class OCLDocument
extends Document {
    private EObject context;
    private Map<String, EClassifier> parameters;
    private IOCLFactory<Object> oclFactory;
    private ModelingLevel level;

    public OCLDocument(String initialContent) {
        super(initialContent);
        FastPartitioner partitioner = new FastPartitioner((IPartitionTokenScanner)new OCLPartitionScanner(), new String[]{"__ocl_comment"});
        partitioner.connect((IDocument)this);
        this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public OCLDocument() {
        this(null);
    }

    public void setOCLContext(EObject context) {
        this.context = context;
    }

    public EObject getOCLContext() {
        return this.context;
    }

    public void setOCLParameters(Map<String, EClassifier> parameters) {
        this.parameters = parameters;
    }

    public Map<String, EClassifier> getOCLParameters() {
        return this.parameters;
    }

    public void setOCLFactory(IOCLFactory<Object> factory) {
        this.oclFactory = factory;
    }

    public IOCLFactory<Object> getOCLFactory() {
        return this.oclFactory;
    }

    public void setModelingLevel(ModelingLevel level) {
        this.level = level;
    }

    public ModelingLevel getModelingLevel() {
        return this.level;
    }

    public List<Choice> getOCLChoices(int offset) {
        if (this.context == null) {
            return Collections.emptyList();
        }
        try {
            String text = this.get(0, offset);
            OCL ocl = this.oclFactory.createOCL(this.getModelingLevel());
            OCLHelper helper = ocl.createOCLHelper();
            if (this.parameters != null) {
                Environment environment = helper.getEnvironment();
                OCLFactory oclFactory = environment.getOCLFactory();
                UMLReflection umlReflection = environment.getUMLReflection();
                for (Map.Entry<String, EClassifier> entry : this.parameters.entrySet()) {
                    Variable variable = oclFactory.createVariable();
                    variable.setName(entry.getKey());
                    variable.setType(umlReflection.getOCLType((Object)entry.getValue()));
                    environment.addElement(entry.getKey(), variable, true);
                }
            }
            return helper.getSyntaxHelp(this.level.setContext(helper, this.context, this.oclFactory), text);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

