/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.core.writer;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.command.recorder.core.preferences.RecorderCorePreferenceServices;
import org.polarsys.capella.command.recorder.core.writer.DefaultNameResolver;
import org.polarsys.capella.command.recorder.core.writer.INameResolver;

public class TXTWriterHelper {
    public static final String LINE_SEPARATOR;
    public static String ENTRY_TAG;
    public static String SUBENTRY_TAG;
    public static String EXTRADATA_TAG;

    static {
        String s = System.getProperty("line.separator");
        LINE_SEPARATOR = s == null ? "\n" : s;
        ENTRY_TAG = "!ENTRY";
        SUBENTRY_TAG = "!SUBENTRY";
        EXTRADATA_TAG = "!DATA";
    }

    public static void writeln(Writer writer, String line) throws IOException {
        if (writer != null) {
            writer.write(line);
            TXTWriterHelper.writeln(writer);
        }
    }

    public static void writeln(Writer writer) throws IOException {
        if (writer != null) {
            writer.write(LINE_SEPARATOR);
        }
    }

    public static void writeEntry(Writer writer, String line) throws IOException {
        if (writer != null) {
            TXTWriterHelper.writeln(writer, String.valueOf(ENTRY_TAG) + ' ' + line);
        }
    }

    public static void writeSubEntry(Writer writer, int depth, String line) throws IOException {
        if (writer != null) {
            TXTWriterHelper.writeln(writer, String.valueOf(SUBENTRY_TAG) + ' ' + depth + ' ' + line);
        }
    }

    public static void writeExtraDataLine(Writer writer, String line) throws IOException {
        if (writer != null) {
            TXTWriterHelper.writeln(writer, String.valueOf(EXTRADATA_TAG) + ' ' + line);
        }
    }

    public static void writeSubEntryForEObject(Writer writer, EObject eobject, INameResolver nameResolver, int depth, boolean withContents) throws IOException {
        INameResolver resolver = nameResolver == null ? new DefaultNameResolver() : nameResolver;
        String id = resolver.getID(eobject);
        String str = resolver.getReadableName(eobject);
        if (id != null && !"".equals(id)) {
            str = String.valueOf(str) + " id::" + id;
        }
        TXTWriterHelper.writeSubEntry(writer, depth, str);
        if (RecorderCorePreferenceServices.isExtraDataShouldBeSerialized()) {
            EClass eClass = eobject.eClass();
            String uri = eClass.getEPackage().getNsURI();
            TXTWriterHelper.writeExtraDataLine(writer, String.valueOf(eClass.getName()) + ' ' + uri);
        }
        if (withContents) {
            for (EObject current : eobject.eContents()) {
                TXTWriterHelper.writeSubEntryForEObject(writer, current, resolver, depth + 1, true);
            }
        }
    }
}

