/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.command.recorder.core.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.polarsys.capella.command.recorder.core.output.IOutputManager;
import org.polarsys.capella.command.recorder.core.output.OutputHelper;
import org.polarsys.capella.command.recorder.core.recorder.IRecorder;

public class OutputRecorder
implements IOutputManager {
    private Map<IRecorder, OutputData> _map = new HashMap<IRecorder, OutputData>();

    @Override
    public Writer getWriter(IRecorder recorder) {
        boolean shouldChangeOfFile = false;
        OutputData data = null;
        if (this._map.containsKey(recorder)) {
            data = this._map.get(recorder);
        } else {
            data = new OutputData();
            this._map.put(recorder, data);
        }
        if (data.getWriter() == null) {
            shouldChangeOfFile = true;
        } else if (data.getFile() != null && OutputHelper.isOverSized(data.getFile())) {
            shouldChangeOfFile = true;
        }
        if (shouldChangeOfFile) {
            data.setFile(OutputHelper.createNewLogFile(recorder));
            data.setWriter();
        }
        return data.getWriter();
    }

    @Override
    public void registerRecorder(IRecorder recorder, boolean isNewRecordFileShouldBeCreated) {
        File dir = OutputHelper.getDir(recorder);
        if (!dir.exists()) {
            dir.mkdir();
        }
        OutputData data = null;
        if (this._map.containsKey(recorder)) {
            this.removeRecorder(recorder);
        }
        data = new OutputData();
        this._map.put(recorder, data);
        if (isNewRecordFileShouldBeCreated) {
            data.setFile(OutputHelper.createNewLogFile(recorder));
        } else {
            File lastAvailable;
            List<File> recordFiles = OutputHelper.getRecordFiles(recorder);
            File file = null;
            file = !recordFiles.isEmpty() ? (OutputHelper.isOverSized(lastAvailable = recordFiles.get(0)) || OutputHelper.isOutOfTime(lastAvailable, null) ? OutputHelper.createNewLogFile(recorder) : recordFiles.get(0)) : OutputHelper.createNewLogFile(recorder);
            data.setFile(file);
            data.setWriter();
        }
    }

    @Override
    public void removeRecorder(IRecorder recorder) {
        OutputData data = this._map.get(recorder);
        if (data != null) {
            data.clear();
            this._map.remove(recorder);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public void dispose() {
        for (OutputData data : this._map.values()) {
            data.clear();
        }
        this._map.clear();
    }

    protected class OutputData {
        private File _file = null;
        private Writer _writer = null;

        protected OutputData() {
        }

        public File getFile() {
            return this._file;
        }

        public Writer getWriter() {
            return this._writer;
        }

        public void clear() {
            if (this._writer != null) {
                try {
                    this._writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this._writer = null;
            }
        }

        public void setFile(File file) {
            this._file = file;
        }

        public void setWriter() {
            if (this._file != null) {
                try {
                    if (this._writer != null) {
                        this._writer.close();
                    }
                    FileOutputStream stream = new FileOutputStream(this._file, true);
                    this._writer = OutputHelper.logForStream(stream);
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

