/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Preconditions;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.TaskNodeSelectionUtils;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;

public final class TreeViewerDoubleClickListener
implements IDoubleClickListener {
    private final String commandId;
    private final TreeViewer treeViewer;

    public TreeViewerDoubleClickListener(String commandId, TreeViewer treeViewer) {
        this.commandId = (String)Preconditions.checkNotNull((Object)commandId);
        this.treeViewer = (TreeViewer)Preconditions.checkNotNull((Object)treeViewer);
    }

    public void doubleClick(DoubleClickEvent event) {
        NodeSelection selection = NodeSelection.from(this.treeViewer.getSelection());
        if (this.isEnabledFor(selection)) {
            this.run();
        }
    }

    private boolean isEnabledFor(NodeSelection node) {
        return TaskNodeSelectionUtils.isValidRunConfiguration(node);
    }

    private void run() {
        try {
            this.getHandlerService().executeCommand(this.commandId, null);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot execute command '%s'.", this.commandId), e);
        }
    }

    private IHandlerService getHandlerService() {
        return (IHandlerService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(IHandlerService.class);
    }
}

