/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.product;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.iproduct.IProduct;
import org.eclipse.pde.internal.launching.launcher.LaunchPluginValidator;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.ProductValidationOperation;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.LaunchAction;
import org.eclipse.swt.widgets.Shell;

public class ProductValidateAction
extends Action {
    IProduct fProduct;

    public ProductValidateAction(IProduct product) {
        super(PDEUIMessages.ProductValidateAction_validate, 1);
        this.setImageDescriptor(PDEPluginImages.DESC_VALIDATE_TOOL);
        this.fProduct = product;
    }

    public void run() {
        Set<IPluginModelBase> launchPlugins = LaunchAction.getModels(this.fProduct);
        try {
            ProductValidationOperation operation = new ProductValidationOperation(launchPlugins);
            LaunchPluginValidator.runValidationOperation((LaunchValidationOperation)operation, (IProgressMonitor)new NullProgressMonitor());
            if (!operation.hasErrors()) {
                MessageDialog.open((int)2, (Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.PluginStatusDialog_pluginValidation, (String)PDEUIMessages.AbstractLauncherToolbar_noProblems, (int)0, (String[])new String[]{IDialogConstants.CLOSE_LABEL});
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getSeverity() == 8) {
                return;
            }
            PDEPlugin.logException(e);
        }
    }
}

