/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.plugin;

import java.util.Properties;
import org.eclipse.birt.report.model.extension.oda.IOdaExtensionLoader;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.MetaDataException;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.plugin.ODAPropertyDefn;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.datatools.connectivity.oda.util.manifest.Property;

public class OdaExtensibilityExtensionLoader
implements IOdaExtensionLoader {
    @Override
    public void load() {
        OdaExtensibilityExtensionLoader.loadDataSources();
    }

    private static void loadDataSources() {
        ExtensionManifest[] dataSources = ManifestExplorer.getInstance().getExtensionManifests();
        if (dataSources != null) {
            int i = 0;
            while (i < dataSources.length) {
                block8: {
                    ExtensionManifest manifest = dataSources[i];
                    ODAExtensionElementDefn cachedExtDefn = new ODAExtensionElementDefn(MetaDataDictionary.getInstance().getElement("OdaDataSource"));
                    try {
                        Property[] properties = manifest.getProperties();
                        Properties visibilities = manifest.getPropertiesVisibility();
                        if (properties != null) {
                            int j = 0;
                            while (j < properties.length) {
                                ODAPropertyDefn oDAPropertyDefn = new ODAPropertyDefn(properties[j]);
                                cachedExtDefn.addProperty(oDAPropertyDefn);
                                ++j;
                            }
                            if (visibilities != null) {
                                for (String string : visibilities.keySet()) {
                                    cachedExtDefn.addPropertyVisibility(string, visibilities.getProperty(string));
                                }
                            }
                        }
                        MetaDataDictionary.getInstance().cacheOdaExtension(manifest.getExtensionID(), cachedExtDefn);
                        OdaExtensibilityExtensionLoader.loadDataSets(manifest);
                    }
                    catch (MetaDataException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
    }

    private static void loadDataSets(ExtensionManifest dataSource) {
        assert (dataSource != null);
        DataSetType[] dataSets = dataSource.getDataSetTypes();
        if (dataSets != null) {
            int i = 0;
            while (i < dataSets.length) {
                block9: {
                    DataSetType type = dataSets[i];
                    ODAExtensionElementDefn cachedExtDefn = new ODAExtensionElementDefn(MetaDataDictionary.getInstance().getElement("OdaDataSet"));
                    try {
                        Property[] properties = type.getProperties();
                        Properties visibilities = type.getPropertiesVisibility();
                        if (properties != null) {
                            int j = 0;
                            while (j < properties.length) {
                                ODAPropertyDefn oDAPropertyDefn = new ODAPropertyDefn(properties[j]);
                                cachedExtDefn.addProperty(oDAPropertyDefn);
                                ++j;
                            }
                            if (visibilities != null) {
                                for (String string : visibilities.keySet()) {
                                    cachedExtDefn.addPropertyVisibility(string, visibilities.getProperty(string));
                                }
                            }
                        }
                        MetaDataDictionary.getInstance().cacheOdaExtension(type.getID(), cachedExtDefn);
                    }
                    catch (MetaDataException e) {
                        if ($assertionsDisabled) break block9;
                        throw new AssertionError();
                    }
                }
                ++i;
            }
        }
    }
}

