/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.computation.GObjectFactory;
import org.eclipse.birt.chart.computation.IGObjectFactory;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.engine.i18n.Messages;
import org.eclipse.birt.chart.event.ChartEvent;
import org.eclipse.birt.chart.event.IRenderInstruction;
import org.eclipse.birt.chart.event.WrappedInstruction;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.component.Label;

public abstract class PrimitiveRenderEvent
extends ChartEvent
implements Comparable {
    private static final long serialVersionUID = 1L;
    protected static final IGObjectFactory goFactory = GObjectFactory.instance();
    public static final int DRAW = 1;
    public static final int FILL = 2;
    public int iObjIndex = 0;
    private double dDepth = 0.0;
    protected boolean bEnabled = true;

    public PrimitiveRenderEvent(Object oSource) {
        super(oSource);
    }

    public Bounds getBounds() throws ChartException {
        throw new ChartException("org.eclipse.birt.chart.engine", 14, "exception.unsupported.bounds", new Object[]{this}, Messages.getResourceBundle());
    }

    public PrimitiveRenderEvent copy() throws ChartException {
        throw new ChartException("org.eclipse.birt.chart.engine", 14, "exception.unsupported.copy", new Object[]{this}, Messages.getResourceBundle());
    }

    public static final int compareTransposed(Bounds bo1, Bounds bo2) {
        double dMaxX2;
        double dMinX2;
        double dMaxY2;
        double dMinY2;
        double dMinY1 = bo1.getTop() + bo1.getHeight();
        double dDiff = dMinY1 - (dMinY2 = bo2.getTop() + bo2.getHeight());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? 1 : -1;
        }
        double dMaxY1 = bo1.getTop();
        dDiff = dMaxY1 - (dMaxY2 = bo2.getTop());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? 1 : -1;
        }
        double dMinX1 = bo1.getLeft();
        dDiff = dMinX1 - (dMinX2 = bo2.getLeft());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? -1 : 1;
        }
        double dMaxX1 = bo1.getLeft() + bo1.getWidth();
        dDiff = dMaxX1 - (dMaxX2 = bo2.getLeft() + bo2.getWidth());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? -1 : 1;
        }
        return 0;
    }

    public static final int compareRegular(Bounds bo1, Bounds bo2) {
        double dMaxY2;
        double dMinY2;
        double dMaxX2;
        double dMinX2;
        double dMinX1 = bo1.getLeft();
        double dDiff = dMinX1 - (dMinX2 = bo2.getLeft());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? -1 : 1;
        }
        double dMaxX1 = bo1.getLeft() + bo1.getWidth();
        dDiff = dMaxX1 - (dMaxX2 = bo2.getLeft() + bo2.getWidth());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? -1 : 1;
        }
        double dMinY1 = bo1.getTop();
        dDiff = dMinY1 - (dMinY2 = bo2.getTop());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? 1 : -1;
        }
        double dMaxY1 = bo1.getTop() + bo1.getHeight();
        dDiff = dMaxY1 - (dMaxY2 = bo2.getTop() + bo2.getHeight());
        if (dDiff != 0.0) {
            return dDiff < 0.0 ? 1 : -1;
        }
        return 0;
    }

    public int compareTo(Object o) {
        PrimitiveRenderEvent pre = null;
        if (o instanceof IRenderInstruction) {
            pre = ((WrappedInstruction)o).getEvent();
        } else if (o instanceof PrimitiveRenderEvent) {
            pre = (PrimitiveRenderEvent)o;
        } else {
            throw new RuntimeException((Throwable)((Object)new ChartException("org.eclipse.birt.chart.engine", 14, "exception.unsupported.comparison", new Object[]{o}, Messages.getResourceBundle())));
        }
        Bounds bo = null;
        Bounds boPre = null;
        try {
            bo = this.getBounds();
            boPre = pre.getBounds();
        }
        catch (ChartException ufex) {
            throw new RuntimeException((Throwable)((Object)ufex));
        }
        return PrimitiveRenderEvent.compareRegular(bo, boPre);
    }

    public void draw(IDeviceRenderer idr) throws ChartException {
        throw new ChartException("org.eclipse.birt.chart.engine", 14, "exception.unsupported.internal.draw", new Object[]{this}, Messages.getResourceBundle());
    }

    public void fill(IDeviceRenderer idr) throws ChartException {
        throw new ChartException("org.eclipse.birt.chart.engine", 14, "exception.unsupported.internal.fill", new Object[]{this}, Messages.getResourceBundle());
    }

    public final void setDepth(double dDepth) {
        this.dDepth = dDepth;
    }

    public final double getDepth() {
        return this.dDepth;
    }

    public LineAttributes getLineAttributes() {
        return null;
    }

    public Fill getBackground() {
        return null;
    }

    public Label getLabel() {
        return null;
    }

    public void setEnable(boolean enabled) {
        this.bEnabled = enabled;
    }

    public boolean isEnabled() {
        return this.bEnabled;
    }
}

