/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.ui.views.dialogs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.report.data.adapter.api.DataRequestSession;
import org.eclipse.birt.report.data.adapter.api.DataSessionContext;
import org.eclipse.birt.report.data.adapter.api.IBindingMetaInfo;
import org.eclipse.birt.report.data.adapter.api.IDimensionLevel;
import org.eclipse.birt.report.designer.data.ui.util.CubeValueSelector;
import org.eclipse.birt.report.designer.internal.ui.data.DataService;
import org.eclipse.birt.report.designer.internal.ui.dialogs.expression.ExpressionEditor;
import org.eclipse.birt.report.designer.internal.ui.expressions.IExpressionConverter;
import org.eclipse.birt.report.designer.internal.ui.extension.ExtendedDataModelUIAdapterHelper;
import org.eclipse.birt.report.designer.internal.ui.swt.custom.ValueCombo;
import org.eclipse.birt.report.designer.internal.ui.util.ExceptionHandler;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionButtonUtil;
import org.eclipse.birt.report.designer.internal.ui.util.ExpressionUtility;
import org.eclipse.birt.report.designer.internal.ui.util.WidgetUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.TabularDimensionNodeProvider;
import org.eclipse.birt.report.designer.ui.cubebuilder.provider.TabularLevelNodeProvider;
import org.eclipse.birt.report.designer.ui.dialogs.BaseTitleAreaDialog;
import org.eclipse.birt.report.designer.ui.dialogs.IExpressionProvider;
import org.eclipse.birt.report.designer.ui.dialogs.SelectValueDialog;
import org.eclipse.birt.report.designer.ui.newelement.DesignElementFactory;
import org.eclipse.birt.report.designer.ui.preferences.PreferenceFactory;
import org.eclipse.birt.report.designer.ui.util.ExceptionUtil;
import org.eclipse.birt.report.designer.ui.util.UIUtil;
import org.eclipse.birt.report.designer.ui.views.attributes.providers.ChoiceSetFactory;
import org.eclipse.birt.report.designer.util.AlphabeticallyComparator;
import org.eclipse.birt.report.designer.util.DEUtil;
import org.eclipse.birt.report.item.crosstab.core.de.AbstractCrosstabItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.ComputedMeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabReportItemHandle;
import org.eclipse.birt.report.item.crosstab.core.de.CrosstabViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.DimensionViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.LevelViewHandle;
import org.eclipse.birt.report.item.crosstab.core.de.MeasureViewHandle;
import org.eclipse.birt.report.item.crosstab.core.util.CrosstabUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.dialogs.CrosstabFilterExpressionProvider;
import org.eclipse.birt.report.item.crosstab.internal.ui.editors.model.CrosstabAdaptUtil;
import org.eclipse.birt.report.item.crosstab.internal.ui.util.CrosstabUIHelper;
import org.eclipse.birt.report.item.crosstab.plugin.CrosstabPlugin;
import org.eclipse.birt.report.item.crosstab.ui.views.attributes.widget.ExpressionValueCellEditor;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.FilterConditionElementHandle;
import org.eclipse.birt.report.model.api.LevelAttributeHandle;
import org.eclipse.birt.report.model.api.MemberValueHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.RuleHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.util.CubeUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class CrosstabFilterConditionBuilder
extends BaseTitleAreaDialog {
    private static final String DECORATOR_STRING = org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Item.Decorator");
    protected Composite parentComposite = null;
    protected List groupLevelList;
    protected List groupLevelNameList;
    protected List measureList;
    protected List measureNameList;
    protected List cubeLevelNameList;
    protected FilterConditionElementHandle filterConditionElement;
    protected LevelViewHandle levelViewHandle;
    protected MeasureViewHandle measureViewHandle;
    protected CrosstabReportItemHandle crosstabHandle;
    protected Group group;
    protected Table memberValueTable;
    protected TableViewer dynamicViewer;
    protected Button groupBtn;
    protected Button measureBtn;
    protected Composite memberValueGroup;
    protected CCombo expressionCCombo;
    protected String[] columns = new String[]{" ", org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelColumnMemberValue.Column.Level"), org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelColumnMemberValue.Column.Value")};
    protected MemberValueHandle memberValueHandle;
    protected List referencedLevelList;
    protected static final String CHOICE_SELECT_VALUE = org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("ExpressionValueCellEditor.selectValueAction");
    public static final String DLG_MESSAGE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogMessage.Edit");
    public static final String DLG_MESSAGE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogMessage.New");
    public static final String DLG_TITLE_EDIT = Messages.getString((String)"FilterConditionBuilder.DialogTitle.Edit");
    public static final String DLG_TITLE_NEW = Messages.getString((String)"FilterConditionBuilder.DialogTitle.New");
    protected static final String[] EMPTY = new String[0];
    protected static final String[] EMPTY_ARRAY = new String[0];
    protected static Logger logger = Logger.getLogger(CrosstabFilterConditionBuilder.class.getName());
    protected static String[][] OPERATOR;
    protected static String[][] OPERATOR_DM;
    protected static ArrayList<String> NOT_SUPPORTED_LIST;
    protected Button addBtn;
    protected Button editBtn;
    protected Button delBtn;
    protected Button delAllBtn;
    protected CCombo addExpressionValue;
    protected Label andLable;
    protected IChoiceSet choiceSet;
    protected List columnList;
    protected transient ReportElementHandle currentItem = null;
    protected DesignElementHandle designHandle;
    protected Composite dummy1;
    protected Composite dummy2;
    protected CCombo operator;
    protected IExpressionProvider expressionProvider;
    protected CCombo expressionValue1;
    protected CCombo expressionValue2;
    protected Label label1;
    protected Label label2;
    protected final String NULL_STRING;
    protected SelectionListener operatorSelection = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            CrosstabFilterConditionBuilder.this.operatorChange();
            CrosstabFilterConditionBuilder.this.getShell().pack();
        }
    };
    protected List selValueList = new ArrayList();
    protected Table table;
    protected IStructuredContentProvider tableContentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            if (inputElement instanceof List) {
                return ((List)inputElement).toArray();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    };
    protected ITableLabelProvider tableLableProvier = new ITableLabelProvider(){

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof Expression) {
                    return ((Expression)element).getStringExpression();
                }
                return element.toString();
            }
            return "";
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    protected TableViewer tableViewer;
    protected String title;
    protected String message;
    protected List valueList = new ArrayList();
    protected Composite valueListComposite;
    protected int valueVisible;
    protected List valueListConList = new ArrayList();
    protected static final String CHOICE_FILTER;
    protected Listener targetSelectionListener = new Listener(){

        public void handleEvent(Event event) {
            CrosstabFilterConditionBuilder.this.targetSelectionChanged();
        }
    };
    protected ValueCombo.ISelection2 dimensionValueAction = new ValueCombo.ISelection2(){

        public String doSelection(String CComboValue, int selectedIndex, String selectedValue) {
            return CrosstabFilterConditionBuilder.this.getDimensionStrExpression(selectedValue);
        }

        public String doSelection(String input) {
            return input;
        }
    };
    protected Listener groupLeveModify = new Listener(){

        public void handleEvent(Event e) {
            CrosstabFilterConditionBuilder.this.filterTargetChanged();
        }
    };
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            Object obj;
            ISelection selection = event.getSelection();
            if (selection instanceof StructuredSelection && (obj = ((StructuredSelection)selection).getFirstElement()) instanceof MemberValueHandle && CrosstabFilterConditionBuilder.this.editor != null) {
                CrosstabFilterConditionBuilder.this.editor.setMemberValue((MemberValueHandle)obj);
            }
        }
    };
    private static final String dummyChoice = "dummy";
    private IStructuredContentProvider contentProvider = new IStructuredContentProvider(){

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputObj) {
            if (!(inputObj instanceof List)) {
                return new Object[0];
            }
            return ((List)inputObj).toArray();
        }
    };
    private ITableLabelProvider labelProvider = new ITableLabelProvider(){

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element == CrosstabFilterConditionBuilder.dummyChoice) {
                    return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("LevelPropertyDialog.MSG.CreateNew");
                }
                if (element instanceof RuleHandle) {
                    return ((RuleHandle)element).getDisplayExpression();
                }
                return "";
            }
            if (columnIndex == 1) {
                LevelHandle level = ((MemberValueHandle)element).getLevel();
                if (level != null) {
                    return DEUtil.resolveNull((String)level.getName());
                }
                if (((MemberValueHandle)element).getCubeLevelName() != null) {
                    return CubeUtil.splitLevelName((String)((MemberValueHandle)element).getCubeLevelName())[1];
                }
                return "";
            }
            if (columnIndex == 2) {
                String value = ((MemberValueHandle)element).getValue();
                return value == null ? "" : value;
            }
            return "";
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    };
    private ICellModifier cellModifier = new ICellModifier(){

        public boolean canModify(Object element, String property) {
            return Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) == 2;
        }

        public Object getValue(Object element, String property) {
            if (Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) != 2) {
                return "";
            }
            String value = ((MemberValueHandle)element).getValue();
            return value == null ? "" : value;
        }

        public void modify(Object element, String property, Object value) {
            if (Arrays.asList(CrosstabFilterConditionBuilder.this.columns).indexOf(property) != 2) {
                return;
            }
            TableItem item = (TableItem)element;
            MemberValueHandle memberValue = (MemberValueHandle)item.getData();
            try {
                memberValue.setValue((String)value);
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            CrosstabFilterConditionBuilder.this.dynamicViewer.refresh();
        }
    };
    private ExpressionValueCellEditor editor;
    private transient boolean needRefreshList = true;
    private Composite valuesComposite;
    private CCombo groupGroupLevel;
    private CCombo measureGroupLevel;
    private Button detailBtn;
    private CrosstabFilterExpressionProvider provider;
    private Label valuesLabel;
    private Button updateAggrButton;

    static {
        CHOICE_FILTER = org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("ExpressionValueCellEditor.filterBy");
    }

    public static int determineValueVisible(String operatorValue) {
        if ("any".equals(operatorValue) || "is-false".equals(operatorValue) || "is-true".equals(operatorValue) || "is-null".equals(operatorValue) || "is-not-null".equals(operatorValue)) {
            return 0;
        }
        if ("lt".equals(operatorValue) || "le".equals(operatorValue) || "eq".equals(operatorValue) || "ne".equals(operatorValue) || "ge".equals(operatorValue) || "gt".equals(operatorValue) || "like".equals(operatorValue)) {
            return 1;
        }
        if ("between".equals(operatorValue) || "not-between".equals(operatorValue)) {
            return 2;
        }
        if ("in".equals(operatorValue) || "not-in".equals(operatorValue)) {
            return 3;
        }
        return 1;
    }

    protected static int getIndexForOperatorValue(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return i;
            }
            ++i;
        }
        return 0;
    }

    public static String getNameForOperator(String value) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][1].equals(value)) {
                return OPERATOR[i][0];
            }
            ++i;
        }
        return "";
    }

    public static String getValueForOperator(String name) {
        int i = 0;
        while (i < OPERATOR.length) {
            if (OPERATOR[i][0].equals(name)) {
                return OPERATOR[i][1];
            }
            ++i;
        }
        return null;
    }

    public void setInput(FilterConditionElementHandle input, Object target) {
        this.filterConditionElement = input;
        if (target instanceof MeasureViewHandle) {
            this.measureViewHandle = (MeasureViewHandle)target;
        } else if (target instanceof LevelViewHandle) {
            this.levelViewHandle = (LevelViewHandle)target;
        } else {
            this.crosstabHandle = (CrosstabReportItemHandle)target;
        }
    }

    public void setDesignHandle(DesignElementHandle handle) {
        this.designHandle = handle;
        if (this.editor != null) {
            this.editor.setExpressionProvider((IExpressionProvider)new CrosstabFilterExpressionProvider(handle));
        }
    }

    private int createValueListComposite(Composite parent) {
        if (this.addExpressionValue != null && !this.addExpressionValue.isDisposed()) {
            return 0;
        }
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().dispose();
            this.expressionValue1.dispose();
            this.expressionValue1 = null;
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().dispose();
            this.expressionValue2.dispose();
            this.expressionValue2 = null;
            this.andLable.dispose();
            this.andLable = null;
        }
        this.valueListConList.clear();
        this.addExpressionValue = this.createMultiExpressionValue(parent);
        this.addExpressionValue.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        this.valueListConList.add(this.addExpressionValue);
        this.valueListConList.add(ExpressionButtonUtil.getExpressionButton((Control)this.addExpressionValue).getControl());
        this.addBtn = new Button(parent, 8);
        this.addBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.add"));
        this.addBtn.setToolTipText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.add.tooltip"));
        this.setButtonCGridLayoutData(this.addBtn);
        this.valueListConList.add(this.addBtn);
        this.addBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Expression value = ExpressionButtonUtil.getExpression((Control)CrosstabFilterConditionBuilder.this.addExpressionValue);
                if (CrosstabFilterConditionBuilder.this.valueList.indexOf(value) < 0) {
                    CrosstabFilterConditionBuilder.this.valueList.add(value);
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setFocus();
                    CrosstabFilterConditionBuilder.this.addExpressionValue.setText("");
                } else {
                    CrosstabFilterConditionBuilder.this.addBtn.setEnabled(false);
                }
            }
        });
        int tableStyle = 68356;
        this.table = new Table(parent, tableStyle);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        data.horizontalSpan = 3;
        this.table.setLayoutData((Object)data);
        this.valueListConList.add(this.table);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        String[] columNames = new String[]{org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.list.item1")};
        int[] columLength = new int[]{268};
        int i = 0;
        while (i < columNames.length) {
            TableColumn column = new TableColumn(this.table, 0, i);
            column.setText(columNames[i]);
            column.setWidth(columLength[i]);
            ++i;
        }
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.checkEditDelButtonStatus();
            }
        });
        this.table.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127) {
                    CrosstabFilterConditionBuilder.this.delTableValue();
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CrosstabFilterConditionBuilder.this.editTableValue();
            }
        });
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setColumnProperties(columNames);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.tableLableProvier);
        this.tableViewer.setContentProvider((IContentProvider)this.tableContentProvider);
        Composite rightPart = new Composite(parent, 0);
        rightPart.setLayoutData((Object)GridDataFactory.swtDefaults().grab(true, true).create());
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        rightPart.setLayout((Layout)layout);
        this.valueListConList.add(rightPart);
        this.editBtn = new Button(rightPart, 8);
        this.editBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.edit"));
        this.editBtn.setToolTipText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.edit.tooltip"));
        this.setButtonLayoutData(this.editBtn);
        this.editBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.editTableValue();
            }
        });
        this.delBtn = new Button(rightPart, 8);
        this.delBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.delete"));
        this.delBtn.setToolTipText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.delete.tooltip"));
        this.setButtonLayoutData(this.delBtn);
        this.delBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                CrosstabFilterConditionBuilder.this.delTableValue();
            }
        });
        this.delAllBtn = new Button(rightPart, 8);
        this.delAllBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.deleteall"));
        this.delAllBtn.setToolTipText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.button.deleteall.tooltip"));
        this.setButtonLayoutData(this.delAllBtn);
        this.delAllBtn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                int count = CrosstabFilterConditionBuilder.this.valueList.size();
                if (count > 0) {
                    CrosstabFilterConditionBuilder.this.valueList.clear();
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                } else {
                    CrosstabFilterConditionBuilder.this.delAllBtn.setEnabled(false);
                }
            }
        });
        this.parentComposite.layout(true, true);
        if (this.getButtonBar() != null) {
            parent.getShell().pack();
        }
        return 1;
    }

    private int create2ValueComposite(Composite condition) {
        if (this.expressionValue1 != null && !this.expressionValue1.isDisposed()) {
            return 0;
        }
        if (this.valueListConList.size() > 0) {
            int count = this.valueListConList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.valueListConList.get(i);
                if (obj instanceof Widget && !((Widget)obj).isDisposed()) {
                    ((Widget)obj).dispose();
                }
                ++i;
            }
        }
        this.valueListConList.clear();
        this.expressionValue1 = this.createExpressionValue(condition);
        this.expressionValue1.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        this.andLable = new Label(condition, 0);
        this.andLable.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.text.AND"));
        this.andLable.setEnabled(false);
        this.andLable.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).create());
        this.expressionValue2 = this.createExpressionValue(condition);
        this.expressionValue2.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        if (this.operator.getItemCount() > 0 && this.operator.getSelectionIndex() == -1) {
            this.operator.select(CrosstabFilterConditionBuilder.getIndexForOperatorValue("eq"));
            this.operatorChange();
        }
        this.parentComposite.layout(true, true);
        if (this.getButtonBar() != null) {
            condition.getShell().pack();
        }
        return 1;
    }

    protected void operatorChange() {
        String value = CrosstabFilterConditionBuilder.getValueForOperator(this.operator.getText());
        this.valueVisible = CrosstabFilterConditionBuilder.determineValueVisible(value);
        if (this.valueVisible == 3) {
            int ret = this.createValueListComposite(this.valuesComposite);
            if (ret != 0) {
                this.valueList = new ArrayList();
                if (this.filterConditionElement != null && this.filterConditionElement.getValue1ExpressionList().getListValue() != null && this.filterConditionElement.getValue1ExpressionList().getListValue().size() > 0) {
                    this.valueList.addAll(this.filterConditionElement.getValue1ExpressionList().getListValue());
                }
                this.tableViewer.setInput((Object)this.valueList);
                WidgetUtil.setExcludeGridData((Control)this.tableViewer.getControl(), (boolean)false);
            }
        } else {
            int ret = this.create2ValueComposite(this.valuesComposite);
            if (ret != 0 && this.filterConditionElement != null) {
                this.expressionValue1.setText(DEUtil.resolveNull((String)this.filterConditionElement.getValue1()));
                this.expressionValue2.setText(DEUtil.resolveNull((String)this.filterConditionElement.getValue2()));
            }
            if (this.tableViewer != null && !this.tableViewer.getControl().isDisposed()) {
                WidgetUtil.setExcludeGridData((Control)this.tableViewer.getControl(), (boolean)true);
            }
        }
        if (this.valueVisible == 0) {
            WidgetUtil.setExcludeGridData((Control)this.expressionValue1, (boolean)true);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl(), (boolean)true);
            WidgetUtil.setExcludeGridData((Control)this.expressionValue2, (boolean)true);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl(), (boolean)true);
            WidgetUtil.setExcludeGridData((Control)this.andLable, (boolean)true);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 1) {
            WidgetUtil.setExcludeGridData((Control)this.expressionValue1, (boolean)false);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl(), (boolean)false);
            WidgetUtil.setExcludeGridData((Control)this.expressionValue2, (boolean)true);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl(), (boolean)true);
            this.andLable.setVisible(false);
        } else if (this.valueVisible == 2) {
            WidgetUtil.setExcludeGridData((Control)this.expressionValue1, (boolean)false);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl(), (boolean)false);
            WidgetUtil.setExcludeGridData((Control)this.expressionValue2, (boolean)false);
            WidgetUtil.setExcludeGridData((Control)ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl(), (boolean)false);
            WidgetUtil.setExcludeGridData((Control)this.andLable, (boolean)false);
            this.andLable.setVisible(true);
            this.andLable.setEnabled(true);
        }
        WidgetUtil.setExcludeGridData((Control)this.valuesComposite, (this.valueVisible == 0 ? 1 : 0) != 0);
        WidgetUtil.setExcludeGridData((Control)this.valuesLabel, (this.valueVisible == 0 ? 1 : 0) != 0);
        this.updateButtons();
        this.valuesComposite.getParent().layout();
    }

    public void load_OPERATOR() {
        IChoiceSet chset = ChoiceSetFactory.getStructChoiceSet((String)"FilterCondition", (String)"operator");
        IChoice[] chs = chset.getChoices((Comparator)new AlphabeticallyComparator());
        OPERATOR = new String[chs.length][2];
        OPERATOR_DM = new String[chs.length - 4][2];
        int i = 0;
        while (i < chs.length) {
            CrosstabFilterConditionBuilder.OPERATOR[i][0] = chs[i].getDisplayName();
            CrosstabFilterConditionBuilder.OPERATOR[i][1] = chs[i].getName();
            ++i;
        }
        NOT_SUPPORTED_LIST = new ArrayList();
        NOT_SUPPORTED_LIST.add("top-n");
        NOT_SUPPORTED_LIST.add("bottom-n");
        NOT_SUPPORTED_LIST.add("top-percent");
        NOT_SUPPORTED_LIST.add("bottom-percent");
    }

    public CrosstabFilterConditionBuilder(String title, String message) {
        this(UIUtil.getDefaultShell(), title, message);
        this.load_OPERATOR();
    }

    public CrosstabFilterConditionBuilder(Shell parentShell, String title, String message) {
        super(parentShell);
        this.NULL_STRING = null;
        this.title = title;
        this.message = message;
        this.load_OPERATOR();
    }

    private void initializeDialog() {
        this.getLevels();
        this.getMeasures();
        this.getCubeLevelNames();
        this.groupBtn.setSelection(true);
        this.targetSelectionChanged(false);
    }

    protected Control createDialogArea(Composite parent) {
        UIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.cshelp.AddEditFilterCondition_ID");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite contents = new Composite(area, 0);
        contents.setLayoutData((Object)new GridData(1808));
        contents.setLayout((Layout)new GridLayout());
        this.setTitle(this.title);
        this.setMessage(this.message);
        this.getShell().setText(this.title);
        CrosstabFilterConditionBuilder.applyDialogFont((Control)contents);
        this.initializeDialogUnits((Control)area);
        this.createFilterConditionContent(contents);
        return area;
    }

    protected void createFilterConditionContent(Composite innerParent) {
        UIUtil.bindHelp((Control)innerParent, (String)"org.eclipse.birt.cshelp.CrossTabFilterConditionBuilder_ID");
        this.parentComposite = innerParent;
        Composite parentControl = new Composite(innerParent, 0);
        GridData gd = new GridData(1808);
        gd.heightHint = 480;
        parentControl.setLayoutData((Object)gd);
        parentControl.setLayout((Layout)new GridLayout(4, false));
        Composite groupContainer = new Composite(parentControl, 0);
        gd = new GridData(768);
        gd.horizontalSpan = 4;
        groupContainer.setLayoutData((Object)gd);
        groupContainer.setLayout((Layout)new GridLayout(4, false));
        Label label = new Label(groupContainer, 0);
        label.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Label.Target"));
        gd = new GridData();
        gd.widthHint = label.computeSize((int)-1, (int)-1).x < 60 ? 60 : label.computeSize((int)-1, (int)-1).x;
        label.setLayoutData((Object)gd);
        this.groupBtn = new Button(groupContainer, 16);
        this.groupBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Button.GroupLevel"));
        this.groupBtn.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
        this.groupGroupLevel = new CCombo(groupContainer, 2056);
        this.groupGroupLevel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(200, -1).create());
        this.groupGroupLevel.setVisibleItemCount(30);
        this.groupGroupLevel.addListener(24, this.groupLeveModify);
        new Label(groupContainer, 0);
        this.measureBtn = new Button(groupContainer, 16);
        this.measureBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Button.Measure"));
        this.measureBtn.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
        this.measureGroupLevel = new CCombo(groupContainer, 2056);
        this.measureGroupLevel.setLayoutData((Object)GridDataFactory.swtDefaults().span(2, 1).hint(200, -1).create());
        this.measureGroupLevel.setVisibleItemCount(30);
        this.measureGroupLevel.addListener(24, this.groupLeveModify);
        new Label(groupContainer, 0);
        this.detailBtn = new Button(groupContainer, 16);
        this.detailBtn.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Button.Detal"));
        this.detailBtn.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        this.groupBtn.addListener(13, this.targetSelectionListener);
        this.measureBtn.addListener(13, this.targetSelectionListener);
        this.detailBtn.addListener(13, this.targetSelectionListener);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 4;
        new Label(parentControl, 258).setLayoutData((Object)gridData);
        Label lb = new Label(parentControl, 0);
        lb.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterConditionBuilder.text.Condition"));
        this.expressionCCombo = this.createExpressionCombo(parentControl);
        this.expressionCCombo.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
        this.operator = new CCombo(parentControl, 2056);
        this.operator.setVisibleItemCount(30);
        boolean isDataModel = CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)this.getCrosstab((ExtendedItemHandle)this.designHandle));
        int j = 0;
        int i = 0;
        while (i < OPERATOR.length) {
            if (!isDataModel || !NOT_SUPPORTED_LIST.contains(OPERATOR[i][1])) {
                if (isDataModel) {
                    CrosstabFilterConditionBuilder.OPERATOR_DM[j][0] = OPERATOR[i][0];
                    CrosstabFilterConditionBuilder.OPERATOR_DM[j][1] = OPERATOR[i][1];
                    ++j;
                }
                this.operator.add(OPERATOR[i][0]);
            }
            ++i;
        }
        if (isDataModel) {
            OPERATOR = OPERATOR_DM;
        }
        this.operator.addSelectionListener(this.operatorSelection);
        this.valuesLabel = new Label(parentControl, 0);
        this.valuesComposite = new Composite(parentControl, 0);
        this.valuesComposite.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        this.valuesComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(4).create());
        this.create2ValueComposite(this.valuesComposite);
        new Label(parentControl, 0);
        this.updateAggrButton = new Button(parentControl, 32);
        this.updateAggrButton.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Button.UpdateAggregation"));
        this.updateAggrButton.setLayoutData((Object)GridDataFactory.swtDefaults().span(3, 1).create());
        this.updateAggrButton.setSelection(this.filterConditionElement != null ? this.filterConditionElement.updateAggregation() : true);
        this.memberValueGroup = new Composite(parentControl, 0);
        this.memberValueGroup.setLayout((Layout)new GridLayout());
        gd = new GridData(768);
        gd.horizontalSpan = 5;
        this.memberValueGroup.setLayoutData((Object)gd);
        this.createMemberValuesGroup(this.memberValueGroup);
        this.initializeDialog();
        this.syncViewProperties();
    }

    private CCombo createExpressionCombo(Composite parent) {
        final CCombo expressionValue = new CCombo(parent, 2048);
        expressionValue.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                int j;
                List bindingList = new ArrayList();
                LevelViewHandle level = null;
                MeasureViewHandle measure = null;
                if (CrosstabFilterConditionBuilder.this.groupBtn.getSelection()) {
                    if (CrosstabFilterConditionBuilder.this.groupGroupLevel.indexOf(CrosstabFilterConditionBuilder.this.groupGroupLevel.getText()) > 0 && CrosstabFilterConditionBuilder.this.groupLevelList != null) {
                        if (CrosstabFilterConditionBuilder.this.groupGroupLevel.indexOf(CrosstabFilterConditionBuilder.this.groupGroupLevel.getText()) - 1 < CrosstabFilterConditionBuilder.this.groupLevelList.size()) {
                            level = (LevelViewHandle)CrosstabFilterConditionBuilder.this.groupLevelList.get(CrosstabFilterConditionBuilder.this.groupGroupLevel.indexOf(CrosstabFilterConditionBuilder.this.groupGroupLevel.getText()) - 1);
                            if (level != null) {
                                bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(level);
                            }
                        } else {
                            bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(CrosstabFilterConditionBuilder.this.getDimensionStrExpression(CrosstabFilterConditionBuilder.this.groupGroupLevel.getText()));
                        }
                    }
                } else if (CrosstabFilterConditionBuilder.this.measureBtn.getSelection()) {
                    if (CrosstabFilterConditionBuilder.this.measureGroupLevel.indexOf(CrosstabFilterConditionBuilder.this.measureGroupLevel.getText()) > 0 && CrosstabFilterConditionBuilder.this.measureList != null && CrosstabFilterConditionBuilder.this.measureList.size() > 0) {
                        measure = (MeasureViewHandle)CrosstabFilterConditionBuilder.this.measureList.get(CrosstabFilterConditionBuilder.this.measureGroupLevel.indexOf(CrosstabFilterConditionBuilder.this.measureGroupLevel.getText()) - 1);
                    }
                    if (measure != null) {
                        bindingList = CrosstabFilterConditionBuilder.this.getReferableBindings(measure);
                    }
                } else if (CrosstabFilterConditionBuilder.this.detailBtn.getSelection()) {
                    expressionValue.remove(0, expressionValue.getItemCount() - 1);
                    List cubeLevelNames = CrosstabFilterConditionBuilder.this.getCubeLevelNames();
                    int i = 0;
                    while (i < cubeLevelNames.size()) {
                        expressionValue.add((String)cubeLevelNames.get(i));
                        ++i;
                    }
                    if (expressionValue.getItemCount() > 0) {
                        expressionValue.add(String.valueOf(DECORATOR_STRING) + new BindingGroup(2).getBindingGroupName() + DECORATOR_STRING, 0);
                    }
                    return;
                }
                BindingGroup[] bindingGroup = new BindingGroup[]{new BindingGroup(1), new BindingGroup(2), new BindingGroup(11), new BindingGroup(12), new BindingGroup(13)};
                int i = 0;
                while (i < bindingList.size()) {
                    IBindingMetaInfo metaInfo = (IBindingMetaInfo)bindingList.get(i);
                    j = 0;
                    while (j < bindingGroup.length) {
                        if (bindingGroup[j].type == metaInfo.getBindingType()) {
                            bindingGroup[j].addBinding(metaInfo.getBindingName());
                            break;
                        }
                        ++j;
                    }
                    ++i;
                }
                expressionValue.remove(0, expressionValue.getItemCount() - 1);
                i = 0;
                while (i < bindingGroup.length) {
                    BindingGroup group = bindingGroup[i];
                    if (group.getBindings() != null && !group.getBindings().isEmpty()) {
                        expressionValue.add(String.valueOf(DECORATOR_STRING) + group.getBindingGroupName() + DECORATOR_STRING);
                        j = 0;
                        while (j < group.getBindings().size()) {
                            expressionValue.add((String)group.getBindings().get(j));
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        });
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                IExpressionConverter converter;
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                if (selection.startsWith(DECORATOR_STRING)) {
                    int index = expressionValue.indexOf(selection);
                    selection = index < expressionValue.getItemCount() - 1 ? expressionValue.getItem(index + 1) : "";
                }
                if ((converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)CrosstabFilterConditionBuilder.this.expressionCCombo)) != null) {
                    String result = null;
                    if (CrosstabFilterConditionBuilder.this.detailBtn.getSelection()) {
                        String[] splits = selection.split("/");
                        String[] expression = new String[3];
                        if (splits.length > 0) {
                            expression[0] = splits[0];
                        }
                        if (splits.length > 1) {
                            expression[1] = splits[1];
                        }
                        if (splits.length > 2) {
                            expression[2] = splits[2];
                        }
                        if (CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)CrosstabFilterConditionBuilder.this.getCrosstab((ExtendedItemHandle)CrosstabFilterConditionBuilder.this.designHandle)) && ExtendedDataModelUIAdapterHelper.getInstance().getAdapter() != null) {
                            LevelHandle levelHandle = null;
                            for (LevelHandle level : CrosstabFilterConditionBuilder.this.getCubeLevels()) {
                                if (!level.getName().equals(splits[1])) continue;
                                levelHandle = level;
                                break;
                            }
                            result = ExtendedDataModelUIAdapterHelper.getInstance().getAdapter().createExtendedDataItemExpression(levelHandle);
                        } else {
                            result = converter.getDimensionExpression(expression[0], expression[1], expression[2]);
                        }
                    } else {
                        result = converter.getCubeBindingExpression(selection);
                    }
                    if (result != null) {
                        expressionValue.setText(result);
                    } else {
                        expressionValue.setText("");
                    }
                }
                e.doit = false;
                CrosstabFilterConditionBuilder.this.updateMemberValues();
                CrosstabFilterConditionBuilder.this.needRefreshList = true;
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CrosstabFilterConditionBuilder.this.updateMemberValues();
                CrosstabFilterConditionBuilder.this.needRefreshList = true;
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        };
        CrosstabFilterExpressionProvider provider = this.getCrosstabExpressionProvider();
        ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)expressionValue, (IExpressionProvider)provider, (Object)this.designHandle, (Listener)listener);
        return expressionValue;
    }

    private CCombo createExpressionValue(Composite parent) {
        final CCombo expressionValue = new CCombo(parent, 2048);
        expressionValue.add(CHOICE_SELECT_VALUE);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String value;
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE) && (value = CrosstabFilterConditionBuilder.this.getSelectionValue(expressionValue)) != null) {
                    expressionValue.setText(value);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        this.createValueExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    protected String getSelectionValue(CCombo CCombo2) {
        String retValue = null;
        List selectValueList = this.getSelectedValueList();
        if (selectValueList == null || selectValueList.size() == 0) {
            MessageDialog.openInformation(null, (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelectValueDialog.selectValue"), (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
        } else {
            SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("ExpressionValueCellEditor.title"));
            dialog.setSelectedValueList((Collection)selectValueList);
            if (dialog.open() == 0) {
                IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)CCombo2);
                retValue = dialog.getSelectedExprValue(converter);
            }
        }
        return retValue;
    }

    private CCombo createMultiExpressionValue(Composite parent) {
        final CCombo expressionValue = new CCombo(parent, 2048);
        expressionValue.add(CHOICE_SELECT_VALUE);
        expressionValue.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                String selection = e.text;
                if (expressionValue.indexOf(selection) == -1) {
                    e.doit = true;
                    return;
                }
                e.doit = !selection.equals(CHOICE_SELECT_VALUE);
            }
        });
        expressionValue.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (expressionValue.getSelectionIndex() == -1) {
                    return;
                }
                String selection = expressionValue.getItem(expressionValue.getSelectionIndex());
                if (selection.equals(CHOICE_SELECT_VALUE)) {
                    CrosstabFilterConditionBuilder.this.selectMultiValues(expressionValue);
                }
            }
        });
        expressionValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CrosstabFilterConditionBuilder.this.checkAddButtonStatus();
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        });
        this.createMultiValueExpressionButton(parent, expressionValue);
        return expressionValue;
    }

    private void createMultiValueExpressionButton(Composite parent, final CCombo combo) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CrosstabFilterConditionBuilder.this.addBtn.setEnabled(false);
                boolean change = false;
                Expression expression = ExpressionButtonUtil.getExpression((Control)combo);
                if (expression == null || expression.getStringExpression().trim().length() == 0) {
                    return;
                }
                if (CrosstabFilterConditionBuilder.this.valueList.indexOf(expression) < 0) {
                    CrosstabFilterConditionBuilder.this.valueList.add(expression);
                    change = true;
                }
                if (change) {
                    CrosstabFilterConditionBuilder.this.tableViewer.refresh();
                    CrosstabFilterConditionBuilder.this.updateButtons();
                    combo.setFocus();
                    combo.setText("");
                }
            }
        };
        ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)combo, (IExpressionProvider)this.getCrosstabExpressionProvider(), (Object)this.designHandle, (Listener)listener);
    }

    private void selectMultiValues(CCombo CCombo2) {
        String[] retValue = null;
        List selectValueList = this.getSelectedValueList();
        if (selectValueList == null || selectValueList.size() == 0) {
            MessageDialog.openInformation(null, (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelectValueDialog.selectValue"), (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("SelectValueDialog.messages.info.selectVauleUnavailable"));
        } else {
            SelectValueDialog dialog = new SelectValueDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("ExpressionValueCellEditor.title"));
            dialog.setSelectedValueList((Collection)selectValueList);
            dialog.setMultipleSelection(true);
            if (dialog.open() == 0) {
                retValue = dialog.getSelectedExprValues();
            }
        }
        if (retValue != null) {
            this.addBtn.setEnabled(false);
            if (retValue.length == 1) {
                CCombo2.setText(DEUtil.resolveNull((String)retValue[0]));
            } else if (retValue.length > 1) {
                CCombo2.setText("");
            }
            boolean change = false;
            ArrayList<String> strValues = new ArrayList<String>();
            int i = 0;
            while (i < this.valueList.size()) {
                strValues.add(((Expression)this.valueList.get(i)).getStringExpression());
                ++i;
            }
            i = 0;
            while (i < retValue.length) {
                if (strValues.indexOf(DEUtil.resolveNull((String)retValue[i])) < 0) {
                    this.valueList.add(new Expression((Object)DEUtil.resolveNull((String)retValue[i]), ExpressionButtonUtil.getExpressionButton((Control)CCombo2).getExpressionHelper().getExpressionType()));
                    change = true;
                }
                ++i;
            }
            if (change) {
                this.tableViewer.refresh();
                this.updateButtons();
                CCombo2.setFocus();
            }
        }
    }

    private void createValueExpressionButton(Composite parent, CCombo CCombo2) {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                CrosstabFilterConditionBuilder.this.updateButtons();
            }
        };
        CrosstabFilterExpressionProvider provider = this.getCrosstabExpressionProvider();
        ExpressionButtonUtil.createExpressionButton((Composite)parent, (Control)CCombo2, (IExpressionProvider)provider, (Object)this.designHandle, (Listener)listener);
    }

    private CrosstabFilterExpressionProvider getCrosstabExpressionProvider() {
        if (this.provider == null) {
            this.provider = new CrosstabFilterExpressionProvider(this.designHandle);
        }
        return this.provider;
    }

    private void targetSelectionChanged() {
        this.targetSelectionChanged(true);
    }

    private void targetSelectionChanged(boolean fireEvent) {
        if (this.groupBtn.getSelection()) {
            this.memberValueGroup.setVisible(true);
            this.parentComposite.layout(true, true);
            String[] groupLeveNames = this.groupLevelNameList.toArray(new String[this.groupLevelNameList.size()]);
            this.groupGroupLevel.setEnabled(true);
            this.measureGroupLevel.setEnabled(false);
            this.measureGroupLevel.removeAll();
            this.groupGroupLevel.removeAll();
            this.groupGroupLevel.setItems(groupLeveNames);
            this.groupGroupLevel.add(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Item.SelectLevel"), 0);
            this.groupGroupLevel.select(0);
            this.expressionCCombo.removeAll();
            this.expressionCCombo.setEnabled(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
            this.getCrosstabExpressionProvider().setDetail(false);
            if (fireEvent) {
                this.filterTargetChanged();
            }
            if (this.updateAggrButton != null) {
                this.updateAggrButton.setVisible(true);
            }
        } else if (this.measureBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            this.parentComposite.layout(true, true);
            String[] measureNames = this.measureNameList.toArray(new String[this.measureNameList.size()]);
            this.measureGroupLevel.setEnabled(true);
            this.groupGroupLevel.setEnabled(false);
            this.groupGroupLevel.removeAll();
            this.measureGroupLevel.removeAll();
            this.measureGroupLevel.setItems(measureNames);
            this.measureGroupLevel.add(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Item.SelectMeasure"), 0);
            this.measureGroupLevel.select(0);
            this.expressionCCombo.removeAll();
            this.expressionCCombo.setEnabled(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
            this.getCrosstabExpressionProvider().setDetail(false);
            if (fireEvent) {
                this.filterTargetChanged();
            }
            if (this.updateAggrButton != null) {
                this.updateAggrButton.setVisible(true);
            }
        } else if (this.detailBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            this.parentComposite.layout(true, true);
            this.measureGroupLevel.setEnabled(false);
            this.groupGroupLevel.setEnabled(false);
            this.groupGroupLevel.removeAll();
            this.measureGroupLevel.removeAll();
            this.expressionCCombo.removeAll();
            this.expressionCCombo.setEnabled(false);
            ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
            this.getCrosstabExpressionProvider().setDetail(true);
            if (fireEvent) {
                this.filterTargetChanged();
            }
            if (this.updateAggrButton != null) {
                this.updateAggrButton.setVisible(false);
            }
        }
        this.updateMemberValues();
        this.updateButtons();
    }

    private String getDimensionStrExpression(String input) {
        String[] levels = input.split("/");
        String expression = "dimension";
        String[] stringArray = levels;
        int n = levels.length;
        int n2 = 0;
        while (n2 < n) {
            String l = stringArray[n2];
            expression = String.valueOf(expression) + "[\"" + l + "\"]";
            ++n2;
        }
        return expression;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void filterTargetChanged() {
        block22: {
            String targetString;
            block20: {
                this.needRefreshList = true;
                targetString = null;
                if (this.groupBtn.getSelection()) {
                    if (this.groupLevelList != null && this.groupLevelList.size() > 0 && this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) > 0 && this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) <= this.groupLevelList.size()) {
                        this.expressionCCombo.setEnabled(true);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(true);
                        LevelViewHandle level = (LevelViewHandle)this.groupLevelList.get(this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) - 1);
                        DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle(level.getCubeLevel());
                        targetString = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)level.getCubeLevel().getName());
                        break block20;
                    } else {
                        this.expressionCCombo.setEnabled(false);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
                        this.updateMemberValues();
                        this.updateButtons();
                        return;
                    }
                }
                if (this.measureBtn.getSelection()) {
                    if (this.measureList != null && this.measureList.size() > 0 && this.measureGroupLevel.indexOf(this.measureGroupLevel.getText()) > 0 && this.measureGroupLevel.indexOf(this.measureGroupLevel.getText()) <= this.measureList.size()) {
                        this.expressionCCombo.setEnabled(true);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(true);
                        MeasureViewHandle measure = (MeasureViewHandle)this.measureList.get(this.measureGroupLevel.indexOf(this.measureGroupLevel.getText()) - 1);
                        targetString = measure.getCubeMeasure().getName();
                        break block20;
                    } else {
                        this.expressionCCombo.setEnabled(false);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
                        this.updateMemberValues();
                        this.updateButtons();
                        return;
                    }
                }
                if (this.detailBtn.getSelection()) {
                    if (this.cubeLevelNameList != null && this.cubeLevelNameList.size() > 0) {
                        this.expressionCCombo.setEnabled(true);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(true);
                    } else {
                        this.expressionCCombo.setEnabled(false);
                        ExpressionButtonUtil.getExpressionButton((Control)this.expressionCCombo).setEnabled(false);
                    }
                    this.updateMemberValues();
                    this.updateButtons();
                    return;
                }
            }
            if (targetString != null) {
                ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
                CrosstabReportItemHandle crosstab = null;
                try {
                    crosstab = (CrosstabReportItemHandle)element.getReportItem();
                }
                catch (ExtendedElementException ex) {
                    ExceptionUtil.handle((Throwable)ex);
                }
                DataRequestSession session = null;
                List retList = null;
                try {
                    try {
                        session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                        retList = this.getReferableBindings(session, crosstab, null, targetString);
                        if (retList != null && retList.size() > 0) {
                            IBindingMetaInfo meta = (IBindingMetaInfo)retList.get(0);
                            IExpressionConverter converter = ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.expressionCCombo);
                            this.expressionCCombo.setText(converter.getCubeBindingExpression(meta.getBindingName()));
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.SEVERE, ex.getMessage(), ex);
                        if (session != null) {
                            session.shutdown();
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (session != null) {
                        session.shutdown();
                    }
                    throw throwable;
                }
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        this.updateMemberValues();
        this.updateButtons();
    }

    protected void createMemberValuesGroup(Composite content) {
        this.group = new Group(content, 0);
        this.group.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Label.SelColumnMemberValue"));
        this.group.setLayout((Layout)new GridLayout());
        this.memberValueTable = new Table((Composite)this.group, 68356);
        this.memberValueTable.setLinesVisible(true);
        this.memberValueTable.setHeaderVisible(true);
        this.memberValueTable.setLayoutData((Object)new GridData(1808));
        GridData gd = new GridData(1808);
        gd.heightHint = 150;
        gd.horizontalSpan = 3;
        this.group.setLayoutData((Object)gd);
        this.dynamicViewer = new TableViewer(this.memberValueTable);
        TableColumn column = new TableColumn(this.memberValueTable, 16384);
        column.setText(this.columns[0]);
        column.setWidth(15);
        TableColumn column1 = new TableColumn(this.memberValueTable, 16384);
        column1.setResizable(this.columns[1] != null);
        if (this.columns[1] != null) {
            column1.setText(this.columns[1]);
        }
        column1.setWidth(200);
        TableColumn column2 = new TableColumn(this.memberValueTable, 16384);
        column2.setResizable(this.columns[2] != null);
        if (this.columns[2] != null) {
            column2.setText(this.columns[2]);
        }
        column2.setWidth(200);
        this.dynamicViewer.setColumnProperties(this.columns);
        this.editor = new ExpressionValueCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        TextCellEditor textEditor2 = new TextCellEditor((Composite)this.dynamicViewer.getTable(), 8);
        CellEditor[] cellEditors = new CellEditor[]{textEditor, textEditor2, this.editor};
        if (this.designHandle != null) {
            this.editor.setExpressionProvider((IExpressionProvider)this.getCrosstabExpressionProvider());
            this.editor.setReportElement((ExtendedItemHandle)this.designHandle);
        }
        this.dynamicViewer.setCellEditors(cellEditors);
        this.dynamicViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.dynamicViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.dynamicViewer.setCellModifier(this.cellModifier);
        this.dynamicViewer.addSelectionChangedListener(this.selectionChangeListener);
    }

    protected void syncViewProperties() {
        if (this.filterConditionElement != null) {
            this.groupBtn.setSelection(this.levelViewHandle != null);
            this.measureBtn.setSelection(this.measureViewHandle != null);
            this.detailBtn.setSelection(this.crosstabHandle != null);
            this.targetSelectionChanged();
            this.valueVisible = CrosstabFilterConditionBuilder.determineValueVisible(this.filterConditionElement.getOperator());
            if (this.valueVisible == 3) {
                this.createValueListComposite(this.valuesComposite);
                this.valueList = new ArrayList(this.filterConditionElement.getValue1ExpressionList().getListValue());
                if (this.valueList != null) {
                    this.tableViewer.setInput((Object)this.valueList);
                }
            } else {
                this.create2ValueComposite(this.valuesComposite);
                if (this.filterConditionElement != null) {
                    if (this.filterConditionElement.getValue1ExpressionList().getListValue() != null && this.filterConditionElement.getValue1ExpressionList().getListValue().size() > 0) {
                        ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue1, (Expression)((Expression)this.filterConditionElement.getValue1ExpressionList().getListValue().get(0)));
                    }
                    ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionValue2, (Object)this.filterConditionElement, (String)"value2");
                }
            }
            int index = 0;
            if (this.levelViewHandle != null) {
                index = this.groupLevelList.indexOf(this.levelViewHandle);
                if (index >= 0) {
                    this.groupGroupLevel.select(index + 1);
                }
            } else if (this.measureViewHandle != null && (index = this.measureList.indexOf(this.measureViewHandle)) >= 0) {
                this.measureGroupLevel.select(index + 1);
            }
            ExpressionButtonUtil.initExpressionButtonControl((Control)this.expressionCCombo, (Object)this.filterConditionElement, (String)"expr");
            this.operator.select(CrosstabFilterConditionBuilder.getIndexForOperatorValue(this.filterConditionElement.getOperator()));
            this.operatorChange();
            int vv = CrosstabFilterConditionBuilder.determineValueVisible(this.filterConditionElement.getOperator());
            if (vv == 0) {
                this.expressionValue1.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(false);
                this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 1) {
                this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
                this.expressionValue2.setVisible(false);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(false);
                this.andLable.setVisible(false);
            } else if (vv == 2) {
                this.expressionValue1.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).getControl().setVisible(true);
                this.expressionValue2.setVisible(true);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).getControl().setVisible(true);
                this.andLable.setVisible(true);
                this.andLable.setEnabled(true);
            } else if (this.valueVisible == 3) {
                if (this.expressionCCombo.getText().length() == 0) {
                    this.setEnableValueListComposite(false);
                } else {
                    this.setEnableValueListComposite(true);
                }
            }
        }
        this.updateMemberValues();
        this.updateButtons();
    }

    private void setEnableValueListComposite(boolean val) {
        if (this.valueListConList.size() > 0) {
            int count = this.valueListConList.size();
            int i = 0;
            while (i < count) {
                Object obj = this.valueListConList.get(i);
                if (obj instanceof Control && !((Widget)obj).isDisposed()) {
                    ((Control)obj).setEnabled(val);
                }
                ++i;
            }
        }
    }

    private List getSelectedValueList() {
        if (!this.needRefreshList) {
            return this.selValueList;
        }
        CubeHandle cube = null;
        CrosstabReportItemHandle crosstab = null;
        if (this.designHandle instanceof ExtendedItemHandle) {
            try {
                IReportItem obj = ((ExtendedItemHandle)this.designHandle).getReportItem();
                if (obj instanceof CrosstabReportItemHandle) {
                    crosstab = (CrosstabReportItemHandle)obj;
                }
                crosstab = (CrosstabReportItemHandle)((ExtendedItemHandle)this.designHandle).getReportItem();
                cube = crosstab.getCube();
            }
            catch (ExtendedElementException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        if (cube == null || this.expressionCCombo.getText().length() == 0) {
            return new ArrayList();
        }
        Iterator iter = null;
        ICubeQueryDefinition cubeQueryDefn = null;
        DataRequestSession session = null;
        try {
            String expression = null;
            expression = "javascript".equals(ExpressionButtonUtil.getExpression((Control)this.expressionCCombo).getType()) ? this.expressionCCombo.getText() : ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.expressionCCombo).convertExpression(this.expressionCCombo.getText(), "javascript", "cube");
            session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3, this.designHandle.getModuleHandle()));
            DataService.getInstance().registerSession(cube, session);
            cubeQueryDefn = CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)crosstab) ? CrosstabUIHelper.createBindingQuery(crosstab, true) : CrosstabUIHelper.createBindingQuery(crosstab);
            Map context = session.getDataSessionContext().getAppContext();
            iter = CubeValueSelector.getMemberValueIterator((DataRequestSession)session, (CubeHandle)cube, (String)expression, (ICubeQueryDefinition)cubeQueryDefn, (Map)context);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        this.selValueList = new ArrayList();
        int count = 0;
        int MAX_COUNT = PreferenceFactory.getInstance().getPreferences((AbstractUIPlugin)CrosstabPlugin.getDefault(), UIUtil.getCurrentProject()).getInt("Filter.Limit");
        while (iter != null && iter.hasNext()) {
            Object obj = iter.next();
            if (obj == null || this.selValueList.indexOf(obj) >= 0) continue;
            this.selValueList.add(obj);
            if (++count >= MAX_COUNT) break;
        }
        this.needRefreshList = false;
        if (session != null) {
            session.shutdown();
        }
        return this.selValueList;
    }

    private List getMeasures() {
        if (this.measureList != null) {
            return this.measureList;
        }
        this.measureList = new ArrayList();
        this.measureNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return this.measureList;
        }
        int count = crossTab.getMeasureCount();
        int i = 0;
        while (i < count) {
            MeasureViewHandle measure = crossTab.getMeasure(i);
            if (!(measure instanceof ComputedMeasureViewHandle) && measure.getCubeMeasure() != null) {
                this.measureList.add(measure);
                this.measureNameList.add(measure.getCubeMeasure().getFullName());
            }
            ++i;
        }
        return this.measureList;
    }

    private List getLevels() {
        DesignElementHandle elementHandle;
        if (this.groupLevelList != null) {
            return this.groupLevelList;
        }
        this.groupLevelList = new ArrayList();
        this.groupLevelNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crossTab = null;
        try {
            crossTab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTab == null) {
            return this.groupLevelList;
        }
        if (crossTab.getCrosstabView(1) != null) {
            elementHandle = crossTab.getCrosstabView(1).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        if (crossTab.getCrosstabView(0) != null) {
            elementHandle = crossTab.getCrosstabView(0).getModelHandle();
            this.getLevel((ExtendedItemHandle)elementHandle);
        }
        return this.groupLevelList;
    }

    private void getLevel(ExtendedItemHandle handle) {
        CrosstabViewHandle crossTabViewHandle = null;
        try {
            crossTabViewHandle = (CrosstabViewHandle)handle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (crossTabViewHandle == null) {
            return;
        }
        int dimensionCount = crossTabViewHandle.getDimensionCount();
        int i = 0;
        while (i < dimensionCount) {
            DimensionViewHandle dimension = crossTabViewHandle.getDimension(i);
            int levelCount = dimension.getLevelCount();
            int j = 0;
            while (j < levelCount) {
                LevelViewHandle levelHandle = dimension.getLevel(j);
                this.groupLevelList.add(levelHandle);
                if (levelHandle.getCubeLevel() != null) {
                    this.groupLevelNameList.add(levelHandle.getCubeLevel().getFullName());
                }
                ++j;
            }
            ++i;
        }
    }

    protected void checkAddButtonStatus() {
        if (this.addExpressionValue != null) {
            String value = this.addExpressionValue.getText();
            if (value == null || value.length() == 0 || value.trim().length() == 0) {
                this.addBtn.setEnabled(false);
                return;
            }
            if (this.valueList.indexOf(ExpressionButtonUtil.getExpression((Control)this.addExpressionValue)) < 0) {
                this.addBtn.setEnabled(true);
            } else {
                this.addBtn.setEnabled(false);
            }
        }
    }

    protected void checkEditDelButtonStatus() {
        StructuredSelection selection;
        boolean enabled;
        if (this.tableViewer == null) {
            return;
        }
        boolean bl = enabled = this.tableViewer.getSelection() != null;
        if (enabled && this.tableViewer.getSelection() instanceof StructuredSelection && (selection = (StructuredSelection)this.tableViewer.getSelection()).toList().size() <= 0) {
            enabled = false;
        }
        this.editBtn.setEnabled(enabled);
        this.delBtn.setEnabled(enabled);
        enabled = this.table.getItemCount() > 0;
        this.delAllBtn.setEnabled(enabled);
    }

    protected boolean isConditionOK() {
        if (this.groupBtn.getSelection() && this.groupGroupLevel.getText() != null && (this.groupGroupLevel.getText().length() == 0 || this.groupGroupLevel.getSelectionIndex() == 0)) {
            return false;
        }
        if (this.measureBtn.getSelection() && this.measureGroupLevel.getText() != null && (this.measureGroupLevel.getText().length() == 0 || this.measureGroupLevel.getSelectionIndex() == 0)) {
            return false;
        }
        if (this.expressionCCombo == null || !this.isExpressionOK()) {
            return false;
        }
        return this.checkValues();
    }

    protected boolean isExpressionOK() {
        return this.expressionCCombo != null && this.expressionCCombo.isEnabled() && this.expressionCCombo.getText() != null && this.expressionCCombo.getText().length() != 0;
    }

    protected void okPressed() {
        LevelViewHandle level = null;
        MeasureViewHandle measure = null;
        CrosstabReportItemHandle crosstab = null;
        if (this.groupBtn.getSelection()) {
            level = (LevelViewHandle)this.groupLevelList.get(this.groupGroupLevel.getSelectionIndex() - 1);
        } else if (this.measureBtn.getSelection()) {
            measure = (MeasureViewHandle)this.measureList.get(this.measureGroupLevel.getSelectionIndex() - 1);
        } else if (this.detailBtn.getSelection()) {
            ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
            try {
                crosstab = (CrosstabReportItemHandle)element.getReportItem();
            }
            catch (ExtendedElementException e) {
                ExceptionUtil.handle((Throwable)e);
            }
        }
        try {
            FilterConditionElementHandle filter;
            if (this.filterConditionElement == null) {
                filter = DesignElementFactory.getInstance().newFilterConditionElement();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator(this.operator.getText())));
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionCCombo, (Object)filter, (String)"expr");
                if (!this.detailBtn.getSelection()) {
                    filter.setUpdateAggregation(Boolean.valueOf(this.updateAggrButton.getSelection()).booleanValue());
                }
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2("");
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        filter.setValue1(valueList);
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, (Object)filter, (String)"value2");
                    } else {
                        filter.setValue2(this.NULL_STRING);
                    }
                }
                if (level != null) {
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        filter.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                    level.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (measure != null) {
                    measure.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (crosstab != null) {
                    crosstab.getModelHandle().add("filter", (DesignElementHandle)filter);
                }
            } else if (this.groupBtn.getSelection() && level == this.levelViewHandle || this.measureBtn.getSelection() && measure == this.measureViewHandle) {
                this.filterConditionElement.setOperator(DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator(this.operator.getText())));
                this.filterConditionElement.setUpdateAggregation(this.updateAggrButton.getSelection());
                if (this.valueVisible == 3) {
                    this.filterConditionElement.setValue1(this.valueList);
                    this.filterConditionElement.setValue2(this.NULL_STRING);
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        this.filterConditionElement.setValue1(valueList);
                    } else {
                        this.filterConditionElement.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, (Object)this.filterConditionElement, (String)"value2");
                    } else {
                        this.filterConditionElement.setValue2(this.NULL_STRING);
                    }
                }
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionCCombo, (Object)this.filterConditionElement, (String)"expr");
                if (this.groupBtn.getSelection()) {
                    if (this.filterConditionElement.getMember() != null) {
                        this.filterConditionElement.drop("member", 0);
                    }
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        this.filterConditionElement.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                } else if (this.measureBtn.getSelection() && this.filterConditionElement.getMember() != null) {
                    this.filterConditionElement.drop("member", 0);
                }
            } else {
                filter = DesignElementFactory.getInstance().newFilterConditionElement();
                filter.setProperty("operator", (Object)DEUtil.resolveNull((String)CrosstabFilterConditionBuilder.getValueForOperator(this.operator.getText())));
                ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionCCombo, (Object)filter, (String)"expr");
                if (this.valueVisible == 3) {
                    filter.setValue1(this.valueList);
                    filter.setValue2(this.NULL_STRING);
                } else {
                    assert (!this.expressionValue1.isDisposed());
                    assert (!this.expressionValue2.isDisposed());
                    if (this.expressionValue1.getVisible()) {
                        ArrayList<Expression> valueList = new ArrayList<Expression>();
                        valueList.add(ExpressionButtonUtil.getExpression((Control)this.expressionValue1));
                        filter.setValue1(valueList);
                    } else {
                        filter.setValue1(this.NULL_STRING);
                    }
                    if (this.expressionValue2.getVisible()) {
                        ExpressionButtonUtil.saveExpressionButtonControl((Control)this.expressionValue2, (Object)filter, (String)"value2");
                    } else {
                        filter.setValue2(this.NULL_STRING);
                    }
                }
                if (this.levelViewHandle != null) {
                    this.levelViewHandle.getModelHandle().drop("filter", (DesignElementHandle)this.filterConditionElement);
                }
                if (this.measureViewHandle != null) {
                    this.measureViewHandle.getModelHandle().drop("filter", (DesignElementHandle)this.filterConditionElement);
                }
                if (this.crosstabHandle != null) {
                    this.crosstabHandle.getModelHandle().drop("filter", (DesignElementHandle)this.filterConditionElement);
                }
                if (level != null) {
                    if (this.referencedLevelList != null && this.referencedLevelList.size() > 0) {
                        filter.add("member", (DesignElementHandle)this.memberValueHandle);
                    }
                    level.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (measure != null) {
                    measure.getModelHandle().add("filter", (DesignElementHandle)filter);
                } else if (crosstab != null) {
                    crosstab.getModelHandle().add("filter", (DesignElementHandle)filter);
                }
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
        this.setReturnCode(0);
        this.close();
    }

    private List getReferableBindings(Object target) {
        List retList = new ArrayList();
        String targetString = null;
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException ex) {
            ExceptionUtil.handle((Throwable)ex);
        }
        if (target instanceof LevelViewHandle) {
            LevelViewHandle level = (LevelViewHandle)target;
            if (level.getCubeLevel() == null) {
                return retList;
            }
            DimensionHandle dimensionHandle = CrosstabAdaptUtil.getDimensionHandle(level.getCubeLevel());
            targetString = ExpressionUtil.createJSDimensionExpression((String)dimensionHandle.getName(), (String)level.getCubeLevel().getName());
        } else if (target instanceof MeasureViewHandle) {
            MeasureViewHandle measure = (MeasureViewHandle)target;
            if (measure.getCubeMeasure() == null) {
                return retList;
            }
            targetString = measure.getCubeMeasure().getName();
        } else if (target instanceof String) {
            targetString = (String)target;
        }
        DataRequestSession session = null;
        try {
            try {
                session = DataRequestSession.newSession((DataSessionContext)new DataSessionContext(3));
                retList = this.getReferableBindings(session, crosstab, target, targetString);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
                if (session != null) {
                    session.shutdown();
                }
            }
        }
        finally {
            if (session != null) {
                session.shutdown();
            }
        }
        return retList;
    }

    private MemberValueHandle getChildMemberValue(MemberValueHandle memberValue) {
        if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) {
            return null;
        }
        return (MemberValueHandle)memberValue.getContent("memberValues", 0);
    }

    private void dropChildMemberValue(MemberValueHandle memberValue) {
        MemberValueHandle child = this.getChildMemberValue(memberValue);
        if (child == null) {
            return;
        }
        try {
            memberValue.drop("memberValues", 0);
        }
        catch (SemanticException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private MemberValueHandle updateMemberValuesFromLevelList(List referenceLevels, MemberValueHandle memberValue) {
        if (this.measureBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            return null;
        }
        this.memberValueGroup.setVisible(true);
        int count = referenceLevels.size();
        MemberValueHandle lastMemberValue = memberValue;
        int hasCount = 0;
        while (true) {
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(++hasCount - 1));
            if (!(lastMemberValue.getLevel() == tempLevel || lastMemberValue.getCubeLevelName().equals(tempLevel.getFullName()) && this.isBoundToLinkedDataSet())) {
                try {
                    lastMemberValue.setLevel(tempLevel);
                    this.dropChildMemberValue(lastMemberValue);
                }
                catch (SemanticException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                break;
            }
            if (this.getChildMemberValue(lastMemberValue) == null) break;
            if (hasCount >= count) {
                this.dropChildMemberValue(lastMemberValue);
                break;
            }
            lastMemberValue = this.getChildMemberValue(lastMemberValue);
        }
        int i = hasCount;
        while (i < count) {
            MemberValueHandle newValue = DesignElementFactory.getInstance().newMemberValue();
            LevelHandle tempLevel = this.getLevelHandle((IDimensionLevel)referenceLevels.get(i));
            try {
                newValue.setLevel(tempLevel);
                newValue.setValue("");
                lastMemberValue.add("memberValues", (DesignElementHandle)newValue);
            }
            catch (SemanticException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
            lastMemberValue = newValue;
            ++i;
        }
        return memberValue;
    }

    private boolean isBoundToLinkedDataSet() {
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)((ExtendedItemHandle)this.designHandle).getReportItem();
        }
        catch (ExtendedElementException e) {
            return false;
        }
        return CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)crosstab);
    }

    private LevelHandle getLevelHandle(IDimensionLevel levelInfo) {
        String levelName = levelInfo.getLevelName();
        String dimensionName = levelInfo.getDimensionName();
        ExtendedItemHandle extHandle = (ExtendedItemHandle)this.designHandle;
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)extHandle.getReportItem();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        DimensionViewHandle dimension = CrosstabUtil.getDimensionViewHandle((CrosstabReportItemHandle)crosstab, (String)dimensionName);
        LevelViewHandle level = dimension.findLevel(levelName);
        LevelHandle levelHandle = level.getCubeLevel();
        return levelHandle;
    }

    private void updateMemberValues() {
        if (!this.groupBtn.getSelection()) {
            this.memberValueGroup.setVisible(false);
            return;
        }
        this.memberValueGroup.setVisible(true);
        if (this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) <= 0 || this.expressionCCombo.getText().length() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        LevelViewHandle level = null;
        if (this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) > 0 && this.groupLevelList != null && this.groupLevelList.size() > 0 && this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) - 1 < this.groupLevelList.size()) {
            level = (LevelViewHandle)this.groupLevelList.get(this.groupGroupLevel.indexOf(this.groupGroupLevel.getText()) - 1);
        }
        if (level == null) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        if (level.getAxisType() == 1) {
            this.group.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Label.SelColumnMemberValue"));
        } else {
            this.group.setText(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.Label.SelRowMemberValue"));
        }
        String expression = null;
        if ("javascript".equals(ExpressionButtonUtil.getExpression((Control)this.expressionCCombo).getType())) {
            expression = this.expressionCCombo.getText();
        } else {
            String bindingName = ExpressionButtonUtil.getCurrentExpressionConverter((Control)this.expressionCCombo).getBinding(this.expressionCCombo.getText());
            expression = ExpressionUtility.getExpressionConverter((String)"javascript").getCubeBindingExpression(bindingName);
        }
        this.referencedLevelList = CrosstabUtil.getReferencedLevels(level, (String)expression);
        if (this.referencedLevelList == null || this.referencedLevelList.size() == 0) {
            this.memberValueTable.setEnabled(false);
            return;
        }
        this.editor.setReferencedLevelList(this.referencedLevelList);
        this.memberValueTable.setEnabled(true);
        this.memberValueHandle = null;
        if (level == this.levelViewHandle) {
            this.memberValueHandle = this.filterConditionElement.getMember();
        }
        if (this.memberValueHandle == null) {
            this.memberValueHandle = DesignElementFactory.getInstance().newMemberValue();
            try {
                this.memberValueHandle.setValue("");
                this.memberValueHandle.setLevel(this.getLevelHandle((IDimensionLevel)this.referencedLevelList.get(0)));
            }
            catch (SemanticException e) {
                ExceptionHandler.handle((Throwable)e);
            }
        }
        this.memberValueHandle = this.updateMemberValuesFromLevelList(this.referencedLevelList, this.memberValueHandle);
        List memList = this.getMemberValueList(this.memberValueHandle);
        this.dynamicViewer.setInput((Object)memList);
    }

    private List getMemberValueList(MemberValueHandle parent) {
        ArrayList<MemberValueHandle> list = new ArrayList<MemberValueHandle>();
        if (parent == null) {
            return list;
        }
        MemberValueHandle memberValue = parent;
        while (true) {
            list.add(memberValue);
            if (memberValue.getContentCount("memberValues") != 1 || memberValue.getContent("memberValues", 0) == null) break;
            memberValue = (MemberValueHandle)memberValue.getContent("memberValues", 0);
        }
        return list;
    }

    protected void setButtonCGridLayoutData(Button button) {
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        button.setLayoutData((Object)GridDataFactory.swtDefaults().hint(Math.max(widthHint, minSize.x), -1).create());
    }

    protected void editTableValue() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.getFirstElement() != null && selection.getFirstElement() instanceof Expression) {
            Expression initValue = (Expression)selection.getFirstElement();
            ExpressionEditor editor = new ExpressionEditor(org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.ExpressionEditor.Title"));
            editor.setExpression(initValue);
            editor.setInput((Object)this.filterConditionElement, (IExpressionProvider)this.getCrosstabExpressionProvider(), false);
            if (editor.open() == 0) {
                Expression result = editor.getExpression();
                if (result == null || result.getStringExpression() == null || result.getStringExpression().length() == 0) {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.MsgDlg.Title"), (String)org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("CrosstabFilterConditionBuilder.MsgDlg.Msg"));
                    return;
                }
                int index = this.table.getSelectionIndex();
                this.valueList.remove(index);
                this.valueList.add(index, result);
                this.tableViewer.refresh();
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.editBtn.setEnabled(false);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.updateButtons();
    }

    protected void updateButtons() {
        this.enableInput(this.isExpressionOK());
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(this.isConditionOK());
        }
    }

    protected void enableInput(boolean val) {
        this.operator.setEnabled(val);
        if (this.valueVisible != 3) {
            if (this.expressionValue1 != null) {
                this.expressionValue1.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue1).setEnabled(val);
            }
            if (this.expressionValue2 != null) {
                this.expressionValue2.setEnabled(val);
                ExpressionButtonUtil.getExpressionButton((Control)this.expressionValue2).setEnabled(val);
            }
            if (this.andLable != null) {
                this.andLable.setEnabled(val);
            }
        } else {
            this.setControlEnable((Control)this.valueListComposite, val);
            if (val) {
                this.checkAddButtonStatus();
                this.checkEditDelButtonStatus();
            }
        }
        if (this.updateAggrButton != null) {
            this.updateAggrButton.setEnabled(val);
        }
    }

    protected void setControlEnable(Control control, boolean bool) {
        if (control == null || control.isDisposed()) {
            return;
        }
        control.setEnabled(bool);
        Composite tmp = null;
        if (control instanceof Composite) {
            tmp = (Composite)control;
        }
        if (tmp != null && tmp.getChildren() != null) {
            int i = 0;
            while (i < tmp.getChildren().length) {
                this.setControlEnable(tmp.getChildren()[i], bool);
                ++i;
            }
        }
    }

    protected boolean checkValues() {
        if (this.valueVisible == 3) {
            return this.valueList.size() > 0;
        }
        assert (!this.expressionValue1.isDisposed());
        assert (!this.expressionValue2.isDisposed());
        if (this.expressionValue1.getVisible() && (this.expressionValue1.getText() == null || this.expressionValue1.getText().trim().length() == 0)) {
            return false;
        }
        return !this.expressionValue2.getVisible() || this.expressionValue2.getText() != null && this.expressionValue2.getText().trim().length() != 0;
    }

    protected void delTableValue() {
        int index = this.table.getSelectionIndex();
        if (index > -1) {
            this.valueList.remove(index);
            this.tableViewer.refresh();
            if (this.valueList.size() > 0) {
                if (this.valueList.size() <= index) {
                    --index;
                }
                this.table.select(index);
            }
            this.updateButtons();
        } else {
            this.delBtn.setEnabled(false);
        }
    }

    private List getCubeLevelNames() {
        if (this.cubeLevelNameList != null) {
            return this.cubeLevelNameList;
        }
        this.cubeLevelNameList = new ArrayList();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CubeHandle cube = null;
        try {
            cube = ((CrosstabReportItemHandle)element.getReportItem()).getCube();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (cube == null) {
            return this.cubeLevelNameList;
        }
        Object[] dimensions = cube.getContents("dimensions").toArray();
        TabularDimensionNodeProvider dimensionProvider = new TabularDimensionNodeProvider();
        TabularLevelNodeProvider levelProvider = new TabularLevelNodeProvider();
        Object[] objectArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof DimensionHandle) {
                Object[] levels;
                DimensionHandle dimension = (DimensionHandle)o;
                Object[] objectArray2 = levels = dimensionProvider.getChildren(o);
                int n3 = levels.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object l = objectArray2[n4];
                    if (l instanceof LevelHandle) {
                        Object[] attrs;
                        LevelHandle level = (LevelHandle)l;
                        String levelName = String.valueOf(dimension.getName()) + "/" + level.getName();
                        if (!this.isGroupLevel(levelName)) {
                            this.cubeLevelNameList.add(levelName);
                        }
                        Object[] objectArray3 = attrs = levelProvider.getChildren(l);
                        int n5 = attrs.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            Object a = objectArray3[n6];
                            if (a instanceof LevelAttributeHandle) {
                                LevelAttributeHandle attr = (LevelAttributeHandle)a;
                                levelName = String.valueOf(dimension.getName()) + "/" + level.getName() + "/" + attr.getName();
                                if (!this.isGroupLevel(levelName)) {
                                    this.cubeLevelNameList.add(levelName);
                                }
                            }
                            ++n6;
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return this.cubeLevelNameList;
    }

    private List<LevelHandle> getCubeLevels() {
        ArrayList<LevelHandle> lhs = new ArrayList<LevelHandle>();
        ExtendedItemHandle element = (ExtendedItemHandle)this.designHandle;
        CubeHandle cube = null;
        try {
            cube = ((CrosstabReportItemHandle)element.getReportItem()).getCube();
        }
        catch (ExtendedElementException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        if (cube == null) {
            return lhs;
        }
        Object[] dimensions = cube.getContents("dimensions").toArray();
        TabularDimensionNodeProvider dimensionProvider = new TabularDimensionNodeProvider();
        TabularLevelNodeProvider levelProvider = new TabularLevelNodeProvider();
        Object[] objectArray = dimensions;
        int n = dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof DimensionHandle) {
                Object[] levels;
                DimensionHandle dimension = (DimensionHandle)o;
                Object[] objectArray2 = levels = dimensionProvider.getChildren(o);
                int n3 = levels.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object l = objectArray2[n4];
                    if (l instanceof LevelHandle) {
                        lhs.add((LevelHandle)l);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return lhs;
    }

    private boolean isGroupLevel(String levelName) {
        for (Object level : this.groupLevelNameList) {
            if (!levelName.equals(level)) continue;
            return true;
        }
        return false;
    }

    private List getReferableBindings(DataRequestSession session, CrosstabReportItemHandle crosstab, Object target, String targetString) throws Exception {
        List retList = new ArrayList();
        if (CrosstabUtil.isBoundToLinkedDataSet((AbstractCrosstabItemHandle)crosstab)) {
            ICubeQueryDefinition cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab, true);
            if (this.groupBtn.getSelection() || target instanceof LevelViewHandle || target instanceof String) {
                retList = session.getCubeQueryUtil().getReferableBindingsForLinkedDataSetCube(targetString, cubeQueryDefn, false);
            } else if (this.measureBtn.getSelection() || target instanceof MeasureViewHandle) {
                retList = session.getCubeQueryUtil().getReferableMeasureBindingsForLinkedDataSetCube(targetString, cubeQueryDefn);
            }
        } else {
            ICubeQueryDefinition cubeQueryDefn = CrosstabUIHelper.createBindingQuery(crosstab);
            if (this.groupBtn.getSelection() || target instanceof LevelViewHandle || target instanceof String) {
                retList = session.getCubeQueryUtil().getReferableBindings(targetString, cubeQueryDefn, false);
            } else if (this.measureBtn.getSelection() || target instanceof MeasureViewHandle) {
                retList = session.getCubeQueryUtil().getReferableMeasureBindings(targetString, cubeQueryDefn);
            }
        }
        return retList;
    }

    private CrosstabReportItemHandle getCrosstab(ExtendedItemHandle element) {
        CrosstabReportItemHandle crosstab = null;
        try {
            crosstab = (CrosstabReportItemHandle)element.getReportItem();
        }
        catch (ExtendedElementException ex) {
            ExceptionUtil.handle((Throwable)ex);
        }
        return crosstab;
    }

    static class BindingGroup {
        int type;
        List list = new ArrayList();

        BindingGroup(int type) {
            this.type = type;
        }

        void addBinding(String bindingName) {
            this.list.add(bindingName);
        }

        List getBindings() {
            return this.list;
        }

        String getBindingGroupName() {
            if (this.type == 1) {
                return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.Measures");
            }
            if (this.type == 2) {
                return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.Dimension");
            }
            if (this.type == 11) {
                return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.GrandTotal");
            }
            if (this.type == 12) {
                return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.SubTotal");
            }
            if (this.type == 13) {
                return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.OtherType");
            }
            return org.eclipse.birt.report.item.crosstab.ui.i18n.Messages.getString("FilterbyTree.Bindings.Catogory.Undefined");
        }
    }
}

