/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.elements.structures.PropertyBinding;
import org.eclipse.birt.report.model.api.elements.structures.StyleRule;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.ContainerContext;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.AbstractScalarParameter;
import org.eclipse.birt.report.model.elements.AbstractTheme;
import org.eclipse.birt.report.model.elements.AutoText;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataGroup;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.DerivedDataSet;
import org.eclipse.birt.report.model.elements.DynamicFilterParameter;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.FilterConditionElement;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.LineItem;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.MemberValue;
import org.eclipse.birt.report.model.elements.MultiViews;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.RectangleItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ReportItemTheme;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.ScriptDataSet;
import org.eclipse.birt.report.model.elements.ScriptDataSource;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.elements.SortElement;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateDataSet;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.elements.VariableElement;
import org.eclipse.birt.report.model.elements.olap.Cube;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.elements.olap.Hierarchy;
import org.eclipse.birt.report.model.elements.olap.Level;
import org.eclipse.birt.report.model.elements.olap.Measure;
import org.eclipse.birt.report.model.elements.olap.MeasureGroup;
import org.eclipse.birt.report.model.elements.olap.OdaCube;
import org.eclipse.birt.report.model.elements.olap.OdaDimension;
import org.eclipse.birt.report.model.elements.olap.OdaHierarchy;
import org.eclipse.birt.report.model.elements.olap.OdaLevel;
import org.eclipse.birt.report.model.elements.olap.OdaMeasure;
import org.eclipse.birt.report.model.elements.olap.OdaMeasureGroup;
import org.eclipse.birt.report.model.elements.olap.TabularCube;
import org.eclipse.birt.report.model.elements.olap.TabularDimension;
import org.eclipse.birt.report.model.elements.olap.TabularHierarchy;
import org.eclipse.birt.report.model.elements.olap.TabularLevel;
import org.eclipse.birt.report.model.elements.olap.TabularMeasure;
import org.eclipse.birt.report.model.elements.olap.TabularMeasureGroup;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.ODAExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.parser.treebuild.ContentNode;
import org.eclipse.birt.report.model.parser.treebuild.ContentTree;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.EncryptionUtil;
import org.eclipse.birt.report.model.util.LineNumberInfo;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.XMLWriter;
import org.eclipse.birt.report.model.writer.BoundColumnsWriterMgr;
import org.eclipse.birt.report.model.writer.IndentableXMLWriter;

abstract class ModuleWriterImpl
extends ElementVisitor {
    protected static final String DEFAULT_NAME_SPACE = "http://www.eclipse.org/birt/2005/design";
    protected XMLWriter writer = null;
    protected BoundColumnsWriterMgr boundColumnsMgr = null;
    protected boolean markLineNumber = true;
    protected boolean enableLibraryTheme = false;

    ModuleWriterImpl() {
    }

    protected abstract Module getModule();

    public void write(File outputFile) throws IOException {
        ModuleOption options = this.getModule().getOptions();
        if (options != null) {
            this.markLineNumber = options.markLineNumber();
        }
        this.writer = new IndentableXMLWriter(outputFile, this.getModule().getUTFSignature(), this.markLineNumber);
        this.writeFile();
        this.writer.close();
    }

    public void write(OutputStream os) throws IOException {
        ModuleOption options = this.getModule().getOptions();
        if (options != null) {
            this.markLineNumber = options.markLineNumber();
        }
        this.writer = new IndentableXMLWriter(os, this.getModule().getUTFSignature(), this.markLineNumber);
        this.writeFile();
    }

    protected final void writeFile() {
        this.initBoundColumnsMgr();
        this.getModule().apply(this);
        this.getModule().getVersionManager().setVersion("3.2.24");
    }

    protected void attribute(DesignElement obj, String attr, String propName) {
        ElementPropertyDefn prop = obj.getPropertyDefn(propName);
        assert (prop != null);
        Object value = obj.getLocalProperty(this.getModule(), prop);
        if (value == null) {
            return;
        }
        String xml = prop.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        this.writer.attribute(attr, xml);
    }

    protected void property(DesignElement obj, String propName) {
        this.writeProperty(obj, null, propName, false);
    }

    protected void property(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, false, false);
    }

    protected void propertyCDATA(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, true, false);
    }

    protected void propertyWithoutName(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, false, true);
    }

    protected void resourceKey(DesignElement obj, String resourceKey, String resourceValue) {
        this.resourceKey(obj, resourceKey, resourceValue, false);
    }

    protected void resourceKey(DesignElement obj, String resourceKey, String resourceName, boolean cdata) {
        ElementPropertyDefn nameProp = (ElementPropertyDefn)obj.getDefn().getProperty(resourceName);
        assert (nameProp != null);
        Object value = obj.getLocalProperty(this.getModule(), nameProp.getName());
        String xml = nameProp.getXmlValue(this.getModule(), value);
        ElementPropertyDefn keyProp = (ElementPropertyDefn)obj.getDefn().getProperty(resourceKey);
        assert (keyProp != null);
        value = obj.getLocalProperty(this.getModule(), keyProp.getName());
        String xmlKey = keyProp.getXmlValue(this.getModule(), value);
        if (xmlKey == null && xml == null) {
            return;
        }
        if (cdata) {
            xml = this.escapeCDATAChars(nameProp, xml);
        }
        if (nameProp.getTypeCode() == 8) {
            this.writeResouceKey("html-property", resourceName, xmlKey, xml, cdata);
        } else {
            this.writeResouceKey("text-property", resourceName, xmlKey, xml, cdata);
        }
    }

    protected void resourceKey(IStructure struct, String resourceKey, String resourceName) {
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        assert (structDefn != null);
        StructPropertyDefn nameProp = (StructPropertyDefn)structDefn.getMember(resourceName);
        assert (nameProp != null);
        StructPropertyDefn keyProp = (StructPropertyDefn)structDefn.getMember(resourceKey);
        assert (keyProp != null);
        Object value = null;
        Object keyValue = null;
        if (struct instanceof Structure) {
            value = ((Structure)struct).getLocalProperty(this.getModule(), nameProp);
            keyValue = ((Structure)struct).getLocalProperty(this.getModule(), keyProp);
        } else {
            assert (struct instanceof UserPropertyDefn);
            value = ((UserPropertyDefn)struct).getLocalProperty(this.getModule(), nameProp);
            keyValue = ((UserPropertyDefn)struct).getLocalProperty(this.getModule(), keyProp);
        }
        String xml = nameProp.getXmlValue(this.getModule(), value);
        String xmlKey = keyProp.getXmlValue(this.getModule(), keyValue);
        if (xmlKey == null && xml == null) {
            return;
        }
        if (nameProp.getTypeCode() == 8) {
            this.writeResouceKey("html-property", resourceName, xmlKey, xml, false);
        } else {
            this.writeResouceKey("text-property", resourceName, xmlKey, xml, false);
        }
    }

    protected void resourceKeyCDATA(DesignElement obj, String resourceKey, String resourceValue) {
        this.resourceKey(obj, resourceKey, resourceValue, true);
    }

    protected void writeEntry(String tag, String name, String encryptionID, String value, boolean cdata) {
        this.writeEntry(tag, name, encryptionID, null, value, cdata);
    }

    private void writeEntry(String tag, String name, String encryptionID, String exprType, String value, boolean cdata) {
        this.writer.startElement(tag);
        if (name != null) {
            this.writer.attribute("name", name);
        }
        if (encryptionID != null) {
            this.writer.attribute("encryptionID", encryptionID);
        }
        if (exprType != null) {
            this.writer.attribute("type", exprType);
        }
        if (cdata) {
            this.writer.textCDATA(value);
        } else {
            this.writer.text(value);
        }
        this.writer.endElement();
    }

    private String escapeCDATAChars(PropertyDefn propDefn, String value) {
        if (value == null) {
            return null;
        }
        if (ModelUtil.isExtensionPropertyOwnModel(propDefn)) {
            return value;
        }
        String retValue = value.replace("&", "&amp;");
        retValue = retValue.replaceAll("]]>", "]]&gt;");
        return retValue;
    }

    protected void writeExtendedProperties(List<Object> properties, String propName) {
        if (properties != null && properties.size() != 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", propName);
            for (ExtendedProperty extendedProperty : properties) {
                String encryptionID = null;
                boolean isEncryptable = false;
                List<IElementPropertyDefn> hidePrivatePropsList = null;
                IElementDefn tmpElementDefn = extendedProperty.getElement().getDefn();
                if (tmpElementDefn instanceof ODAExtensionElementDefn) {
                    hidePrivatePropsList = ((ODAExtensionElementDefn)tmpElementDefn).getHidePrivateProps();
                }
                IElementPropertyDefn oadPropertyDefn = null;
                if (hidePrivatePropsList != null && hidePrivatePropsList.size() > 0) {
                    for (IElementPropertyDefn defn : hidePrivatePropsList) {
                        if (!extendedProperty.getName().equals(defn.getName()) || !defn.isEncryptable()) continue;
                        isEncryptable = true;
                        oadPropertyDefn = defn;
                        encryptionID = extendedProperty.getEncryptionID();
                        if (!StringUtil.isBlank(encryptionID)) break;
                        encryptionID = MetaDataDictionary.getInstance().getDefaultEncryptionHelperID();
                        extendedProperty.setEncryptionID(encryptionID);
                        break;
                    }
                }
                this.writer.startElement("ex-property");
                this.writer.attribute("encryptionID", encryptionID);
                if (extendedProperty.getName() != null) {
                    this.writer.startElement("name");
                    this.writer.text(extendedProperty.getName());
                    this.writer.endElement();
                }
                if (extendedProperty.getValue() != null) {
                    this.writer.startElement("value");
                    String value = extendedProperty.getValue();
                    if (isEncryptable) {
                        value = (String)EncryptionUtil.encrypt((PropertyDefn)((Object)oadPropertyDefn), encryptionID, value);
                    }
                    this.writer.text(value);
                    this.writer.endElement();
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    protected void writeBase64Text(String tag, String name, String value) {
        this.writer.startElement(tag);
        if (name != null) {
            this.writer.attribute("name", name);
        }
        this.writer.writeBase64Text(value);
        this.writer.endElement();
    }

    protected void writeProperty(DesignElement obj, String tag, String propName, boolean cdata) {
        int type;
        String xmlCP;
        ElementPropertyDefn propDefn = obj.getPropertyDefn(propName);
        Object valueCP = obj.getLocalProperty(this.getModule(), "OdaConnProfileStorePath");
        if ((propName.equalsIgnoreCase("password") || propName.equalsIgnoreCase("odaPassword")) && valueCP != null && (xmlCP = propDefn.getXmlValue(this.getModule(), valueCP)) != null) {
            return;
        }
        if (propDefn == null) {
            return;
        }
        Object value = obj.getLocalProperty(this.getModule(), propName);
        if (value == null) {
            return;
        }
        String xml = propDefn.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        String exprType = null;
        if (value instanceof Expression) {
            exprType = ((Expression)value).getUserDefinedType();
        }
        String encryptionID = null;
        if (propDefn.isEncryptable()) {
            encryptionID = obj.getEncryptionID(propDefn);
            if (value instanceof String || "constant".equals(exprType)) {
                tag = "encrypted-property";
                exprType = null;
            } else {
                tag = ModelUtil.getTagByPropertyType(propDefn);
                encryptionID = null;
            }
            xml = (String)EncryptionUtil.encrypt(propDefn, encryptionID, xml);
        }
        if (tag == null) {
            tag = ModelUtil.getTagByPropertyType(propDefn);
        }
        if ((type = propDefn.getTypeCode()) == 18 || type == 12) {
            cdata = true;
        }
        if (cdata) {
            xml = this.escapeCDATAChars(propDefn, xml);
        }
        this.writeEntry(tag, propDefn.getName(), encryptionID, exprType, xml, cdata);
    }

    protected void writeProperty(IStructure struct, String tag, String memberName, boolean cdata, boolean withoutName) {
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        assert (structDefn != null);
        StructPropertyDefn propDefn = (StructPropertyDefn)structDefn.getMember(memberName);
        assert (propDefn != null);
        Object value = null;
        if (struct instanceof Structure) {
            value = ((Structure)struct).getLocalProperty(this.getModule(), propDefn);
        } else {
            assert (struct instanceof UserPropertyDefn);
            value = ((UserPropertyDefn)struct).getLocalProperty(this.getModule(), propDefn);
        }
        if (value == null) {
            return;
        }
        String xml = propDefn.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        String exprType = null;
        if (value instanceof Expression) {
            exprType = ((Expression)value).getUserDefinedType();
        }
        if (tag == null) {
            tag = ModelUtil.getTagByPropertyType(propDefn);
        }
        if (propDefn.getTypeCode() == 18) {
            cdata = true;
        }
        if (withoutName) {
            this.writeEntry(tag, null, null, exprType, xml, cdata);
        } else {
            this.writeEntry(tag, memberName, null, exprType, xml, cdata);
        }
    }

    protected void writeResouceKey(String tagName, String name, String key, String xml, boolean cdata) {
        if (key == null && xml == null) {
            return;
        }
        this.writer.startElement(tagName);
        this.writer.attribute("name", name);
        this.writer.attribute("key", key);
        if (cdata) {
            this.writer.textCDATA(xml);
        } else {
            this.writer.text(xml);
        }
        this.writer.endElement();
    }

    protected void writeSimpleStructureList(DesignElement obj, String propName, String memberName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        assert (prop != null);
        assert (prop.getTypeCode() == 16 && prop.isList());
        List list = (List)obj.getLocalProperty(this.getModule(), propName);
        if (list == null || list.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", propName);
        ElementPropertyDefn propDef = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        PropertyDefn memberDefn = (PropertyDefn)propDef.getStructDefn().getMember(memberName);
        for (IStructure struct : list) {
            this.propertyWithoutName(struct, memberDefn.getName());
        }
        this.writer.endElement();
    }

    protected void writeStructure(DesignElement obj, String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (prop == null) {
            return;
        }
        IStructure struct = (IStructure)obj.getLocalProperty(this.getModule(), propName);
        if (struct == null) {
            return;
        }
        this.writer.conditionalStartElement("structure");
        this.writer.attribute("name", propName);
        IStructureDefn structDefn = prop.getStructDefn();
        Iterator<IPropertyDefn> iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn strcutPropDefn = (StructPropertyDefn)iter.next();
            this.writeMember(struct, strcutPropDefn);
        }
        this.writer.endElement();
    }

    private void writeMember(IStructure struct, PropertyDefn propDefn) {
        String propName = propDefn.getName();
        String propNameKey = String.valueOf(propName) + "ID";
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        StructPropertyDefn propKeyDefn = (StructPropertyDefn)structDefn.getMember(propNameKey);
        if (propKeyDefn != null && propKeyDefn.getType().getTypeCode() == 9) {
            this.resourceKey(struct, propNameKey, propName);
            return;
        }
        switch (propDefn.getTypeCode()) {
            case 16: {
                if (propDefn.isList()) {
                    this.writeStructureList(struct, propName);
                    break;
                }
                this.writeStructure(struct, propName);
                break;
            }
            case 20: {
                this.writeSimplePropertyList(struct, propName);
                break;
            }
            default: {
                this.property(struct, propName);
            }
        }
    }

    protected void writeSimplePropertyList(DesignElement obj, String propName) {
        this.writeSimplePropertyList(obj, propName, false);
    }

    protected void writeSimplePropertyList(DesignElement obj, String propName, boolean isCdata) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (prop == null || prop.getTypeCode() != 20) {
            return;
        }
        List values = (List)obj.getLocalProperty(this.getModule(), propName);
        if (values == null || values.isEmpty()) {
            return;
        }
        this.writer.conditionalStartElement("simple-property-list");
        this.writer.attribute("name", propName);
        int i = 0;
        while (i < values.size()) {
            Object tmpItem = values.get(i);
            Object[] tmpValues = prop.getCompatibleTypeAndValue(prop.getSubType(), tmpItem);
            String xmlValue = ((PropertyType)tmpValues[0]).toXml(this.getModule(), prop, tmpValues[1]);
            String exprType = null;
            if (prop.allowExpression() && tmpItem instanceof Expression) {
                exprType = ((Expression)tmpItem).getUserDefinedType();
            }
            this.writer.startElement("value");
            if (exprType != null) {
                this.writer.attribute("type", exprType);
            }
            if (xmlValue != null) {
                if (isCdata) {
                    xmlValue = this.escapeCDATAChars(prop, xmlValue);
                    this.writer.textCDATA(xmlValue);
                } else {
                    this.writer.text(xmlValue);
                }
            } else {
                this.writer.attribute("isNull", true);
            }
            this.writer.endElement();
            ++i;
        }
        this.writer.endElement();
    }

    protected void writeSimplePropertyList(IStructure struct, String propName) {
        PropertyDefn prop = (PropertyDefn)struct.getDefn().getMember(propName);
        if (prop == null || prop.getTypeCode() != 20) {
            return;
        }
        List values = (List)struct.getLocalProperty(this.getModule(), prop);
        if (values == null || values.isEmpty()) {
            return;
        }
        this.writer.conditionalStartElement("simple-property-list");
        this.writer.attribute("name", propName);
        int i = 0;
        while (i < values.size()) {
            Object tmpItem = values.get(i);
            Object[] tmpValues = prop.getCompatibleTypeAndValue(prop.getSubType(), tmpItem);
            String xmlValue = ((PropertyType)tmpValues[0]).toXml(this.getModule(), prop, tmpValues[1]);
            String exprType = null;
            if (prop.allowExpression() && tmpItem instanceof Expression) {
                exprType = ((Expression)values.get(i)).getUserDefinedType();
            }
            this.writer.startElement("value");
            if (exprType != null) {
                this.writer.attribute("type", exprType);
            }
            if (xmlValue != null) {
                this.writer.text(xmlValue);
            } else {
                this.writer.attribute("isNull", true);
            }
            this.writer.endElement();
            ++i;
        }
        this.writer.endElement();
    }

    private void writeStructure(IStructure struct, String memberName) {
        IStructureDefn structDefn = struct.getDefn().getMember(memberName).getStructDefn();
        assert (struct instanceof Structure);
        IStructure memberStruct = (IStructure)((Structure)struct).getLocalProperty(null, (PropertyDefn)struct.getDefn().getMember(memberName));
        if (memberStruct == null) {
            return;
        }
        this.writer.conditionalStartElement("structure");
        this.writer.attribute("name", memberName);
        Iterator<IPropertyDefn> iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn strcutPropDefn = (StructPropertyDefn)iter.next();
            this.writeMember(memberStruct, strcutPropDefn);
        }
        this.writer.endElement();
    }

    protected void writeStructureList(DesignElement obj, String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        assert (prop != null);
        assert (prop.getTypeCode() == 16 && prop.isList());
        List list = (List)obj.getLocalProperty(this.getModule(), propName);
        if (list == null) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", propName);
        for (IStructure struct : list) {
            this.writer.startElement("structure");
            if (LineNumberInfo.isLineNumberSuppoerted(struct)) {
                this.markLineNumber(struct);
            }
            Iterator<IPropertyDefn> memberIter = prop.getStructDefn().propertiesIterator();
            while (memberIter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)memberIter.next();
                if (memberDefn.getType().getTypeCode() == 9) continue;
                if (struct instanceof PropertyBinding && memberDefn.getName().equals("value")) {
                    PropertyBinding propBinding = (PropertyBinding)struct;
                    Expression value = (Expression)propBinding.getProperty(this.getModule(), "value");
                    if (value == null) break;
                    String encryptionID = propBinding.getEncryption();
                    String type = value.getType();
                    if (encryptionID == null || !"constant".equals(type)) {
                        this.writeMember(struct, memberDefn);
                        continue;
                    }
                    String xml = memberDefn.getXmlValue(this.getModule(), value);
                    if (xml == null) break;
                    xml = (String)EncryptionUtil.encrypt(memberDefn, encryptionID, xml);
                    this.writeEntry("encrypted-property", "value", encryptionID, null, xml, false);
                    continue;
                }
                this.writeMember(struct, memberDefn);
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    private void writeStructureList(IStructure obj, String memberName) {
        PropertyDefn prop = (PropertyDefn)obj.getDefn().getMember(memberName);
        assert (prop != null);
        assert (prop.getTypeCode() == 16 && prop.isList());
        assert (obj instanceof Structure);
        List list = (List)((Structure)obj).getLocalProperty(this.getModule(), prop);
        if (list == null) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", memberName);
        for (IStructure struct : list) {
            this.writer.startElement("structure");
            if (LineNumberInfo.isLineNumberSuppoerted(struct)) {
                this.markLineNumber(struct);
            }
            Iterator<IPropertyDefn> memberIter = prop.getStructDefn().propertiesIterator();
            while (memberIter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)memberIter.next();
                if (memberDefn.getType().getTypeCode() == 9) continue;
                this.writeMember(struct, memberDefn);
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeUserPropertyDefns(DesignElement obj) {
        List<UserPropertyDefn> props = obj.getLocalUserProperties();
        if (props == null || props.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", "userProperties");
        for (UserPropertyDefn propDefn : props) {
            IChoiceSet choiceSet;
            this.writer.startElement("structure");
            this.property(propDefn, "name");
            this.property(propDefn, "type");
            this.property(propDefn, "isVisible");
            this.resourceKey(propDefn, "displayNameID", "displayName");
            Object defaultValue = propDefn.getDefault();
            if (defaultValue != null) {
                if (defaultValue instanceof Expression && propDefn.allowExpression()) {
                    this.writeEntry("expression", "default", null, ((Expression)defaultValue).getType(), propDefn.getXmlValue(null, defaultValue), false);
                } else {
                    this.writeEntry("property", "default", null, propDefn.getXmlValue(null, defaultValue), false);
                }
            }
            if ((choiceSet = propDefn.getChoices()) != null && choiceSet.getChoices() != null && choiceSet.getChoices().length > 0) {
                this.writer.startElement("list-property");
                this.writer.attribute("name", "choices");
                IChoice[] choices = choiceSet.getChoices();
                int i = 0;
                while (i < choices.length) {
                    UserChoice choice = (UserChoice)choices[i];
                    this.writer.startElement("structure");
                    this.writeEntry("property", "name", null, choice.getName(), false);
                    if (choice.getValue() != null) {
                        this.writeEntry("property", "value", null, choice.getValue().toString(), false);
                    }
                    this.writeResouceKey("text-property", "displayName", choice.getDisplayNameKey(), choice.getDisplayName(), false);
                    this.writer.endElement();
                    ++i;
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeUserPropertyValues(DesignElement obj) {
        List<UserPropertyDefn> userProps = obj.getUserProperties();
        if (userProps == null || userProps.size() == 0) {
            return;
        }
        for (UserPropertyDefn propDefn : userProps) {
            this.property(obj, propDefn.getName());
        }
    }

    @Override
    public void visitModule(Module obj) {
        if (this.markLineNumber) {
            obj.initLineNoMap();
        }
        this.markLineNumber(obj);
        this.writer.attribute("xmlns", DEFAULT_NAME_SPACE);
        this.writer.attribute("version", "3.2.24");
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.writeSimpleProperties(obj);
    }

    protected void writeSimpleProperties(Module obj) {
        this.property(obj, "author");
        this.property(obj, "comments");
        this.property(obj, "createdBy");
        this.property(obj, "language");
        this.resourceKey(obj, "titleID", "title");
        this.resourceKey(obj, "descriptionID", "description");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeSimplePropertyList(obj, "includeResource");
        this.writeSimpleStructureList(obj, "includeScripts", "fileName");
        this.writeStructureList(obj, "scriptLibs");
        this.writeStructureList(obj, "propertyBindings");
    }

    @Override
    public void visitLayoutModule(Module obj) {
        super.visitLayoutModule(obj);
        this.property(obj, "subject");
        this.property(obj, "helpGuide");
        this.property(obj, "units");
        this.property(obj, "base");
    }

    protected void writeEmbeddedImages(Module obj) {
        List list = (List)obj.getLocalProperty(obj, "images");
        if (list != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "images");
            int i = 0;
            while (i < list.size()) {
                block8: {
                    EmbeddedImage image = (EmbeddedImage)list.get(i);
                    this.writer.startElement("structure");
                    this.markLineNumber(image);
                    this.property(image, "name");
                    this.property(image, "type");
                    this.property(image, "libReference");
                    try {
                        if (image.getLocalProperty(this.getModule(), (PropertyDefn)image.getDefn().getMember("data")) != null) {
                            byte[] data = Base64.encodeBase64(image.getData(this.getModule()), false);
                            String value = null;
                            if (data != null) {
                                value = new String(data, "8859_1");
                            }
                            if (value != null && value.length() < 80) {
                                this.writeEntry("property", "data", null, value.trim(), false);
                            } else {
                                this.writeBase64Text("property", "data", value);
                            }
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                this.writer.endElement();
                ++i;
            }
            this.writer.endElement();
        }
    }

    protected void writeTranslations(Module obj) {
        String[] resourceKeys = obj.getTranslationResourceKeys();
        if (resourceKeys != null && resourceKeys.length > 0) {
            this.writer.startElement("translations");
            int i = 0;
            while (i < resourceKeys.length) {
                this.writer.startElement("resource");
                this.writer.attribute("key", resourceKeys[i]);
                List<Translation> translations = obj.getTranslations(resourceKeys[i]);
                int j = 0;
                while (j < translations.size()) {
                    this.writer.startElement("translation");
                    Translation translation = translations.get(j);
                    this.writer.attribute("locale", translation.getLocale());
                    this.writer.text(translation.getText());
                    this.writer.endElement();
                    ++j;
                }
                this.writer.endElement();
                ++i;
            }
            this.writer.endElement();
        }
    }

    protected void writeCustomColors(Module obj) {
        List list = (List)obj.getLocalProperty(obj, "colorPalette");
        if (list != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "colorPalette");
            int i = 0;
            while (i < list.size()) {
                CustomColor color = (CustomColor)list.get(i);
                this.writer.startElement("structure");
                this.property(color, "name");
                this.property(color, "color");
                this.resourceKey(color, "displayNameID", "displayName");
                this.writer.endElement();
                ++i;
            }
            this.writer.endElement();
        }
    }

    @Override
    public void visitScriptDataSource(ScriptDataSource obj) {
        this.writer.startElement("script-data-source");
        super.visitScriptDataSource(obj);
        this.property(obj, "open");
        this.property(obj, "close");
        this.writer.endElement();
    }

    @Override
    public void visitOdaDataSource(OdaDataSource obj) {
        this.writer.startElement("oda-data-source");
        this.attribute(obj, "extensionID", "extensionID");
        super.visitOdaDataSource(obj);
        this.writeOdaDesignerState(obj, "designerState");
        List properties = (List)obj.getLocalProperty(this.getModule(), "privateDriverProperties");
        this.writeExtendedProperties(properties, "privateDriverProperties");
        this.property(obj, "externalConnectionName");
        this.writeOdaExtensionProperties(obj, "extensionID");
        this.writer.endElement();
    }

    private void writeOdaExtensionProperties(DesignElement obj, String extensionIDProp) {
        ExtensionElementDefn extDefn = null;
        if (obj instanceof OdaDataSource) {
            extDefn = ((OdaDataSource)obj).getExtDefn();
        } else if (obj instanceof OdaDataSet) {
            extDefn = ((OdaDataSet)obj).getExtDefn();
        }
        if (extDefn == null) {
            ODAProvider provider = null;
            if (obj instanceof OdaDataSource) {
                provider = ((OdaDataSource)obj).getProvider();
            }
            if (obj instanceof OdaDataSet) {
                provider = ((OdaDataSet)obj).getProvider();
            }
            if (provider instanceof OdaDummyProvider) {
                this.writeOdaDummyProperties(obj, provider);
            }
            return;
        }
        List<IElementPropertyDefn> list = extDefn.getLocalProperties();
        int i = 0;
        while (i < list.size()) {
            Object value;
            PropertyDefn prop = (PropertyDefn)((Object)list.get(i));
            if (!extensionIDProp.equals(prop.getName()) && (value = obj.getLocalProperty(this.getModule(), prop.getName())) != null) {
                boolean cdata = false;
                if (prop.getTypeCode() == 12 || prop.getTypeCode() == 18) {
                    cdata = true;
                }
                this.writeProperty(obj, ModelUtil.getTagByPropertyType(prop), prop.getName(), cdata);
            }
            ++i;
        }
    }

    private void writeOdaDummyProperties(DesignElement obj, ODAProvider provider) {
        assert (provider instanceof OdaDummyProvider);
        OdaDummyProvider dummyProvider = (OdaDummyProvider)provider;
        ContentTree tree = dummyProvider.getContentTree();
        this.writeContentTree(tree);
    }

    @Override
    public void visitScriptDataSet(ScriptDataSet obj) {
        this.writer.startElement("script-data-set");
        super.visitScriptDataSet(obj);
        this.property(obj, "dataSource");
        this.property(obj, "open");
        this.property(obj, "describe");
        this.property(obj, "fetch");
        this.property(obj, "close");
        this.writer.endElement();
    }

    @Override
    public void visitFreeForm(FreeForm obj) {
        this.writer.startElement("free-form");
        super.visitFreeForm(obj);
        this.writeContents(obj, 0, "report-items");
        this.writer.endElement();
    }

    @Override
    public void visitDataItem(DataItem obj) {
        this.boundColumnsMgr.dealData(obj, this.getModule());
        this.writer.startElement("data");
        super.visitDataItem(obj);
        this.property(obj, "resultSetColumn");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writeActions(obj, "action");
        this.writer.endElement();
    }

    @Override
    public void visitTextDataItem(TextDataItem obj) {
        this.boundColumnsMgr.dealTextData(obj, this.getModule());
        this.writer.startElement("text-data");
        super.visitTextDataItem(obj);
        this.property(obj, "valueExpr");
        this.property(obj, "contentType");
        this.property(obj, "hasExpression");
        this.property(obj, "jTidy");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writer.endElement();
    }

    @Override
    public void visitExtendedItem(ExtendedItem obj) {
        this.boundColumnsMgr.dealExtendedItem(obj, this.getModule());
        this.writer.startElement("extended-item");
        ExtensionElementDefn extDefn = obj.getExtDefn();
        if (extDefn == null) {
            this.attribute(obj, "extensionName", "extensionName");
            this.attribute(obj, "extensionVersion", "extensionVersion");
            super.visitExtendedItem(obj);
            this.resourceKey(obj, "altTextID", "altText");
            this.writeStructureList(obj, "filter");
            this.writeUserPropertyDefns(obj);
            ContentTree tree = obj.getExtensibilityProvider().getContentTree();
            this.writeContentTree(tree);
        } else {
            String extendsFrom;
            this.markLineNumber(obj);
            this.attribute(obj, "extensionName", "extensionName");
            this.attribute(obj, "extensionVersion", "extensionVersion");
            String name = (String)obj.getLocalProperty(this.getModule(), "name");
            if (!StringUtil.isBlank(name)) {
                this.writer.attribute("name", name);
            }
            if (!StringUtil.isBlank(extendsFrom = obj.getExtendsName())) {
                this.writer.attribute("extends", extendsFrom);
            }
            this.writer.attribute("id", Long.toString(obj.getID()));
            List<IElementPropertyDefn> props = extDefn.getProperties();
            boolean isCubeWrite = false;
            ElementPropertyDefn cubeProp = (ElementPropertyDefn)extDefn.getProperty("cube");
            if (cubeProp != null) {
                this.writeProperty(obj, ModelUtil.getTagByPropertyType(cubeProp), cubeProp.getName(), false);
                isCubeWrite = true;
            }
            int i = 0;
            while (i < props.size()) {
                ElementPropertyDefn prop = (ElementPropertyDefn)props.get(i);
                String propName = prop.getName();
                if (!("name".equals(propName) || "extensionName".equals(propName) || "extends".equals(propName) || "extensionVersion".equals(propName) || isCubeWrite && "cube".equals(propName))) {
                    switch (prop.getTypeCode()) {
                        case 20: {
                            this.writeSimplePropertyList(obj, propName);
                            break;
                        }
                        case 12: {
                            if (!obj.hasLocalPropertyValuesOnOwnModel()) break;
                            this.writeProperty(obj, ModelUtil.getTagByPropertyType(prop), propName, true);
                            break;
                        }
                        case 16: {
                            if (prop.isList()) {
                                this.writeStructureList(obj, propName);
                                break;
                            }
                            this.writeStructure(obj, propName);
                            break;
                        }
                        case 23: 
                        case 24: {
                            this.writeContents(obj, propName);
                            break;
                        }
                        default: {
                            this.writeProperty(obj, ModelUtil.getTagByPropertyType(prop), prop.getName(), false);
                        }
                    }
                }
                ++i;
            }
            this.writeUserPropertyDefns(obj);
            this.writeUserPropertyValues(obj);
            this.writeOverridenPropertyValues(obj);
        }
        this.writer.endElement();
    }

    @Override
    public void visitTextItem(TextItem obj) {
        this.boundColumnsMgr.dealText(obj, this.getModule());
        this.writer.startElement("text");
        super.visitTextItem(obj);
        this.property(obj, "contentType");
        this.resourceKeyCDATA(obj, "contentID", "content");
        this.property(obj, "hasExpression");
        this.property(obj, "jTidy");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writer.endElement();
    }

    @Override
    public void visitLabel(Label obj) {
        this.boundColumnsMgr.dealLabel(obj, this.getModule());
        this.writer.startElement("label");
        super.visitLabel(obj);
        this.resourceKey(obj, "textID", "text");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writeActions(obj, "action");
        this.writer.endElement();
    }

    @Override
    public void visitAutoText(AutoText obj) {
        this.writer.startElement("auto-text");
        super.visitAutoText(obj);
        this.property(obj, "type");
        this.property(obj, "pageVariable");
        this.writer.endElement();
    }

    @Override
    public void visitList(ListItem obj) {
        this.boundColumnsMgr.dealList(obj, this.getModule());
        this.writer.startElement("list");
        super.visitList(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, null);
        this.writeContents(obj, 2, "detail");
        this.writeContents(obj, 3, "footer");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.writer.endElement();
    }

    @Override
    public void visitListGroup(ListGroup obj) {
        this.writer.startElement("group");
        super.visitListGroup(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, "footer");
        this.writer.endElement();
    }

    @Override
    public void visitTable(TableItem obj) {
        this.boundColumnsMgr.dealTable(obj, this.getModule());
        this.writer.startElement("table");
        super.visitTable(obj);
        this.property(obj, "summary");
        this.property(obj, "isSummaryTable");
        this.resourceKey(obj, "captionID", "caption");
        this.writeColumns(obj, 4);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, null);
        this.writeContents(obj, 2, "detail");
        this.writeContents(obj, 3, "footer");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writer.endElement();
    }

    @Override
    public void visitTableGroup(TableGroup obj) {
        this.writer.startElement("group");
        super.visitTableGroup(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, "footer");
        this.writer.endElement();
    }

    @Override
    public void visitColumn(TableColumn obj) {
        this.writer.startElement("column");
        this.markLineNumber(obj);
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.attribute(obj, "viewAction", "viewAction");
        super.visitColumn(obj);
        this.visitSpecialProperty(obj, "width");
        this.property(obj, "repeat");
        this.property(obj, "suppressDuplicates");
        this.writeStructureList(obj, "visibility");
        this.writeStyle(obj);
        this.writer.endElement();
    }

    @Override
    public void visitRow(TableRow obj) {
        this.writer.startElement("row");
        this.markLineNumber(obj);
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.attribute(obj, "viewAction", "viewAction");
        super.visitRow(obj);
        this.visitSpecialProperty(obj, "height");
        this.property(obj, "bookmark");
        this.property(obj, "bookmarkDisplayName");
        this.property(obj, "suppressDuplicates");
        this.property(obj, "repeatable");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "newHandlerOnEachEvent");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStyle(obj);
        this.writeStructureList(obj, "visibility");
        this.writeContents(obj, 0, null);
        this.writer.endElement();
    }

    @Override
    public void visitCell(Cell obj) {
        this.writer.startElement("cell");
        this.markLineNumber(obj);
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.attribute(obj, "viewAction", "viewAction");
        super.visitCell(obj);
        this.property(obj, "column");
        this.property(obj, "colSpan");
        this.property(obj, "rowSpan");
        this.property(obj, "drop");
        this.visitSpecialProperty(obj, "height");
        this.visitSpecialProperty(obj, "width");
        this.property(obj, "diagonalNumber");
        this.property(obj, "diagonalStyle");
        this.property(obj, "diagonalThickness");
        this.property(obj, "diagonalColor");
        this.property(obj, "antidiagonalNumber");
        this.property(obj, "antidiagonalStyle");
        this.property(obj, "antidiagonalThickness");
        this.property(obj, "antidiagonalColor");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "newHandlerOnEachEvent");
        this.property(obj, "scope");
        this.property(obj, "bookmark");
        this.property(obj, "bookmarkDisplayName");
        this.property(obj, "headers");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "altText");
        this.property(obj, "altTextID");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStyle(obj);
        this.writeContents(obj, 0, null);
        this.writer.endElement();
    }

    @Override
    public void visitGrid(GridItem obj) {
        this.boundColumnsMgr.dealGrid(obj, this.getModule());
        this.writer.startElement("grid");
        super.visitGrid(obj);
        this.property(obj, "summary");
        this.resourceKey(obj, "captionID", "caption");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        this.writeColumns(obj, 0);
        this.writeContents(obj, 1, null);
        this.writer.endElement();
    }

    @Override
    public void visitLine(LineItem obj) {
        this.writer.startElement("line");
        super.visitLine(obj);
        this.property(obj, "orientation");
        this.writer.endElement();
    }

    @Override
    public void visitGraphicMasterPage(GraphicMasterPage obj) {
        this.writer.startElement("graphic-master-page");
        super.visitGraphicMasterPage(obj);
        this.writeContents(obj, 0, "contents");
        this.writer.endElement();
    }

    @Override
    public void visitSimpleMasterPage(SimpleMasterPage obj) {
        this.writer.startElement("simple-master-page");
        super.visitSimpleMasterPage(obj);
        this.property(obj, "showHeaderOnFirst");
        this.property(obj, "showFooterOnLast");
        this.property(obj, "floatingFooter");
        this.property(obj, "headerHeight");
        this.property(obj, "footerHeight");
        this.writeContents(obj, 0, "page-header");
        this.writeContents(obj, 1, "page-footer");
        this.writer.endElement();
    }

    @Override
    public void visitParameterGroup(ParameterGroup obj) {
        this.writer.startElement("parameter-group");
        super.visitParameterGroup(obj);
        this.property(obj, "startExpanded");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.resourceKey(obj, "promptTextID", "promptText");
        this.writeContents(obj, 0, "parameters");
        this.writeOverridenPropertyValues(obj);
        this.writer.endElement();
    }

    @Override
    public void visitCascadingParameterGroup(CascadingParameterGroup obj) {
        this.writer.startElement("cascading-parameter-group");
        super.visitParameterGroup(obj);
        this.property(obj, "startExpanded");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.resourceKey(obj, "promptTextID", "promptText");
        this.property(obj, "dataSet");
        this.visitCascadingParameterGroupExtraProperty(obj);
        this.property(obj, "dataSetMode");
        this.writeContents(obj, 0, "parameters");
        this.writeOverridenPropertyValues(obj);
        this.writer.endElement();
    }

    protected void visitCascadingParameterGroupExtraProperty(CascadingParameterGroup obj) {
    }

    @Override
    public void visitScalarParameter(ScalarParameter obj) {
        this.boundColumnsMgr.dealScalarParameter(obj, this.getModule());
        this.writer.startElement("scalar-parameter");
        super.visitScalarParameter(obj);
        this.property(obj, "paramType");
        this.property(obj, "concealValue");
        this.property(obj, "controlType");
        this.property(obj, "alignment");
        this.property(obj, "mustMatch");
        this.property(obj, "fixedOrder");
        this.property(obj, "autoSuggestThreshold");
        this.property(obj, "getDefaultValueList");
        this.property(obj, "getSelectionValueList");
        this.writeStructure(obj, "format");
        this.writeStructureList(obj, "boundDataColumns");
        this.writer.endElement();
    }

    @Override
    public void visitAbstractScalarParameter(AbstractScalarParameter obj) {
        super.visitAbstractScalarParameter(obj);
        this.property(obj, "listLimit");
        this.property(obj, "valueType");
        this.property(obj, "isRequired");
        this.property(obj, "dataSetName");
        this.property(obj, "valueExpr");
        this.property(obj, "labelExpr");
        this.property(obj, "sortBy");
        this.property(obj, "sortByColumn");
        this.property(obj, "sortDirection");
        this.property(obj, "dataType");
        this.property(obj, "distinct");
        this.writeSimplePropertyList(obj, "defaultValue");
        this.writeStructureList(obj, "selectionList");
    }

    @Override
    public void visitDynamicFilterParameter(DynamicFilterParameter obj) {
        this.writer.startElement("dynamic-filter-parameter");
        super.visitDynamicFilterParameter(obj);
        this.property(obj, "column");
        this.property(obj, "displayType");
        this.property(obj, "nativeDataType");
        this.property(obj, "controlType");
        this.writeSimplePropertyList(obj, "filterOperator");
        this.writer.endElement();
    }

    @Override
    public void visitTemplateDataSet(TemplateDataSet obj) {
        this.writer.startElement("template-data-set");
        super.visitTemplateDataSet(obj);
        this.writer.endElement();
    }

    @Override
    public void visitTemplateElement(TemplateElement obj) {
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.resourceKey(obj, "displayNameID", "displayName");
        this.property(obj, "refTemplateParameter");
    }

    @Override
    public void visitTemplateParameterDefinition(TemplateParameterDefinition obj) {
        this.writer.startElement("template-parameter-definition");
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.property(obj, "allowedType");
        this.resourceKey(obj, "descriptionID", "description");
        this.writeContents(obj, 0, "default");
        this.writer.endElement();
    }

    @Override
    public void visitTemplateReportItem(TemplateReportItem obj) {
        this.boundColumnsMgr.dealTemplateReportItem(obj, this.getModule());
        this.writer.startElement("template-report-item");
        super.visitTemplateReportItem(obj);
        this.writeStructureList(obj, "visibility");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writer.endElement();
    }

    @Override
    public void visitStyle(Style obj) {
        this.writer.startElement("style");
        super.visitStyle(obj);
        this.writeStyleProps(obj);
        this.writer.endElement();
    }

    private void writeStyleProps(DesignElement obj) {
        StyleRule rule;
        int i;
        this.property(obj, "backgroundAttachment");
        this.property(obj, "backgroundColor");
        this.property(obj, "backgroundImage");
        this.property(obj, "backgroundImageType");
        this.property(obj, "backgroundPositionX");
        this.property(obj, "backgroundPositionY");
        this.property(obj, "backgroundRepeat");
        this.property(obj, "backgroundSizeHeight");
        this.property(obj, "backgroundSizeWidth");
        this.property(obj, "fontFamily");
        this.property(obj, "fontSize");
        this.property(obj, "fontWeight");
        this.property(obj, "fontStyle");
        this.property(obj, "fontVariant");
        this.property(obj, "color");
        this.property(obj, "textLineThrough");
        this.property(obj, "textOverline");
        this.property(obj, "textUnderline");
        this.property(obj, "borderBottomColor");
        this.property(obj, "borderBottomStyle");
        this.property(obj, "borderBottomWidth");
        this.property(obj, "borderLeftColor");
        this.property(obj, "borderLeftStyle");
        this.property(obj, "borderLeftWidth");
        this.property(obj, "borderRightColor");
        this.property(obj, "borderRightStyle");
        this.property(obj, "borderRightWidth");
        this.property(obj, "borderTopColor");
        this.property(obj, "borderTopStyle");
        this.property(obj, "borderTopWidth");
        this.property(obj, "marginTop");
        this.property(obj, "marginLeft");
        this.property(obj, "marginBottom");
        this.property(obj, "marginRight");
        this.property(obj, "paddingTop");
        this.property(obj, "paddingLeft");
        this.property(obj, "paddingBottom");
        this.property(obj, "paddingRight");
        this.property(obj, "numberAlign");
        this.writeStructure(obj, "dateTimeFormat");
        this.writeStructure(obj, "dateFormat");
        this.writeStructure(obj, "timeFormat");
        this.writeStructure(obj, "numberFormat");
        this.writeStructure(obj, "stringFormat");
        this.property(obj, "textAlign");
        this.property(obj, "textIndent");
        this.property(obj, "letterSpacing");
        this.property(obj, "lineHeight");
        this.property(obj, "orphans");
        this.property(obj, "textTransform");
        this.property(obj, "verticalAlign");
        this.property(obj, "whiteSpace");
        this.property(obj, "widows");
        this.property(obj, "wordSpacing");
        this.property(obj, "display");
        this.property(obj, "masterPage");
        this.property(obj, "pageBreakAfter");
        this.property(obj, "pageBreakBefore");
        this.property(obj, "pageBreakInside");
        this.property(obj, "showIfBlank");
        this.property(obj, "canShrink");
        this.property(obj, "bidiTextDirection");
        this.property(obj, "overflow");
        this.property(obj, "height");
        this.property(obj, "width");
        ArrayList list = (ArrayList)obj.getLocalProperty(this.getModule(), "highlightRules");
        if (list != null) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "highlightRules");
            i = 0;
            while (i < list.size()) {
                rule = (HighlightRule)list.get(i);
                this.writer.startElement("structure");
                this.property(rule, "isDesignTime");
                this.property(rule, "operator");
                this.property(rule, "backgroundColor");
                this.property(rule, "borderTopStyle");
                this.property(rule, "borderTopWidth");
                this.property(rule, "borderTopColor");
                this.property(rule, "borderLeftStyle");
                this.property(rule, "borderLeftWidth");
                this.property(rule, "borderLeftColor");
                this.property(rule, "borderBottomStyle");
                this.property(rule, "borderBottomWidth");
                this.property(rule, "borderBottomColor");
                this.property(rule, "borderRightStyle");
                this.property(rule, "borderRightWidth");
                this.property(rule, "borderRightColor");
                this.property(rule, "fontFamily");
                this.property(rule, "fontSize");
                this.property(rule, "fontStyle");
                this.property(rule, "fontWeight");
                this.property(rule, "fontVariant");
                this.property(rule, "color");
                this.property(rule, "textUnderline");
                this.property(rule, "textOverline");
                this.property(rule, "textLineThrough");
                this.property(rule, "textAlign");
                this.property(rule, "textTransform");
                this.property(rule, "textIndent");
                this.property(rule, "bidiTextDirection");
                this.property(rule, "numberAlign");
                this.writeStructure(rule, "dateTimeFormat");
                this.writeStructure(rule, "numberFormat");
                this.writeStructure(rule, "stringFormat");
                this.property(rule, "testExpr");
                this.writeSimplePropertyList(rule, "value1");
                this.property(rule, "value2");
                this.property(rule, "style");
                this.property(rule, "lineHeight");
                this.writer.endElement();
                ++i;
            }
            this.writer.endElement();
        }
        if ((list = (ArrayList)obj.getLocalProperty(this.getModule(), "mapRules")) != null) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "mapRules");
            i = 0;
            while (i < list.size()) {
                rule = (MapRule)list.get(i);
                this.writer.startElement("structure");
                this.property(rule, "isDesignTime");
                this.property(rule, "testExpr");
                this.property(rule, "operator");
                this.writeSimplePropertyList(rule, "value1");
                this.property(rule, "value2");
                this.resourceKey(rule, "displayID", "display");
                this.writer.endElement();
                ++i;
            }
            this.writer.endElement();
        }
    }

    private void writeContents(ContainerContext containerInfor, String tag) {
        ElementPropertyDefn propDefn;
        assert (containerInfor != null);
        List<DesignElement> list = containerInfor.getContents(this.getModule());
        if (list.isEmpty()) {
            return;
        }
        DesignElement tmpElement = containerInfor.getElement();
        if (tmpElement.getExtendsElement() != null && ((propDefn = tmpElement.getPropertyDefn(containerInfor.getPropertyName())) == null || propDefn.getTypeCode() != 24)) {
            return;
        }
        if (tag != null) {
            this.writer.conditionalStartElement(tag);
        }
        this.writer.attribute("name", containerInfor.getPropertyName());
        if (!containerInfor.isROMSlot()) {
            this.markLineNumber(containerInfor);
        }
        this.writeChildren(list);
        if (tag != null) {
            this.writer.endElement();
        }
    }

    protected void writeChildren(List<DesignElement> contents) {
        Iterator<DesignElement> iter = contents.iterator();
        while (iter.hasNext()) {
            iter.next().apply(this);
        }
    }

    protected void writeContents(DesignElement obj, int slot, String tag) {
        this.markLineNumber(new ContainerContext(obj, slot));
        this.writeContents(new ContainerContext(obj, slot), tag);
    }

    protected void writeContents(DesignElement obj, String propName) {
        this.writeContents(new ContainerContext(obj, propName), "property");
    }

    protected void writeArrangedContents(DesignElement obj, int slot, String tag) {
        List<DesignElement> list = obj.getSlot(slot).getContents();
        if (list.isEmpty()) {
            return;
        }
        LinkedList<DesignElement> newList = new LinkedList<DesignElement>();
        for (DesignElement element : list) {
            int index;
            DesignElement parent = element.getExtendsElement();
            if (!newList.contains(element)) {
                newList.add(element);
            }
            if (parent == null || !list.contains(parent)) continue;
            if (!newList.contains(parent)) {
                index = newList.indexOf(element);
                newList.add(index, parent);
                continue;
            }
            if (newList.indexOf(element) >= newList.indexOf(parent)) continue;
            newList.remove(parent);
            index = newList.indexOf(element);
            newList.add(index, parent);
        }
        if (tag != null) {
            this.writer.conditionalStartElement(tag);
        }
        Iterator<DesignElement> iter = newList.iterator();
        while (iter.hasNext()) {
            iter.next().apply(this);
        }
        if (tag != null) {
            this.writer.endElement();
        }
    }

    @Override
    public void visitRectangle(RectangleItem obj) {
        this.writer.startElement("rectangle");
        super.visitRectangle(obj);
        this.writer.endElement();
    }

    @Override
    public void visitImage(ImageItem obj) {
        this.boundColumnsMgr.dealImage(obj, this.getModule());
        this.writer.startElement("image");
        super.visitImage(obj);
        this.property(obj, "size");
        this.property(obj, "scale");
        this.property(obj, "source");
        this.property(obj, "fitToContainer");
        this.property(obj, "proportionalScale");
        this.property(obj, "tagType");
        this.property(obj, "language");
        this.property(obj, "order");
        String source = (String)obj.getLocalProperty(this.getModule(), "source");
        if ("url".equalsIgnoreCase(source) || "file".equalsIgnoreCase(source)) {
            this.property(obj, "uri");
        } else if ("embed".equalsIgnoreCase(source)) {
            this.property(obj, "imageName");
        } else if ("expr".equalsIgnoreCase(source)) {
            this.property(obj, "typeExpr");
            this.property(obj, "valueExpr");
        }
        this.resourceKey(obj, "helpTextID", "helpText");
        this.writeActions(obj, "action");
        this.writer.endElement();
    }

    protected void writeActions(DesignElement obj, String propName) {
        List actions = (List)obj.getLocalProperty(this.getModule(), propName);
        if (actions == null || actions.isEmpty()) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", propName);
        int i = 0;
        while (i < actions.size()) {
            Action action = (Action)actions.get(i);
            this.writeAction(action);
            ++i;
        }
        this.writer.endElement();
    }

    protected void writeAction(Action action) {
        String linkType = (String)action.getProperty(this.getModule(), "linkType");
        this.writer.startElement("structure");
        this.property(action, "formatType");
        this.property(action, "linkType");
        this.property(action, "toolTip");
        if ("hyperlink".equalsIgnoreCase(linkType)) {
            this.property(action, "uri");
            this.property(action, "targetWindow");
            this.property(action, "targetFileType");
        } else if ("bookmark-link".equalsIgnoreCase(linkType)) {
            this.property(action, "targetBookmark");
            this.property(action, "targetBookmarkType");
        } else if ("drill-through".equalsIgnoreCase(linkType)) {
            this.property(action, "reportName");
            this.property(action, "targetBookmark");
            this.property(action, "targetBookmarkType");
            this.property(action, "targetWindow");
            this.property(action, "targetFileType");
            this.writeStructureList(action, "paramBindings");
            this.writeStructureList(action, "search");
        } else assert (false);
        this.writer.endElement();
    }

    @Override
    public void visitDesignElement(DesignElement obj) {
        super.visitDesignElement(obj);
        this.markLineNumber(obj);
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.attribute(obj, "extends", "extends");
        this.attribute(obj, "viewAction", "viewAction");
        this.property(obj, "comments");
        this.property(obj, "customXml");
        this.resourceKey(obj, "displayNameID", "displayName");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "newHandlerOnEachEvent");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStructureList(obj, "propertyMasks");
    }

    protected void markLineNumber(Object obj) {
        if (this.markLineNumber) {
            Object key = obj;
            Module module = this.getModule();
            if (module != null) {
                module.addLineNo(key, this.writer.getLineCounter());
            }
        }
    }

    @Override
    public void visitDataSet(DataSet obj) {
        super.visitDataSet(obj);
        this.property(obj, "ACLExpression");
        this.property(obj, "rowACLExpression");
        this.property(obj, "isVisible");
        this.property(obj, "locale");
        this.property(obj, "nullsOrdering");
        this.writeStructureList(obj, "resultSetHints");
        this.writeStructureList(obj, "computedColumns");
        this.writeStructureList(obj, "columnHints");
        this.writeStructureList(obj, "filter");
        this.writeStructureList(obj, "parameters");
        this.writeStructureList(obj, "sortHints");
        CachedMetaData metadata = (CachedMetaData)obj.getLocalProperty(this.getModule(), "cachedMetaData");
        if (metadata != null) {
            this.writer.startElement("structure");
            this.writer.attribute("name", "cachedMetaData");
            this.writeStructureList(metadata, "parameters");
            this.writeStructureList(metadata, "resultSet");
            this.writer.endElement();
        }
        this.property(obj, "rowFetchLimit");
        this.property(obj, "needsCache");
    }

    @Override
    public void visitSimpleDataSet(SimpleDataSet obj) {
        super.visitSimpleDataSet(obj);
        this.property(obj, "beforeOpen");
        this.property(obj, "beforeClose");
        this.property(obj, "onFetch");
        this.property(obj, "afterOpen");
        this.property(obj, "afterClose");
        this.property(obj, "refTemplateParameter");
        this.property(obj, "dataSetRowLimit");
        this.writeStructureList(obj, "paramBindings");
    }

    @Override
    public void visitDataSource(DataSource obj) {
        super.visitDataSource(obj);
        this.property(obj, "beforeOpen");
        this.property(obj, "beforeClose");
        this.property(obj, "afterOpen");
        this.property(obj, "afterClose");
    }

    @Override
    public void visitParameter(Parameter obj) {
        super.visitParameter(obj);
        this.property(obj, "hidden");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.property(obj, "validate");
        this.resourceKey(obj, "promptTextID", "promptText");
    }

    @Override
    public void visitReportItem(ReportItem obj) {
        super.visitReportItem(obj);
        this.property(obj, "x");
        this.property(obj, "y");
        this.property(obj, "zIndex");
        this.visitSpecialProperty(obj, "height");
        this.visitSpecialProperty(obj, "width");
        this.property(obj, "altText");
        this.property(obj, "altTextID");
        this.property(obj, "dataSet");
        this.property(obj, "cube");
        this.property(obj, "refTemplateParameter");
        this.property(obj, "dataBindingRef");
        this.property(obj, "theme");
        this.writeStructureList(obj, "visibility");
        this.writeStructureList(obj, "paramBindings");
        this.writeStructureList(obj, "boundDataColumns");
        this.property(obj, "bookmark");
        this.property(obj, "bookmarkDisplayName");
        this.writeStructure(obj, "toc");
        this.writeContents(obj, "multiViews");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.property(obj, "onPageBreak");
        this.property(obj, "ACLExpression");
        this.property(obj, "cascadeACL");
        this.property(obj, "allowExport");
        this.property(obj, "pushDown");
        this.writeOverridenPropertyValues(obj);
    }

    @Override
    public void visitMasterPage(MasterPage obj) {
        super.visitMasterPage(obj);
        this.property(obj, "type");
        String type = (String)obj.getLocalProperty(this.getModule(), "type");
        if ("custom".equalsIgnoreCase(type)) {
            this.visitSpecialProperty(obj, "height");
            this.visitSpecialProperty(obj, "width");
        }
        this.property(obj, "orientation");
        this.property(obj, "topMargin");
        this.property(obj, "leftMargin");
        this.property(obj, "bottomMargin");
        this.property(obj, "rightMargin");
        this.property(obj, "columns");
        this.property(obj, "columnSpacing");
        this.writeStyle(obj);
        this.writeOverridenPropertyValues(obj);
        this.property(obj, "onPageStart");
        this.property(obj, "onPageEnd");
    }

    @Override
    public void visitStyledElement(StyledElement obj) {
        super.visitStyledElement(obj);
        this.writeStyle(obj);
    }

    protected void writeStyle(StyledElement obj) {
        this.property(obj, "style");
        this.writeStyleProps(obj);
    }

    @Override
    public void visitListing(ListingElement obj) {
        super.visitListing(obj);
        this.property(obj, "repeatHeader");
        this.property(obj, "pageBreakInterval");
        this.property(obj, "sortByGroups");
        this.writeStructureList(obj, "sort");
        this.writeStructureList(obj, "filter");
    }

    @Override
    public void visitGroup(GroupElement obj) {
        this.markLineNumber(obj);
        this.writer.attribute("id", Long.toString(obj.getID()));
        this.attribute(obj, "viewAction", "viewAction");
        super.visitGroup(obj);
        this.property(obj, "groupName");
        this.property(obj, "intervalBase");
        this.property(obj, "interval");
        this.property(obj, "intervalRange");
        this.property(obj, "sortDirection");
        this.property(obj, "sortType");
        this.property(obj, "keyExpr");
        this.property(obj, "bookmark");
        this.property(obj, "bookmarkDisplayName");
        this.writeStructure(obj, "toc");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "newHandlerOnEachEvent");
        this.property(obj, "onPrepare");
        this.property(obj, "onPageBreak");
        this.property(obj, "repeatHeader");
        this.property(obj, "hideDetail");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.property(obj, "pageBreakAfter");
        this.property(obj, "pageBreakBefore");
        this.property(obj, "pageBreakInside");
        this.property(obj, "ACLExpression");
        this.property(obj, "cascadeACL");
        this.property(obj, "showDetailFilter");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStructureList(obj, "sort");
        this.writeStructureList(obj, "filter");
    }

    @Override
    public void visitOdaDataSet(OdaDataSet obj) {
        this.writer.startElement("oda-data-set");
        this.attribute(obj, "extensionID", "extensionID");
        super.visitOdaDataSet(obj);
        this.property(obj, "dataSource");
        this.writeStructureList(obj, "resultSet");
        if ((String)obj.getLocalProperty(this.getModule(), "queryText") != null) {
            this.property(obj, "queryText");
        }
        this.property(obj, "resultSetName");
        this.property(obj, "resultSetNumber");
        this.writeOdaDesignerState(obj, "designerState");
        this.property(obj, "designerValues");
        List properties = (List)obj.getLocalProperty(this.getModule(), "privateDriverProperties");
        this.writeExtendedProperties(properties, "privateDriverProperties");
        this.writeOdaExtensionProperties(obj, "extensionID");
        this.writer.endElement();
    }

    private void writeColumns(DesignElement obj, int slot) {
        assert (obj instanceof GridItem || obj instanceof TableItem);
        assert (slot == 0 || slot == 4);
        List<DesignElement> list = obj.getSlot(slot).getContents();
        if (list.isEmpty()) {
            return;
        }
        this.writeContents(obj, slot, null);
    }

    protected void writeOverridenPropertyValues(DesignElement obj) {
        if (obj.getExtendsElement() == null) {
            return;
        }
        this.writer.conditionalStartElement("overridden-values");
        ContentIterator iter = new ContentIterator(this.getModule(), obj);
        while (iter.hasNext()) {
            DesignElement virtualElement = (DesignElement)iter.next();
            this.writer.conditionalStartElement("ref-entry");
            long baseId = virtualElement.getBaseId();
            this.writer.attribute("baseId", Long.toString(baseId));
            this.writer.attribute("name", virtualElement.getName());
            this.writer.attribute("id", Long.toString(virtualElement.getID()));
            if (!virtualElement.hasLocalPropertyValues() && virtualElement.getStyle() == null) {
                this.writer.endElement();
                continue;
            }
            assert (virtualElement.getExtendsElement() == null);
            List<IElementPropertyDefn> propDefns = null;
            propDefns = virtualElement instanceof ExtendedItem ? ((ExtendedItem)virtualElement).getExtDefn().getProperties() : virtualElement.getPropertyDefns();
            int i = 0;
            while (i < propDefns.size()) {
                PropertyDefn propDefn = (PropertyDefn)((Object)propDefns.get(i));
                if (!("name".equalsIgnoreCase(propDefn.getName()) || propDefn.getTypeCode() == 23 || virtualElement instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName()))) {
                    boolean cdata = false;
                    if (propDefn.getTypeCode() == 18 || propDefn.getTypeCode() == 12) {
                        cdata = true;
                    }
                    if (propDefn.getTypeCode() == 16) {
                        if (propDefn.isList()) {
                            this.writeStructureList(virtualElement, propDefn.getName());
                        } else {
                            this.writeStructure(virtualElement, propDefn.getName());
                        }
                    } else if (propDefn.getTypeCode() == 20) {
                        this.writeSimplePropertyList(virtualElement, propDefn.getName());
                    } else if (propDefn.getTypeCode() == 24) {
                        this.writeContents(virtualElement, propDefn.getName());
                    } else {
                        this.writeProperty(virtualElement, ModelUtil.getTagByPropertyType(propDefn), propDefn.getName(), cdata);
                    }
                }
                ++i;
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    @Override
    public void visitJointDataSet(JointDataSet obj) {
        this.writer.startElement("joint-data-set");
        super.visitJointDataSet(obj);
        this.writeStructureList(obj, "resultSet");
        this.writeSimplePropertyList(obj, "dataSets");
        this.writeStructureList(obj, "joinConditions");
        this.writer.endElement();
    }

    @Override
    public void visitDerivedDataSet(DerivedDataSet obj) {
        this.writer.startElement("derived-data-set");
        this.attribute(obj, "extensionID", "extensionID");
        super.visitDerivedDataSet(obj);
        this.writeSimplePropertyList(obj, "inputDataSets");
        this.property(obj, "queryText");
        this.writer.endElement();
    }

    private void writeOdaDesignerState(DesignElement obj, String propName) {
        block7: {
            OdaDesignerState designerState = (OdaDesignerState)obj.getLocalProperty(this.getModule(), propName);
            if (designerState == null) {
                return;
            }
            this.writer.startElement("structure");
            this.writer.attribute("name", "designerState");
            this.property(designerState, "version");
            this.property(designerState, "stateContentAsString");
            try {
                if (designerState.getContentAsBlob() != null) {
                    byte[] data = Base64.encodeBase64(designerState.getContentAsBlob(), false);
                    String value = null;
                    if (data != null) {
                        value = new String(data, "8859_1");
                    }
                    if (value != null && value.length() < 80) {
                        this.writeEntry("property", "stateContentAsBlob", null, value.trim(), false);
                    } else {
                        this.writeBase64Text("property", "stateContentAsBlob", value);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        this.writer.endElement();
    }

    protected void writeContentTree(ContentTree tree) {
        if (tree == null || tree.isEmpty()) {
            return;
        }
        List<ContentNode> children = tree.getChildren();
        int i = 0;
        while (i < children.size()) {
            ContentNode node = children.get(i);
            this.writeContentNode(node);
            ++i;
        }
    }

    private void writeContentNode(ContentNode node) {
        String tagName = node.getName();
        boolean isCdata = node.isCDATASection();
        this.writer.startElement(tagName);
        Map<String, Object> attributes = node.getAttributes();
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            String key = entry.getKey();
            String attr = (String)entry.getValue();
            this.writer.attribute(key, attr);
        }
        String value = node.getValue();
        List<ContentNode> children = node.getChildren();
        assert (StringUtil.isBlank(value) || children.isEmpty());
        if (!StringUtil.isBlank(value)) {
            if (isCdata) {
                this.writer.textCDATA(value);
            } else {
                this.writer.text(value);
            }
        } else {
            int i = 0;
            while (i < children.size()) {
                ContentNode child = children.get(i);
                this.writeContentNode(child);
                ++i;
            }
        }
        this.writer.endElement();
    }

    @Override
    public void visitCube(Cube obj) {
        super.visitCube(obj);
        this.property(obj, "ACLExpression");
        this.writeStructureList(obj, "filter");
        this.writeOverridenPropertyValues(obj);
    }

    @Override
    public void visitDimension(Dimension obj) {
        super.visitDimension(obj);
        this.property(obj, "isTimeType");
        this.property(obj, "defaultHierarchy");
        this.property(obj, "ACLExpression");
        this.writeContents(obj, "hierarchies");
        this.writeOverridenPropertyValues(obj);
    }

    @Override
    public void visitHierarchy(Hierarchy obj) {
        super.visitHierarchy(obj);
        this.writeStructureList(obj, "filter");
        this.writeContents(obj, "levels");
        this.writeOverridenPropertyValues(obj);
    }

    @Override
    public void visitLevel(Level obj) {
        super.visitLevel(obj);
        this.property(obj, "dataType");
        this.property(obj, "dateTimeLevelType");
        this.property(obj, "dateTimeFormat");
        this.property(obj, "intervalBase");
        this.property(obj, "interval");
        this.property(obj, "intervalRange");
        this.property(obj, "levelType");
        this.property(obj, "defaultValue");
        this.property(obj, "ACLExpression");
        this.property(obj, "memberACLExpression");
        this.property(obj, "alignment");
        this.writeStructureList(obj, "staticValues");
        this.writeStructureList(obj, "attributes");
        this.writeActions(obj, "action");
        this.writeStructure(obj, "format");
    }

    @Override
    public void visitMeasureGroup(MeasureGroup obj) {
        super.visitMeasureGroup(obj);
        this.writeContents(obj, "measures");
        this.writeOverridenPropertyValues(obj);
    }

    @Override
    public void visitMeasure(Measure obj) {
        super.visitMeasure(obj);
        this.property(obj, "function");
        this.property(obj, "isCalculated");
        this.property(obj, "measureExpression");
        this.property(obj, "dataType");
        this.property(obj, "ACLExpression");
        this.property(obj, "alignment");
        this.property(obj, "isVisible");
        this.writeActions(obj, "action");
        this.writeStructure(obj, "format");
    }

    @Override
    public void visitTabularCube(TabularCube obj) {
        this.writer.startElement("tabular-cube");
        super.visitTabularCube(obj);
        this.writeContents(obj, "dimensions");
        this.writeContents(obj, "measureGroups");
        this.property(obj, "dataSet");
        this.property(obj, "autoKey");
        this.writeStructureList(obj, "dimensionConditions");
        this.writer.endElement();
    }

    @Override
    public void visitTabularDimension(TabularDimension obj) {
        this.writer.startElement("tabular-dimension");
        if (obj.getProperty(this.getModule(), "internalDimensionRef") == null) {
            super.visitTabularDimension(obj);
        } else {
            super.visitDimension(obj);
            this.property(obj, "internalDimensionRef");
        }
        this.writer.endElement();
    }

    @Override
    public void visitTabularHierarchy(TabularHierarchy obj) {
        this.writer.startElement("tabular-hierarchy");
        super.visitTabularHierarchy(obj);
        this.property(obj, "dataSet");
        this.writeSimplePropertyList(obj, "primaryKeys");
        this.writer.endElement();
    }

    @Override
    public void visitTabularLevel(TabularLevel obj) {
        this.writer.startElement("tabular-level");
        super.visitTabularLevel(obj);
        this.property(obj, "columnName");
        this.property(obj, "displayColumnName");
        this.writer.endElement();
    }

    @Override
    public void visitTabularMeasure(TabularMeasure obj) {
        this.writer.startElement("tabular-measure");
        super.visitTabularMeasure(obj);
        this.writer.endElement();
    }

    @Override
    public void visitTabularMeasureGroup(TabularMeasureGroup obj) {
        this.writer.startElement("tabular-measure-group");
        super.visitTabularMeasureGroup(obj);
        this.writer.endElement();
    }

    @Override
    public void visitOdaCube(OdaCube obj) {
        this.writer.startElement("oda-cube");
        super.visitOdaCube(obj);
        this.writeContents(obj, "dimensions");
        this.writeContents(obj, "measureGroups");
        this.property(obj, "nativeName");
        this.writer.endElement();
    }

    @Override
    public void visitOdaDimension(OdaDimension obj) {
        this.writer.startElement("oda-dimension");
        super.visitOdaDimension(obj);
        this.property(obj, "nativeName");
        this.writer.endElement();
    }

    @Override
    public void visitOdaHierarchy(OdaHierarchy obj) {
        this.writer.startElement("oda-hierarchy");
        super.visitOdaHierarchy(obj);
        this.property(obj, "nativeName");
        this.writer.endElement();
    }

    @Override
    public void visitOdaLevel(OdaLevel obj) {
        this.writer.startElement("oda-level");
        super.visitOdaLevel(obj);
        this.writer.endElement();
    }

    @Override
    public void visitOdaMeasure(OdaMeasure obj) {
        this.writer.startElement("oda-measure");
        super.visitOdaMeasure(obj);
        this.writer.endElement();
    }

    @Override
    public void visitOdaMeasureGroup(OdaMeasureGroup obj) {
        this.writer.startElement("oda-measure-group");
        super.visitOdaMeasureGroup(obj);
        this.writer.endElement();
    }

    @Override
    public void visitFilterConditionElement(FilterConditionElement obj) {
        this.writer.startElement("filter-condition-element");
        this.markLineNumber(obj);
        super.visitFilterConditionElement(obj);
        this.property(obj, "isOptional");
        this.property(obj, "expr");
        this.property(obj, "operator");
        this.writeSimplePropertyList(obj, "value1");
        this.property(obj, "value2");
        this.property(obj, "filterTarget");
        this.property(obj, "extensionName");
        this.property(obj, "extensionExprId");
        this.property(obj, "pushDown");
        this.property(obj, "dynamicFilterParameter");
        this.property(obj, "type");
        this.property(obj, "updateAggregation");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeContents(obj, "member");
        this.writer.endElement();
    }

    @Override
    public void visitMemberValue(MemberValue obj) {
        this.writer.startElement("member-value");
        this.markLineNumber(obj);
        super.visitMemberValue(obj);
        this.property(obj, "value");
        this.property(obj, "level");
        this.writeStructureList(obj, "filter");
        this.writeContents(obj, "memberValues");
        this.writer.endElement();
    }

    @Override
    public void visitSortElement(SortElement obj) {
        this.writer.startElement("sort-element");
        this.markLineNumber(obj);
        super.visitSortElement(obj);
        this.property(obj, "key");
        this.property(obj, "direction");
        this.property(obj, "strength");
        this.property(obj, "locale");
        this.writeContents(obj, "member");
        this.writer.endElement();
    }

    @Override
    public void visitMultiView(MultiViews obj) {
        this.writer.startElement("multi-views");
        this.markLineNumber(obj);
        super.visitMultiView(obj);
        this.property(obj, "index");
        this.writeContents(obj, "views");
        this.writer.endElement();
    }

    @Override
    public void visitVariableElement(VariableElement obj) {
        this.writer.startElement("variable-element");
        this.markLineNumber(obj);
        this.attribute(obj, "name", "name");
        super.visitVariableElement(obj);
        this.property(obj, "variableName");
        this.property(obj, "value");
        this.property(obj, "type");
        this.writer.endElement();
    }

    @Override
    public void visitDataGroup(DataGroup obj) {
        this.writer.startElement("data-group");
        this.markLineNumber(obj);
        super.visitDataGroup(obj);
        this.property(obj, "groupName");
        this.property(obj, "keyExpr");
        this.property(obj, "intervalBase");
        this.property(obj, "interval");
        this.property(obj, "intervalRange");
        this.property(obj, "sortDirection");
        this.property(obj, "sortType");
        this.writeStructureList(obj, "sort");
        this.writeStructureList(obj, "filter");
        this.writer.endElement();
    }

    protected void initBoundColumnsMgr() {
        if (this.boundColumnsMgr == null) {
            this.boundColumnsMgr = new BoundColumnsWriterMgr(this.getModule().getVersionManager().getVersion());
        }
    }

    @Override
    public void visitReportItemTheme(ReportItemTheme obj) {
        this.writer.startElement("report-item-theme");
        this.attribute(obj, "type", "type");
        super.visitReportItemTheme(obj);
        this.property(obj, "customValues");
        this.writeContents(obj, 0, "styles");
        this.writer.endElement();
    }

    @Override
    public void visitTheme(Theme obj) {
        this.writer.startElement("theme");
        super.visitTheme(obj);
        this.writeContents(obj, 0, "styles");
        this.writer.endElement();
    }

    @Override
    public void visitAbstractTheme(AbstractTheme obj) {
        super.visitAbstractTheme(obj);
        this.writeStructureList(obj, "cssStyleSheets");
    }

    private void visitSpecialProperty(StyledElement element, String propertyName) {
        ElementPropertyDefn propDefn = element.getPropertyDefn(propertyName);
        if (propDefn != null && "Style".equals(propDefn.definedBy().getName()) && ("height".equals(propDefn.getName()) || "width".equals(propDefn.getName()))) {
            return;
        }
        this.property(element, propertyName);
    }
}

