/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.report.model.adapter.oda.impl.AdapterUtil;
import org.eclipse.birt.report.model.adapter.oda.impl.ROMResultColumnHelper;
import org.eclipse.birt.report.model.api.ColumnHintHandle;
import org.eclipse.birt.report.model.api.OdaResultSetColumnHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.elements.structures.OdaResultSetColumn;
import org.eclipse.datatools.connectivity.oda.design.ColumnDefinition;
import org.eclipse.datatools.connectivity.oda.design.DataElementAttributes;

public class ROMResultSetsHelper {
    private List<OdaResultSetColumnHandle> oldColumns;
    private List<ColumnHintHandle> oldColumnHints;
    private List<ColumnDefinition> newColumnDefns;
    private String dataSourceId;
    private String dataSetId;
    private List<ROMResultColumnHelper> newColumnInfos;
    private List<OdaResultSetColumn> newColumns;
    private int size;

    public ROMResultSetsHelper(List<ColumnDefinition> oldColumnDefns, List<OdaResultSetColumnHandle> oldColumns, List<ColumnHintHandle> oldColumnHints, List<ColumnDefinition> newColumnDefns, String dataSourceId, String dataSetId) {
        this.oldColumns = oldColumns;
        this.oldColumnHints = oldColumnHints;
        this.newColumnDefns = newColumnDefns;
        this.dataSourceId = dataSourceId;
        this.dataSetId = dataSetId;
        this.size = newColumnDefns.size();
        this.initialize();
    }

    private void initialize() {
        this.linkWithOldColumnInfos();
        this.generateNewColumnInfos();
    }

    private String getColumnName(ColumnDefinition colDefn) {
        String name;
        String string = name = colDefn.getUsageHints() != null ? colDefn.getUsageHints().getLabel() : null;
        if (name == null) {
            name = colDefn.getAttributes().getName();
        }
        return name;
    }

    private void generateNewColumnInfos() {
        OdaResultSetColumn newColumn;
        ROMResultColumnHelper tmpColumnHelper = null;
        OdaResultSetColumnHandle oldColumn = null;
        ColumnDefinition newColumnDefn = null;
        String newDefinedLabel = null;
        String oldDefinedLabel = null;
        DataElementAttributes dataAttrs = null;
        HashSet<String> nameSet = new HashSet<String>();
        this.newColumns = new ArrayList<OdaResultSetColumn>();
        int i = 0;
        while (i < this.newColumnInfos.size()) {
            tmpColumnHelper = this.newColumnInfos.get(i);
            newColumn = StructureFactory.createOdaResultSetColumn();
            this.newColumns.add(newColumn);
            newColumnDefn = tmpColumnHelper.getNewColumnDefn();
            newDefinedLabel = this.getColumnName(newColumnDefn);
            oldColumn = tmpColumnHelper.getOldColumn();
            if (oldColumn != null && newDefinedLabel.equals(oldDefinedLabel = oldColumn.getColumnName())) {
                dataAttrs = newColumnDefn.getAttributes();
                newColumn.setColumnName(oldColumn.getColumnName());
                newColumn.setNativeDataType(dataAttrs.getNativeDataTypeCode());
                newColumn.setPosition(dataAttrs.getPosition());
                newColumn.setNativeName(dataAttrs.getName());
                newColumn.setDataType(this.getROMDataType(this.dataSourceId, this.dataSetId, newColumn, oldColumn));
                nameSet.add(oldColumn.getColumnName().toUpperCase());
            }
            ++i;
        }
        i = 0;
        while (i < this.newColumnInfos.size()) {
            tmpColumnHelper = this.newColumnInfos.get(i);
            oldColumn = tmpColumnHelper.getOldColumn();
            newColumnDefn = tmpColumnHelper.getNewColumnDefn();
            newColumn = this.newColumns.get(i);
            if (newColumn.getColumnName() == null) {
                dataAttrs = newColumnDefn.getAttributes();
                String newName = this.getColumnName(newColumnDefn);
                newName = this.getUniqueName(nameSet, newName);
                newColumn.setColumnName(newName);
                newColumn.setNativeDataType(dataAttrs.getNativeDataTypeCode());
                newColumn.setPosition(dataAttrs.getPosition());
                newColumn.setNativeName(dataAttrs.getName());
                newColumn.setDataType(this.getROMDataType(this.dataSourceId, this.dataSetId, newColumn, oldColumn));
            }
            ++i;
        }
    }

    private String getUniqueName(Set<String> nameSet, String newName) {
        if (nameSet.contains(newName.toUpperCase())) {
            int i = 1;
            String tmpName = String.valueOf(newName) + "_" + i;
            while (nameSet.contains(tmpName.toUpperCase())) {
                tmpName = String.valueOf(newName) + "_" + ++i;
            }
            newName = tmpName;
        }
        nameSet.add(newName.toUpperCase());
        return newName;
    }

    private void linkWithOldColumnInfos() {
        this.newColumnInfos = new ArrayList<ROMResultColumnHelper>();
        ColumnDefinition newColumnDefn = null;
        OdaResultSetColumnHandle oldColumn = null;
        ColumnHintHandle oldColumnHint = null;
        ROMResultColumnHelper tmpColumnHelper = null;
        String nativeName = null;
        int i = 0;
        while (i < this.newColumnDefns.size()) {
            newColumnDefn = this.newColumnDefns.get(i);
            tmpColumnHelper = new ROMResultColumnHelper(newColumnDefn);
            this.newColumnInfos.add(tmpColumnHelper);
            if (newColumnDefn.getAttributes() == null) {
                tmpColumnHelper.setup();
            }
            ++i;
        }
        String asName = null;
        int i2 = 0;
        while (i2 < this.newColumnInfos.size()) {
            tmpColumnHelper = this.newColumnInfos.get(i2);
            if (!tmpColumnHelper.isSetup() && (newColumnDefn = tmpColumnHelper.getNewColumnDefn()).getUsageHints() != null && (oldColumn = this.findOldColumnByNativeNameAndAs(nativeName = newColumnDefn.getAttributes().getName(), asName = newColumnDefn.getUsageHints().getLabel())) != null) {
                oldColumnHint = this.findOldColumnHint(oldColumn.getColumnName());
                tmpColumnHelper.setOldColumn(oldColumn);
                tmpColumnHelper.setOldColumnHint(oldColumnHint);
                tmpColumnHelper.setup();
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.newColumnInfos.size()) {
            tmpColumnHelper = this.newColumnInfos.get(i2);
            if (!tmpColumnHelper.isSetup()) {
                newColumnDefn = tmpColumnHelper.getNewColumnDefn();
                nativeName = newColumnDefn.getAttributes().getIdentifier().getName();
                oldColumn = this.findOldColumnByNativeName(nativeName);
                if (oldColumn != null) {
                    oldColumnHint = this.findOldColumnHint(oldColumn.getColumnName());
                } else {
                    oldColumn = null;
                    oldColumnHint = null;
                }
                tmpColumnHelper.setOldColumn(oldColumn);
                tmpColumnHelper.setOldColumnHint(oldColumnHint);
                tmpColumnHelper.setup();
            }
            ++i2;
        }
    }

    private OdaResultSetColumnHandle findOldColumnByNativeNameAndAs(String nativeName, String asName) {
        OdaResultSetColumnHandle tmpColumn = null;
        int i = 0;
        while (i < this.oldColumns.size()) {
            tmpColumn = this.oldColumns.get(i);
            if (tmpColumn.getColumnName().equals(asName) && tmpColumn.getNativeName().equals(nativeName)) {
                this.oldColumns.remove(i);
                return tmpColumn;
            }
            ++i;
        }
        return null;
    }

    private OdaResultSetColumnHandle findOldColumnByNativeName(String nativeName) {
        OdaResultSetColumnHandle tmpColumn = null;
        int i = 0;
        while (i < this.oldColumns.size()) {
            tmpColumn = this.oldColumns.get(i);
            if (tmpColumn.getNativeName().equals(nativeName)) {
                this.oldColumns.remove(i);
                return tmpColumn;
            }
            ++i;
        }
        return null;
    }

    private ColumnHintHandle findOldColumnHint(String columnName) {
        int i = 0;
        while (i < this.oldColumnHints.size()) {
            if (this.oldColumnHints.get(i).getColumnName().equals(columnName)) {
                return this.oldColumnHints.get(i);
            }
            ++i;
        }
        return null;
    }

    public ROMResultColumnHelper getColumnHelper(int i) {
        if (i < this.size) {
            return this.newColumnInfos.get(i);
        }
        return null;
    }

    public OdaResultSetColumn getNewColumn(int i) {
        if (i < this.size) {
            return this.newColumns.get(i);
        }
        return null;
    }

    private String getROMDataType(String dataSourceId, String dataSetId, OdaResultSetColumn newColumn, OdaResultSetColumnHandle oldColumn) {
        if (oldColumn == null) {
            return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, newColumn.getNativeDataType(), null);
        }
        Integer tmpPosition = oldColumn.getPosition();
        if (tmpPosition == null || !tmpPosition.equals(newColumn.getPosition())) {
            return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, newColumn.getNativeDataType(), null);
        }
        Integer tmpNativeCodeType = oldColumn.getNativeDataType();
        if (tmpNativeCodeType == null || tmpNativeCodeType.equals(newColumn.getNativeDataType())) {
            return oldColumn.getDataType();
        }
        String oldDataType = oldColumn.getDataType();
        return AdapterUtil.convertNativeTypeToROMDataType(dataSourceId, dataSetId, newColumn.getNativeDataType(), oldDataType);
    }
}

