/*
 * Decompiled with CFR 0.152.
 */
package uk.co.spudsoft.birt.emitters.excel;

import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.text.AttributedString;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.eclipse.birt.report.engine.content.IPageContent;
import org.eclipse.birt.report.engine.css.engine.value.DataFormatValue;
import org.eclipse.birt.report.engine.css.engine.value.StringValue;
import org.eclipse.birt.report.engine.ir.DimensionType;
import org.eclipse.birt.report.model.api.util.ColorUtil;
import org.w3c.dom.css.CSSValue;
import uk.co.spudsoft.birt.emitters.excel.AreaBorders;
import uk.co.spudsoft.birt.emitters.excel.BirtStyle;
import uk.co.spudsoft.birt.emitters.excel.ClientAnchorConversions;
import uk.co.spudsoft.birt.emitters.excel.DateFormatConverter;
import uk.co.spudsoft.birt.emitters.excel.FontManager;
import uk.co.spudsoft.birt.emitters.excel.HandlerState;
import uk.co.spudsoft.birt.emitters.excel.RichTextRun;
import uk.co.spudsoft.birt.emitters.excel.StyleManager;
import uk.co.spudsoft.birt.emitters.excel.framework.Logger;

public abstract class StyleManagerUtils {
    protected Logger log;
    protected static final FontRenderContext frc = new FontRenderContext(null, true, true);

    public StyleManagerUtils(Logger log) {
        this.log = log;
    }

    public abstract RichTextString createRichTextString(String var1);

    public static boolean objectsEqual(Object lhs, Object rhs) {
        return lhs == null ? rhs == null : lhs.equals(rhs);
    }

    public static boolean dataFormatsEquivalent(DataFormatValue dataFormat1, DataFormatValue dataFormat2) {
        if (dataFormat1 == null) {
            return dataFormat2 == null;
        }
        if (dataFormat2 == null) {
            return false;
        }
        return StyleManagerUtils.objectsEqual(dataFormat1.getNumberPattern(), dataFormat2.getNumberPattern()) && StyleManagerUtils.objectsEqual(dataFormat1.getDatePattern(), dataFormat2.getDatePattern()) && StyleManagerUtils.objectsEqual(dataFormat1.getDateTimePattern(), dataFormat2.getDateTimePattern()) && StyleManagerUtils.objectsEqual(dataFormat1.getTimePattern(), dataFormat2.getTimePattern());
    }

    public HorizontalAlignment poiAlignmentFromBirtAlignment(String alignment) {
        if ("left".equals(alignment)) {
            return HorizontalAlignment.LEFT;
        }
        if ("right".equals(alignment)) {
            return HorizontalAlignment.RIGHT;
        }
        if ("center".equals(alignment)) {
            return HorizontalAlignment.CENTER;
        }
        return HorizontalAlignment.GENERAL;
    }

    public short fontSizeInPoints(String fontSize) {
        if (fontSize == null) {
            return 11;
        }
        if ("xx-small".equals(fontSize)) {
            return 6;
        }
        if ("x-small".equals(fontSize)) {
            return 8;
        }
        if ("small".equals(fontSize)) {
            return 10;
        }
        if ("medium".equals(fontSize)) {
            return 11;
        }
        if ("large".equals(fontSize)) {
            return 14;
        }
        if ("x-large".equals(fontSize)) {
            return 18;
        }
        if ("xx-large".equals(fontSize)) {
            return 24;
        }
        if ("smaller".equals(fontSize)) {
            return 10;
        }
        if ("larger".equals(fontSize)) {
            return 14;
        }
        DimensionType dim = DimensionType.parserUnit(fontSize, "pt");
        if ("px".equals(dim.getUnits())) {
            double px = dim.getMeasure();
            double inches = px / 96.0;
            double points = 72.0 * inches;
            return (short)points;
        }
        if ("em".equals(dim.getUnits())) {
            return (short)(12.0 * dim.getMeasure());
        }
        if ("%".equals(dim.getUnits())) {
            return (short)(12.0 * dim.getMeasure() / 100.0);
        }
        double points = dim.convertTo("pt");
        return (short)points;
    }

    public int poiColumnWidthFromDimension(DimensionType dim) {
        if (dim != null) {
            double mmWidth = dim.getMeasure();
            if ("cm".equals(dim.getUnits()) || "in".equals(dim.getUnits()) || "pt".equals(dim.getUnits()) || "pc".equals(dim.getUnits())) {
                mmWidth = dim.convertTo("mm");
            }
            int result = ClientAnchorConversions.millimetres2WidthUnits(mmWidth);
            return result;
        }
        return 0;
    }

    public boolean poiFontWeightFromBirt(String fontWeight) {
        if (fontWeight == null) {
            return false;
        }
        return "bold".equals(fontWeight);
    }

    public String poiFontNameFromBirt(String fontName) {
        if ("serif".equals(fontName)) {
            return "Times New Roman";
        }
        if ("sans-serif".equals(fontName)) {
            return "Arial";
        }
        if ("monospace".equals(fontName)) {
            return "Courier New";
        }
        return fontName;
    }

    public abstract void addColourToFont(Workbook var1, Font var2, String var3);

    public abstract void addBackgroundColourToStyle(Workbook var1, CellStyle var2, String var3);

    public static boolean cellIsEmpty(Cell cell) {
        if (!CellType.BLANK.equals((Object)cell.getCellType())) {
            return false;
        }
        CellStyle cellStyle = cell.getCellStyle();
        return cellStyle == null || FillPatternType.NO_FILL.equals((Object)cellStyle.getFillPattern());
    }

    public abstract void applyBorderStyle(Workbook var1, CellStyle var2, XSSFCellBorder.BorderSide var3, CSSValue var4, CSSValue var5, CSSValue var6);

    public int poiImageTypeFromMimeType(String mimeType, byte[] data) {
        if ("image/jpeg".equals(mimeType)) {
            return 5;
        }
        if ("image/png".equals(mimeType)) {
            return 6;
        }
        if ("image/bmp".equals(mimeType)) {
            return 7;
        }
        if (data != null) {
            this.log.debug("Data bytes:  " + Integer.toHexString(data[0]).toUpperCase() + " " + Integer.toHexString(data[1]).toUpperCase() + " " + Integer.toHexString(data[2]).toUpperCase() + " " + Integer.toHexString(data[3]).toUpperCase());
            if (data.length > 2 && data[0] == -1 && data[1] == -40 && data[2] == -1) {
                return 5;
            }
            if (data.length > 4 && data[0] == -119 && data[1] == 80 && data[2] == 78 && data[3] == 71) {
                return 6;
            }
        }
        return 0;
    }

    public byte[] streamToByteArray(InputStream stream, int length) throws IOException {
        int nRead;
        ByteArrayOutputStream buffer = length > 0 ? new ByteArrayOutputStream(length) : new ByteArrayOutputStream();
        byte[] data = new byte[16384];
        while ((nRead = stream.read(data, 0, data.length)) != -1) {
            buffer.write(data, 0, nRead);
        }
        buffer.flush();
        return buffer.toByteArray();
    }

    public byte[] downloadImage(URLConnection conn) {
        try {
            int contentLength = conn.getContentLength();
            InputStream imageStream = conn.getInputStream();
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                try {
                    return this.streamToByteArray(imageStream, contentLength);
                }
                finally {
                    if (imageStream != null) {
                        imageStream.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            this.log.debug(ex.getClass(), ": ", ex.getMessage());
            return null;
        }
    }

    public short getPaperSizeFromString(String name) {
        if ("a4".equals(name)) {
            return 9;
        }
        if ("a3".equals(name)) {
            return 8;
        }
        if ("us-letter".equals(name)) {
            return 1;
        }
        return 9;
    }

    public boolean isAbsolute(DimensionType dim) {
        if (dim == null) {
            return false;
        }
        String units = dim.getUnits();
        return "cm".equals(units) || "in".equals(units) || "mm".equals(units) || "pt".equals(units) || "pc".equals(units);
    }

    public boolean isPixels(DimensionType dim) {
        return dim != null && "px".equals(dim.getUnits());
    }

    private String poiNumberFormatFromBirt(String birtFormat) {
        if ("General Number".equalsIgnoreCase(birtFormat)) {
            return null;
        }
        if (birtFormat.startsWith("ExcelEmitter.CustomNumberFormat")) {
            return birtFormat.substring("ExcelEmitter.CustomNumberFormat".length());
        }
        birtFormat = birtFormat.replace("E00", "E+00");
        int brace = (birtFormat = birtFormat.replaceAll("^([^0#.\\-,E;%\u2030\u00a4']*)", "\"$1\"")).indexOf(123);
        if (brace >= 0) {
            birtFormat = birtFormat.substring(0, brace);
        }
        return birtFormat;
    }

    private String poiDateTimeFormatFromBirt(String birtFormat, Locale locale) {
        if ("General Date".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaDateTimePattern(1, locale);
        }
        if ("Long Date".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaDatePattern(1, locale);
        }
        if ("Medium Date".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaDatePattern(2, locale);
        }
        if ("Short Date".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaDatePattern(3, locale);
        }
        if ("Long Time".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaTimePattern(1, locale);
        }
        if ("Medium Time".equalsIgnoreCase(birtFormat)) {
            birtFormat = DateFormatConverter.getJavaTimePattern(2, locale);
        }
        if ("Short Time".equalsIgnoreCase(birtFormat)) {
            birtFormat = "kk:mm";
        }
        return DateFormatConverter.convert(locale, birtFormat);
    }

    public static String getNumberFormat(BirtStyle style) {
        CSSValue dataFormat = style.getProperty(1);
        if (dataFormat instanceof DataFormatValue) {
            DataFormatValue dataFormatValue = (DataFormatValue)dataFormat;
            return dataFormatValue.getNumberPattern();
        }
        return null;
    }

    public static String getDateFormat(BirtStyle style) {
        CSSValue dataFormat = style.getProperty(1);
        if (dataFormat instanceof DataFormatValue) {
            DataFormatValue dataFormatValue = (DataFormatValue)dataFormat;
            return dataFormatValue.getDatePattern();
        }
        return null;
    }

    public static String getDateTimeFormat(BirtStyle style) {
        CSSValue dataFormat = style.getProperty(1);
        if (dataFormat instanceof DataFormatValue) {
            DataFormatValue dataFormatValue = (DataFormatValue)dataFormat;
            return dataFormatValue.getDateTimePattern();
        }
        return null;
    }

    public static String getTimeFormat(BirtStyle style) {
        CSSValue dataFormat = style.getProperty(1);
        if (dataFormat instanceof DataFormatValue) {
            DataFormatValue dataFormatValue = (DataFormatValue)dataFormat;
            return dataFormatValue.getTimePattern();
        }
        return null;
    }

    public static DataFormatValue cloneDataFormatValue(DataFormatValue dataValue) {
        DataFormatValue newValue = new DataFormatValue();
        newValue.setDateFormat(dataValue.getDatePattern(), dataValue.getDateLocale());
        newValue.setDateTimeFormat(dataValue.getDateTimePattern(), dataValue.getDateTimeLocale());
        newValue.setTimeFormat(dataValue.getTimePattern(), dataValue.getTimeLocale());
        newValue.setNumberFormat(dataValue.getNumberPattern(), dataValue.getNumberLocale());
        newValue.setStringFormat(dataValue.getStringPattern(), dataValue.getStringLocale());
        return newValue;
    }

    public static void setNumberFormat(BirtStyle style, String pattern, String locale) {
        DataFormatValue dfv = (DataFormatValue)style.getProperty(1);
        dfv = dfv == null ? new DataFormatValue() : StyleManagerUtils.cloneDataFormatValue(dfv);
        dfv.setNumberFormat(pattern, locale);
        style.setProperty(1, dfv);
    }

    public static void setDateFormat(BirtStyle style, String pattern, String locale) {
        DataFormatValue dfv = (DataFormatValue)style.getProperty(1);
        dfv = dfv == null ? new DataFormatValue() : StyleManagerUtils.cloneDataFormatValue(dfv);
        dfv.setDateFormat(pattern, locale);
        style.setProperty(1, dfv);
    }

    public static void setDateTimeFormat(BirtStyle style, String pattern, String locale) {
        DataFormatValue dfv = (DataFormatValue)style.getProperty(1);
        dfv = dfv == null ? new DataFormatValue() : StyleManagerUtils.cloneDataFormatValue(dfv);
        dfv.setDateTimeFormat(pattern, locale);
        style.setProperty(1, dfv);
    }

    public static void setTimeFormat(BirtStyle style, String pattern, String locale) {
        DataFormatValue dfv = (DataFormatValue)style.getProperty(1);
        dfv = dfv == null ? new DataFormatValue() : StyleManagerUtils.cloneDataFormatValue(dfv);
        dfv.setTimeFormat(pattern, locale);
        style.setProperty(1, dfv);
    }

    public void applyNumberFormat(Workbook workbook, BirtStyle birtStyle, CellStyle poiStyle, Locale locale) {
        String dataFormat = null;
        String format = StyleManagerUtils.getNumberFormat(birtStyle);
        if (format != null) {
            this.log.debug("BIRT number format == ", format);
            dataFormat = this.poiNumberFormatFromBirt(format);
        } else {
            format = StyleManagerUtils.getDateTimeFormat(birtStyle);
            if (format != null) {
                this.log.debug("BIRT date/time format == ", format);
                dataFormat = this.poiDateTimeFormatFromBirt(format, locale);
            } else {
                format = StyleManagerUtils.getTimeFormat(birtStyle);
                if (format != null) {
                    this.log.debug("BIRT time format == ", format);
                    dataFormat = this.poiDateTimeFormatFromBirt(format, locale);
                } else {
                    format = StyleManagerUtils.getDateFormat(birtStyle);
                    if (format != null) {
                        this.log.debug("BIRT date format == ", format);
                        dataFormat = this.poiDateTimeFormatFromBirt(format, locale);
                    }
                }
            }
        }
        if (dataFormat != null) {
            DataFormat poiFormat = workbook.createDataFormat();
            this.log.debug("Setting POI data format to ", dataFormat);
            poiStyle.setDataFormat(poiFormat.getFormat(dataFormat));
        }
    }

    protected void addFontAttributes(AttributedString attrString, Font font, int startIdx, int endIdx) {
        attrString.addAttribute(TextAttribute.FAMILY, font.getFontName(), startIdx, endIdx);
        attrString.addAttribute(TextAttribute.SIZE, Float.valueOf(font.getFontHeightInPoints()), startIdx, endIdx);
        if (font.getBold()) {
            attrString.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, startIdx, endIdx);
        }
        if (font.getItalic()) {
            attrString.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, startIdx, endIdx);
        }
        if (font.getUnderline() == 1) {
            attrString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, startIdx, endIdx);
        }
    }

    protected int getRichTextRunIndexForStart(List<RichTextRun> richTextRuns, int startIndex) {
        if (richTextRuns.isEmpty()) {
            return -1;
        }
        int i = 0;
        while (i < richTextRuns.size()) {
            if (richTextRuns.get((int)i).startIndex >= startIndex) {
                return i - 1;
            }
            ++i;
        }
        return richTextRuns.size() - 1;
    }

    public float calculateTextHeightPoints(String sourceText, Font defaultFont, double widthMM, List<RichTextRun> richTextRuns) {
        this.log.debug("Calculating height for ", sourceText);
        float widthPt = (float)(72.0 * Math.max(0.0, widthMM - 6.0) / 25.4);
        float totalHeight = 0.0f;
        String[] textLines = sourceText.split("\n");
        int lineStartIndex = 0;
        String lastLine = null;
        Font font = defaultFont;
        String[] stringArray = textLines;
        int n = textLines.length;
        int n2 = 0;
        while (n2 < n) {
            String textLine = stringArray[n2];
            if (lastLine != null) {
                lineStartIndex += lastLine.length() + 1;
            }
            lastLine = textLine;
            AttributedString attrString = new AttributedString(textLine.isEmpty() ? " " : textLine);
            int runEnd = textLine.length();
            int richTextRunIndex = this.getRichTextRunIndexForStart(richTextRuns, lineStartIndex);
            if (richTextRunIndex >= 0) {
                font = richTextRuns.get((int)richTextRunIndex).font;
                if (richTextRunIndex < richTextRuns.size() - 1 && richTextRuns.get((int)(richTextRunIndex + 1)).startIndex < runEnd) {
                    runEnd = richTextRuns.get((int)(richTextRunIndex + 1)).startIndex;
                }
            }
            this.log.debug("Adding attribute - [", 0, " - ", runEnd, "] = ", defaultFont.getFontName(), " ", defaultFont.getFontHeightInPoints(), "pt");
            this.addFontAttributes(attrString, font, 0, textLine.isEmpty() ? 1 : runEnd);
            ++richTextRunIndex;
            while (richTextRunIndex < richTextRuns.size() && richTextRuns.get((int)richTextRunIndex).startIndex < lineStartIndex + textLine.length()) {
                RichTextRun nextRun;
                RichTextRun run = richTextRuns.get(richTextRunIndex);
                RichTextRun richTextRun = nextRun = richTextRunIndex < richTextRuns.size() - 1 ? richTextRuns.get(richTextRunIndex + 1) : null;
                if (run.startIndex >= lineStartIndex && run.startIndex < lineStartIndex + textLine.length() + 1) {
                    int startIdx = run.startIndex - lineStartIndex;
                    int endIdx = (nextRun == null ? sourceText.length() : nextRun.startIndex) - lineStartIndex;
                    if (endIdx > textLine.length()) {
                        endIdx = textLine.length();
                    }
                    if (startIdx < endIdx) {
                        this.log.debug("Adding attribute: [", startIdx, " - ", endIdx, "] = ", run.font.getFontName(), " ", run.font.getFontHeightInPoints(), "pt");
                        this.addFontAttributes(attrString, run.font, startIdx, endIdx);
                    }
                }
                ++richTextRunIndex;
            }
            LineBreakMeasurer measurer = new LineBreakMeasurer(attrString.getIterator(), frc);
            float heightAdjustment = 0.0f;
            int lineLength = textLine.isEmpty() ? 1 : textLine.length();
            while (measurer.getPosition() < lineLength) {
                TextLayout layout = measurer.nextLayout(widthPt);
                float lineHeight = layout.getAscent() + layout.getDescent() + layout.getLeading();
                if (layout.getDescent() + layout.getLeading() > heightAdjustment) {
                    heightAdjustment = layout.getDescent() + layout.getLeading();
                }
                this.log.debug("Line: ", textLine, " gives height ", Float.valueOf(lineHeight), "(", Float.valueOf(layout.getAscent()), "/", Float.valueOf(layout.getDescent()), "/", Float.valueOf(layout.getLeading()), ")");
                totalHeight += lineHeight;
            }
            totalHeight += heightAdjustment;
            ++n2;
        }
        this.log.debug("Height calculated as ", Float.valueOf(totalHeight));
        return totalHeight;
    }

    protected String contrastColour(int[] colour) {
        if (colour[0] == 0 && colour[1] == 0 && colour[2] == 0) {
            return "white";
        }
        return "black";
    }

    protected int[] rgbOnly(int[] rgb) {
        if (rgb == null) {
            return new int[3];
        }
        if (rgb.length == 3) {
            return rgb;
        }
        if (rgb.length > 3) {
            return new int[]{rgb[rgb.length - 3], rgb[rgb.length - 2], rgb[rgb.length - 1]};
        }
        if (rgb.length == 2) {
            int[] nArray = new int[3];
            nArray[0] = rgb[0];
            nArray[1] = rgb[1];
            return nArray;
        }
        if (rgb.length == 2) {
            int[] nArray = new int[3];
            nArray[0] = rgb[0];
            return nArray;
        }
        return new int[3];
    }

    protected int[] rgbOnly(byte[] rgb) {
        if (rgb == null) {
            return new int[3];
        }
        if (rgb.length >= 3) {
            return new int[]{rgb[rgb.length - 3] & 0xFF, rgb[rgb.length - 2] & 0xFF, rgb[rgb.length - 1] & 0xFF};
        }
        if (rgb.length == 2) {
            int[] nArray = new int[3];
            nArray[0] = rgb[0] & 0xFF;
            nArray[1] = rgb[1] & 0xFF;
            return nArray;
        }
        if (rgb.length == 2) {
            int[] nArray = new int[3];
            nArray[0] = rgb[0] & 0xFF;
            return nArray;
        }
        return new int[3];
    }

    int[] parseColour(String colour, String defaultColour) {
        if (colour == null || "transparent".equals(colour) || "auto".equals(colour)) {
            return this.rgbOnly(ColorUtil.getRGBs(defaultColour));
        }
        return this.rgbOnly(ColorUtil.getRGBs(colour));
    }

    public abstract Font correctFontColorIfBackground(FontManager var1, Workbook var2, BirtStyle var3, Font var4);

    public void correctFontColorIfBackground(BirtStyle birtStyle) {
        int[] fgRgb;
        CSSValue bgColour = birtStyle.getProperty(8);
        CSSValue fgColour = birtStyle.getProperty(0);
        int[] bgRgb = this.parseColour(bgColour == null ? null : bgColour.getCssText(), "white");
        if (bgRgb[0] == (fgRgb = this.parseColour(fgColour == null ? null : fgColour.getCssText(), "black"))[0] && bgRgb[1] == fgRgb[1] && bgRgb[2] == fgRgb[2]) {
            StringValue newColour = new StringValue(19, this.contrastColour(bgRgb));
            birtStyle.setProperty(0, newColour);
        }
    }

    public abstract int anchorDxFromMM(double var1, double var3);

    public abstract int anchorDyFromPoints(float var1, float var2);

    public abstract void prepareMarginDimensions(Sheet var1, IPageContent var2);

    public void applyBordersToArea(StyleManager sm, Sheet sheet, int colStart, int colEnd, int rowStart, int rowEnd, BirtStyle borderStyle) {
        StringBuilder borderMsg = new StringBuilder();
        borderMsg.append("applyBordersToArea [").append(colStart).append(",").append(rowStart).append("]-[").append(colEnd).append(",").append(rowEnd).append("]");
        CSSValue borderStyleBottom = borderStyle.getProperty(22);
        CSSValue borderWidthBottom = borderStyle.getProperty(11);
        CSSValue borderColourBottom = borderStyle.getProperty(15);
        CSSValue borderStyleLeft = borderStyle.getProperty(52);
        CSSValue borderWidthLeft = borderStyle.getProperty(42);
        CSSValue borderColourLeft = borderStyle.getProperty(46);
        CSSValue borderStyleRight = borderStyle.getProperty(21);
        CSSValue borderWidthRight = borderStyle.getProperty(10);
        CSSValue borderColourRight = borderStyle.getProperty(14);
        CSSValue borderStyleTop = borderStyle.getProperty(49);
        CSSValue borderWidthTop = borderStyle.getProperty(41);
        CSSValue borderColourTop = borderStyle.getProperty(13);
        if (borderStyleBottom == null || "none".equals(borderStyleBottom) || borderWidthBottom == null || "0".equals(borderWidthBottom) || borderColourBottom == null || "transparent".equals(borderColourBottom.getCssText())) {
            borderStyleBottom = null;
            borderWidthBottom = null;
            borderColourBottom = null;
        }
        if (borderStyleLeft == null || "none".equals(borderStyleLeft) || borderWidthLeft == null || "0".equals(borderWidthLeft) || borderColourLeft == null || "transparent".equals(borderColourLeft.getCssText())) {
            borderStyleLeft = null;
            borderWidthLeft = null;
            borderColourLeft = null;
        }
        if (borderStyleRight == null || "none".equals(borderStyleRight) || borderWidthRight == null || "0".equals(borderWidthRight) || borderColourRight == null || "transparent".equals(borderColourRight.getCssText())) {
            borderStyleRight = null;
            borderWidthRight = null;
            borderColourRight = null;
        }
        if (borderStyleTop == null || "none".equals(borderStyleTop) || borderWidthTop == null || "0".equals(borderWidthTop) || borderColourTop == null || "transparent".equals(borderColourTop.getCssText())) {
            borderStyleTop = null;
            borderWidthTop = null;
            borderColourTop = null;
        }
        if (borderStyleBottom != null || borderWidthBottom != null || borderColourBottom != null || borderStyleLeft != null || borderWidthLeft != null || borderColourLeft != null || borderStyleRight != null || borderWidthRight != null || borderColourRight != null || borderStyleTop != null || borderWidthTop != null || borderColourTop != null) {
            int row = rowStart;
            while (row <= rowEnd) {
                Row styleRow = sheet.getRow(row);
                if (styleRow != null) {
                    int col = colStart;
                    while (col <= colEnd) {
                        if (col == colStart || col == colEnd || row == rowStart || row == rowEnd) {
                            Cell styleCell = styleRow.getCell(col);
                            if (styleCell == null) {
                                this.log.debug("Creating cell[", row, ",", col, "]");
                                styleCell = styleRow.createCell(col);
                            }
                            if (styleCell != null) {
                                CellStyle newStyle = sm.getStyleWithBorders(styleCell.getCellStyle(), row == rowEnd ? borderStyleBottom : null, row == rowEnd ? borderWidthBottom : null, row == rowEnd ? borderColourBottom : null, col == colStart ? borderStyleLeft : null, col == colStart ? borderWidthLeft : null, col == colStart ? borderColourLeft : null, col == colEnd ? borderStyleRight : null, col == colEnd ? borderWidthRight : null, col == colEnd ? borderColourRight : null, row == rowStart ? borderStyleTop : null, row == rowStart ? borderWidthTop : null, row == rowStart ? borderColourTop : null);
                                styleCell.setCellStyle(newStyle);
                            }
                        }
                        ++col;
                    }
                }
                ++row;
            }
        }
    }

    public void applyBottomBorderToRow(StyleManager sm, Sheet sheet, int colStart, int colEnd, int row, BirtStyle borderStyle) {
        Row styleRow;
        CSSValue borderStyleBottom = borderStyle.getProperty(22);
        CSSValue borderWidthBottom = borderStyle.getProperty(11);
        CSSValue borderColourBottom = borderStyle.getProperty(15);
        if (borderStyleBottom == null || "none".equals(borderStyleBottom.getCssText()) || borderWidthBottom == null || "0".equals(borderWidthBottom) || borderColourBottom == null || "transparent".equals(borderColourBottom.getCssText())) {
            borderStyleBottom = null;
            borderWidthBottom = null;
            borderColourBottom = null;
        }
        if ((borderStyleBottom != null || borderWidthBottom != null || borderColourBottom != null) && (styleRow = sheet.getRow(row)) != null) {
            int col = colStart;
            while (col <= colEnd) {
                Cell styleCell = styleRow.getCell(col);
                if (styleCell == null) {
                    styleCell = styleRow.createCell(col);
                }
                if (styleCell != null) {
                    CellStyle newStyle = sm.getStyleWithBorders(styleCell.getCellStyle(), borderStyleBottom, borderWidthBottom, borderColourBottom, null, null, null, null, null, null, null, null, null);
                    styleCell.setCellStyle(newStyle);
                }
                ++col;
            }
        }
    }

    public int applyAreaBordersToCell(Collection<AreaBorders> knownAreaBorders, Cell cell, BirtStyle birtCellStyle, int rowIndex, int colIndex) {
        for (AreaBorders areaBorders : knownAreaBorders) {
            if (areaBorders.bottom == rowIndex && areaBorders.left <= colIndex && areaBorders.right >= colIndex && areaBorders.cssStyle[0] != null && areaBorders.cssWidth[0] != null && areaBorders.cssColour[0] != null) {
                birtCellStyle.setProperty(22, areaBorders.cssStyle[0]);
                birtCellStyle.setProperty(11, areaBorders.cssWidth[0]);
                birtCellStyle.setProperty(15, areaBorders.cssColour[0]);
            }
            if (areaBorders.left == colIndex && areaBorders.top <= rowIndex && (areaBorders.bottom < 0 || areaBorders.bottom >= rowIndex) && areaBorders.cssStyle[1] != null && areaBorders.cssWidth[1] != null && areaBorders.cssColour[1] != null) {
                birtCellStyle.setProperty(52, areaBorders.cssStyle[1]);
                birtCellStyle.setProperty(42, areaBorders.cssWidth[1]);
                birtCellStyle.setProperty(46, areaBorders.cssColour[1]);
            }
            if (areaBorders.right == colIndex && areaBorders.top <= rowIndex && (areaBorders.bottom < 0 || areaBorders.bottom >= rowIndex) && areaBorders.cssStyle[2] != null && areaBorders.cssWidth[2] != null && areaBorders.cssColour[2] != null) {
                birtCellStyle.setProperty(21, areaBorders.cssStyle[2]);
                birtCellStyle.setProperty(10, areaBorders.cssWidth[2]);
                birtCellStyle.setProperty(14, areaBorders.cssColour[2]);
            }
            if (areaBorders.top != rowIndex || areaBorders.left > colIndex || areaBorders.right < colIndex || areaBorders.cssStyle[3] == null || areaBorders.cssWidth[3] == null || areaBorders.cssColour[3] == null) continue;
            birtCellStyle.setProperty(49, areaBorders.cssStyle[3]);
            birtCellStyle.setProperty(41, areaBorders.cssWidth[3]);
            birtCellStyle.setProperty(13, areaBorders.cssColour[3]);
        }
        return colIndex;
    }

    public void extendRows(HandlerState state, int startRow, int startCol, int endRow, int endCol) {
        int colNum = startCol;
        while (colNum < endCol) {
            Cell lastCell = null;
            int rowNum = startRow;
            while (rowNum < endRow) {
                Cell cell;
                Row row = state.currentSheet.getRow(rowNum);
                if (row != null && (cell = row.getCell(colNum)) != null) {
                    lastCell = cell;
                }
                ++rowNum;
            }
            if (lastCell != null && lastCell.getRowIndex() < endRow - 1) {
                CellRangeAddress range = new CellRangeAddress(lastCell.getRowIndex(), endRow - 1, lastCell.getColumnIndex(), lastCell.getColumnIndex());
                this.log.debug("Extend: merging from [", range.getFirstRow(), ",", range.getFirstColumn(), "] to [", range.getLastRow(), ",", range.getLastColumn(), "]");
                state.currentSheet.addMergedRegion(range);
                int rowNum2 = lastCell.getRowIndex() + 1;
                while (rowNum2 < endRow) {
                    Row row = state.currentSheet.getRow(rowNum2);
                    if (row == null) {
                        this.log.error(0, "Creating a row (for column " + colNum + "), this really shouldn't be necessary", null);
                        row = state.currentSheet.createRow(rowNum2);
                    }
                    Cell cell = row.createCell(colNum);
                    cell.setCellStyle(lastCell.getCellStyle());
                    ++rowNum2;
                }
            }
            ++colNum;
        }
    }

    public static interface Factory {
        public StyleManagerUtils create(Logger var1);
    }
}

