/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.item.crosstab.core.re.executor;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.ITableBandContent;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.BaseCrosstabExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.CrosstabSubTotalRowExecutor;
import org.eclipse.birt.report.item.crosstab.core.re.executor.GroupUtil;

public class CrosstabGroupBandExecutor
extends BaseCrosstabExecutor {
    private int bandType;
    private int dimensionIndex;
    private int levelIndex;
    private int currentRow;
    private int totalRow;

    public CrosstabGroupBandExecutor(BaseCrosstabExecutor parent, int dimensionIndex, int levelIndex, int bandType) {
        super(parent);
        this.bandType = bandType;
        this.dimensionIndex = dimensionIndex;
        this.levelIndex = levelIndex;
    }

    @Override
    public IContent execute() {
        ITableBandContent content = this.context.getReportContent().createTableBandContent();
        content.setBandType(this.bandType);
        this.initializeContent(content, null);
        this.prepareChildren();
        return content;
    }

    private void prepareChildren() {
        this.currentRow = 0;
        int count = this.crosstabItem.getMeasureCount();
        this.totalRow = count > 1 && "vertical".equals(this.crosstabItem.getMeasureDirection()) ? count : 1;
    }

    @Override
    public IReportItemExecutor getNextChild() {
        if (this.bandType == 0) {
            return new CrosstabRowExecutor(this, this.currentRow++, this.dimensionIndex, this.levelIndex);
        }
        return new CrosstabSubTotalRowExecutor(this, this.currentRow++, this.dimensionIndex, this.levelIndex);
    }

    @Override
    public boolean hasNextChild() {
        if (this.currentRow < this.totalRow) {
            if (this.bandType == 0) {
                return true;
            }
            if (GroupUtil.hasTotalContent(this.crosstabItem, 0, this.dimensionIndex, this.levelIndex, "vertical".equals(this.crosstabItem.getMeasureDirection()) ? this.currentRow : -1)) {
                return true;
            }
            ++this.currentRow;
            return this.hasNextChild();
        }
        return false;
    }
}

