/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.data.adapter.api.script;

import java.io.Serializable;
import java.math.BigDecimal;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.Time;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.data.adapter.api.AdapterException;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.model.api.ParameterHandle;
import org.eclipse.birt.report.model.api.ScalarParameterHandle;

public class ReportContextObject {
    ModuleHandle module;

    public ReportContextObject(ModuleHandle module) {
        assert (module != null);
        this.module = module;
    }

    public Object getParameterValue(String name) {
        ParameterHandle param = this.module.findParameter(name);
        if (param != null) {
            return this.getParamDefaultValue(this.module.findParameter(name));
        }
        return null;
    }

    public Object getParameterDisplayText(String name) {
        ParameterHandle param = this.module.findParameter(name);
        if (param != null) {
            return this.module.findParameter(name).getDisplayName();
        }
        return null;
    }

    public Object getLocale() {
        return AccessController.doPrivileged(new PrivilegedAction<Locale>(){

            @Override
            public Locale run() {
                return Locale.getDefault();
            }
        });
    }

    private Object getParamDefaultValue(ParameterHandle param) {
        if (!(param instanceof ScalarParameterHandle)) {
            return null;
        }
        ScalarParameterHandle sp = (ScalarParameterHandle)param;
        String defaultValue = sp.getDefaultValue();
        String type = sp.getDataType();
        if (defaultValue == null) {
            if (sp.allowNull()) {
                return null;
            }
            if ("string".equals(type)) {
                if (sp.allowBlank()) {
                    return "";
                }
                return "null";
            }
            if ("float".equals(type)) {
                return new Double(0.0);
            }
            if ("decimal".equals(type)) {
                return new BigDecimal(0.0);
            }
            if ("dateTime".equals(type)) {
                return new Date(0L);
            }
            if ("time".equals(type)) {
                return new Time(0L);
            }
            if ("date".equals(type)) {
                return new java.sql.Date(0L);
            }
            if ("boolean".equals(type)) {
                return Boolean.FALSE;
            }
            if ("javaObject".equals(type)) {
                return null;
            }
            assert (false);
            return null;
        }
        int typeNum = 0;
        if ("string".equals(type)) {
            typeNum = 5;
        } else if ("float".equals(type)) {
            typeNum = 3;
        } else if ("decimal".equals(type)) {
            typeNum = 4;
        } else if ("dateTime".equals(type)) {
            typeNum = 6;
        } else if ("boolean".equals(type)) {
            typeNum = 1;
        } else if ("javaObject".equals(type)) {
            typeNum = 11;
        }
        try {
            return DataTypeUtil.convert((Object)defaultValue, typeNum);
        }
        catch (BirtException e) {
            return null;
        }
    }

    public void getReportRunnable() throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getReportRunnable");
    }

    public void setParameterValue(String name, Object value) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "setParameterValue");
    }

    public void setParameterDisplayText(String name, String value) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "setParameterDisplayText");
    }

    public String getOutputFormat() throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getOutputFormat");
    }

    public Map getAppContext() throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getAppContext");
    }

    public Object getHttpServletRequest() throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getHttpServletRequest");
    }

    public void setGlobalVariable(String name, Object obj) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "setGlobalVariable");
    }

    public void deleteGlobalVariable(String name) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "deleteGlobalVariable");
    }

    public Object getGlobalVariable(String name) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getGlobalVariable");
    }

    public void setPersistentGlobalVariable(String name, Serializable obj) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "setPersistentGlobalVariable");
    }

    public void deletePersistentGlobalVariable(String name) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "deletePersistentGlobalVariable");
    }

    public Object getPersistentGlobalVariable(String name) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getPersistentGlobalVariable");
    }

    public String getMessage(String key) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getMessage");
    }

    public String getMessage(String key, Locale locale) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getMessage");
    }

    public String getMessage(String key, Object[] params) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getMessage");
    }

    public String getMessage(String key, Locale locale, Object[] params) throws AdapterException {
        throw new AdapterException("context.invalidDesigntimeMethod", "getMessage");
    }
}

