/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.visualization.util.svg;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.app4mc.visualization.util.svg.AbstractDiagram;

public class GraphvizDiagram
extends AbstractDiagram {
    @Override
    public String renderToSvg() throws IOException {
        int len;
        String source = this.getDiagramText();
        if (source == null || source.isEmpty()) {
            return null;
        }
        ArrayList<String> command = new ArrayList<String>(2);
        command.add(this.getGraphvizPath());
        command.add("-Tsvg");
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        InputStreamReader reader = new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8);
        writer.append(source);
        writer.close();
        StringBuilder sb = new StringBuilder();
        char[] buf = new char[1024];
        while ((len = reader.read(buf)) >= 0) {
            sb.append(buf, 0, len);
        }
        return sb.toString();
    }

    public void runGraphviz(String ... args) throws IOException {
        String source = this.getDiagramText();
        if (source == null || source.isEmpty()) {
            return;
        }
        ArrayList<String> command = new ArrayList<String>(args.length + 1);
        command.add(this.getGraphvizPath());
        command.addAll(Arrays.asList(args));
        Process process = new ProcessBuilder(command).redirectError(ProcessBuilder.Redirect.PIPE).start();
        OutputStreamWriter writer = new OutputStreamWriter(process.getOutputStream());
        writer.append(source);
        writer.close();
    }
}

