/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.atdb.metrics;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import org.eclipse.app4mc.atdb.metrics.DBResultRowDataProvider;
import org.eclipse.app4mc.atdb.metrics.DatabaseAccess;
import org.eclipse.app4mc.atdb.metrics.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.DefaultNatTableStyleConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.data.ISpanningDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.data.DefaultCornerDataProvider;
import org.eclipse.nebula.widgets.nattable.grid.layer.ColumnHeaderLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.CornerLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultColumnHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.DefaultRowHeaderDataLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.GridLayer;
import org.eclipse.nebula.widgets.nattable.grid.layer.RowHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupExpandCollapseLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.RowGroupHeaderLayer;
import org.eclipse.nebula.widgets.nattable.group.performance.config.DefaultRowGroupHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;
import org.eclipse.nebula.widgets.nattable.layer.IUniqueIndexLayer;
import org.eclipse.nebula.widgets.nattable.layer.SpanningDataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.DataCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.LayerCell;
import org.eclipse.nebula.widgets.nattable.layer.cell.TranslatedLayerCell;
import org.eclipse.nebula.widgets.nattable.layer.config.DefaultRowHeaderLayerConfiguration;
import org.eclipse.nebula.widgets.nattable.selection.SelectionLayer;
import org.eclipse.nebula.widgets.nattable.style.theme.ModernNatTableThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.style.theme.ThemeConfiguration;
import org.eclipse.nebula.widgets.nattable.ui.menu.HeaderMenuConfiguration;
import org.eclipse.nebula.widgets.nattable.viewport.ViewportLayer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class DBViewer
extends EditorPart
implements IEditorPart {
    private Map<String, DBResultRowDataProvider> view2ResultRowDataProvider = new LinkedHashMap<String, DBResultRowDataProvider>();
    private CTabFolder cTabFolder = null;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.setPartName(input.getName());
        if (input instanceof FileEditorInput) {
            FileEditorInput fei = (FileEditorInput)input;
            IFile dbFile = fei.getFile();
            try {
                Throwable throwable = null;
                Object var6_7 = null;
                try (DatabaseAccess dbAccess = new DatabaseAccess(dbFile);){
                    this.view2ResultRowDataProvider.put(Messages.DBViewer_processTimeMetricsTitle, dbAccess.getProcessMetricValues(List.of("time"), true));
                    this.view2ResultRowDataProvider.put(Messages.DBViewer_runnableTimeMetricsTitle, dbAccess.getRunnableMetricValues(List.of("time"), true, true));
                    this.view2ResultRowDataProvider.put(Messages.DBViewer_eventChainTimeMetricsTitle, dbAccess.getEventChainMetricValues(List.of("time")));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception exception) {
                MessageDialog.openError((Shell)site.getShell(), (String)Messages.DBViewer_fileErrorTitle, (String)String.format(Messages.DBViewer_fileErrorMessage, fei.getName()));
            }
        }
    }

    public void createPartControl(Composite parent) {
        this.cTabFolder = new CTabFolder(parent, 0x800400);
        for (Map.Entry<String, DBResultRowDataProvider> entry : this.view2ResultRowDataProvider.entrySet()) {
            CTabItem item = new CTabItem(this.cTabFolder, 0);
            item.setText(entry.getKey());
            SpanningDataLayer spanningDataLayer = new SpanningDataLayer((ISpanningDataProvider)entry.getValue());
            RowGroupExpandCollapseLayer rowExpandCollapseLayer = new RowGroupExpandCollapseLayer((IUniqueIndexLayer)spanningDataLayer, (DataLayer)spanningDataLayer, entry){
                private final /* synthetic */ DataLayer val$spanningDataLayer;
                private final /* synthetic */ Map.Entry val$entry;
                {
                    this.val$spanningDataLayer = dataLayer;
                    this.val$entry = entry;
                    super($anonymous0);
                }

                public ILayerCell getCellByPosition(int columnPosition, int rowPosition) {
                    int underlyingColumnPosition = this.localToUnderlyingColumnPosition(columnPosition);
                    int underlyingRowPosition = this.localToUnderlyingRowPosition(rowPosition);
                    if (underlyingColumnPosition < 0 || underlyingColumnPosition >= this.val$spanningDataLayer.getColumnCount() || underlyingRowPosition < 0 || underlyingRowPosition >= this.val$spanningDataLayer.getRowCount()) {
                        return null;
                    }
                    DataCell dataCell = ((DBResultRowDataProvider)this.val$entry.getValue()).getCellByPosition(underlyingColumnPosition, underlyingRowPosition);
                    int dCRowPos = dataCell.getRowPosition();
                    int dCRowSp = dataCell.getRowSpan();
                    int actualRowSpan = dCRowSp - (int)IntStream.range(1, dCRowSp).filter(i -> this.isRowIndexHidden(dCRowPos + i)).count();
                    LayerCell cell = new LayerCell((ILayer)this.val$spanningDataLayer, underlyingColumnPosition, underlyingRowPosition, dataCell = new DataCell(dataCell.getColumnPosition(), dCRowPos, dataCell.getColumnSpan(), actualRowSpan));
                    if (cell != null) {
                        cell = new TranslatedLayerCell((ILayerCell)cell, (ILayer)this, this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getOriginColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getOriginRowPosition()), this.underlyingToLocalColumnPosition(this.underlyingLayer, cell.getColumnPosition()), this.underlyingToLocalRowPosition(this.underlyingLayer, cell.getRowPosition()));
                    }
                    return cell;
                }
            };
            SelectionLayer selectionLayer = new SelectionLayer((IUniqueIndexLayer)rowExpandCollapseLayer);
            ViewportLayer viewportLayer = new ViewportLayer((IUniqueIndexLayer)selectionLayer);
            DefaultColumnHeaderDataLayer columnHeaderDataLayer = new DefaultColumnHeaderDataLayer(entry.getValue().getColumnHeaderDataProvider());
            ColumnHeaderLayer columnHeaderLayer = new ColumnHeaderLayer((IUniqueIndexLayer)columnHeaderDataLayer, (ILayer)viewportLayer, selectionLayer);
            DefaultRowHeaderDataLayer rowHeaderDataLayer = new DefaultRowHeaderDataLayer(entry.getValue().getRowHeaderDataProvider());
            RowHeaderLayer rowHeaderLayer = new RowHeaderLayer((IUniqueIndexLayer)rowHeaderDataLayer, (ILayer)viewportLayer, selectionLayer, false);
            rowHeaderLayer.addConfiguration((IConfiguration)new RowHeaderConfiguration());
            RowGroupHeaderLayer rowGroupHeaderLayer = new RowGroupHeaderLayer((ILayer)rowHeaderLayer, selectionLayer, false);
            rowGroupHeaderLayer.addConfiguration((IConfiguration)new DefaultRowGroupHeaderLayerConfiguration(true));
            rowGroupHeaderLayer.setColumnWidth(20);
            entry.getValue().initializeGroups(rowGroupHeaderLayer);
            DefaultCornerDataProvider cornerDataProvider = new DefaultCornerDataProvider(entry.getValue().getColumnHeaderDataProvider(), entry.getValue().getRowHeaderDataProvider());
            CornerLayer cornerLayer = new CornerLayer((IUniqueIndexLayer)new DataLayer((IDataProvider)cornerDataProvider), (ILayer)rowGroupHeaderLayer, (ILayer)columnHeaderLayer);
            GridLayer gridLayer = new GridLayer((ILayer)viewportLayer, (ILayer)columnHeaderLayer, (ILayer)rowGroupHeaderLayer, (ILayer)cornerLayer);
            NatTable natTable = new NatTable((Composite)this.cTabFolder, (ILayer)gridLayer, false);
            natTable.addConfiguration((IConfiguration)new DefaultNatTableStyleConfiguration());
            natTable.addConfiguration((IConfiguration)new HeaderMenuConfiguration(natTable));
            natTable.configure();
            natTable.setTheme((ThemeConfiguration)new ModernNatTableThemeConfiguration());
            item.setControl((Control)natTable);
        }
    }

    public void setFocus() {
        if (this.cTabFolder != null) {
            this.cTabFolder.forceFocus();
        }
    }

    private static class RowHeaderConfiguration
    extends DefaultRowHeaderLayerConfiguration {
        private RowHeaderConfiguration() {
        }

        protected void addRowHeaderUIBindings() {
        }
    }
}

