/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.visualizations.javafx;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javafx.embed.swt.FXCanvas;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.Button;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javax.annotation.PostConstruct;
import org.eclipse.app4mc.amalthea.model.Label;
import org.eclipse.app4mc.amalthea.model.Runnable;
import org.eclipse.app4mc.amalthea.model.SWModel;
import org.eclipse.app4mc.amalthea.visualizations.javafx.util.ArrowPainter;
import org.eclipse.app4mc.amalthea.visualizations.javafx.util.RunnableHelper;
import org.eclipse.app4mc.amalthea.visualizations.javafx.util.RunnablePainter;
import org.eclipse.app4mc.visualization.ui.VisualizationParameters;
import org.eclipse.app4mc.visualization.ui.registry.Visualization;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.service.component.annotations.Component;

@Component(property={"name=Runnable Label Dependencies", "description=Visualize Runnable Label Dependencies"})
public class RunnableDependencyVisualization
implements Visualization {
    private ArrowPainter arrowPainter = new ArrowPainter();

    @PostConstruct
    public void createVisualization(Runnable runnable, VisualizationParameters parameters, Composite parent, IEventBroker broker) {
        if (runnable.eContainer() instanceof SWModel) {
            parent.setLayout((Layout)new GridLayout());
            FXCanvas fxCanvas = new FXCanvas(parent, 0);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)fxCanvas);
            BorderPane layout = new BorderPane();
            layout.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, null, null)}));
            Scene scene = new Scene((Parent)layout);
            fxCanvas.setScene(scene);
            List<Runnable> runnables = RunnableHelper.getRunnableDependencies((SWModel)runnable.eContainer(), runnable, false);
            int indexOfSelected = runnables.indexOf(runnable);
            List<RunnablePainter> painters = runnables.stream().map(r -> new RunnablePainter((Runnable)r, false)).collect(Collectors.toList());
            List<RunnablePainter> readPainter = painters.subList(0, indexOfSelected);
            RunnablePainter selectedPainter = (RunnablePainter)painters.get(indexOfSelected);
            List<RunnablePainter> writePainter = indexOfSelected < painters.size() - 1 ? painters.subList(indexOfSelected + 1, painters.size()) : Collections.emptyList();
            double[] columnWidths = RunnableDependencyVisualization.calculateColumnWidths(readPainter, selectedPainter, writePainter);
            double[] rowHeights = RunnableDependencyVisualization.calculateRowHeights(readPainter, selectedPainter, writePainter);
            double minWidth = Arrays.stream(columnWidths).sum();
            double minHeight = Arrays.stream(rowHeights).sum();
            double max = Math.max(minWidth, minHeight);
            double maxFactor = 6000.0 / max;
            painters.forEach(p -> p.setMaxScaleFactor(maxFactor));
            RunnableHelper.setInitialScaleFactor(painters, parameters);
            Button zoomIn = new Button("+");
            zoomIn.setPrefSize(40.0, 40.0);
            Button zoomOut = new Button("-");
            zoomOut.setPrefSize(40.0, 40.0);
            zoomIn.setOnAction(event -> {
                if (!zoomIn.isDisabled()) {
                    painters.forEach(RunnablePainter::zoomIn);
                    double scaleFactor = ((RunnablePainter)painters.get(0)).getScaleFactor();
                    RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                    if (scaleFactor >= ((RunnablePainter)painters.get(0)).getMaxScaleFactor()) {
                        zoomIn.setDisable(true);
                    }
                    if (zoomOut.isDisabled()) {
                        zoomOut.setDisable(false);
                    }
                }
                parent.redraw();
            });
            zoomOut.setOnAction(event -> {
                if (!zoomOut.isDisabled()) {
                    painters.forEach(RunnablePainter::zoomOut);
                    double scaleFactor = ((RunnablePainter)painters.get(0)).getScaleFactor();
                    RunnableHelper.persistScaleFactor(scaleFactor, parameters);
                    if (scaleFactor <= 0.1) {
                        zoomOut.setDisable(true);
                    }
                    if (zoomIn.isDisabled()) {
                        zoomIn.setDisable(false);
                    }
                }
                parent.redraw();
            });
            VBox vBox = new VBox(5.0);
            vBox.setPadding(new Insets(5.0));
            vBox.getChildren().addAll((Object[])new Node[]{zoomIn, zoomOut});
            layout.setLeft((Node)vBox);
            if (!painters.isEmpty()) {
                if (painters.get(0).getScaleFactor() >= painters.get(0).getMaxScaleFactor()) {
                    zoomIn.setDisable(true);
                }
                if (painters.get(0).getScaleFactor() <= 0.1) {
                    zoomOut.setDisable(true);
                }
            }
            Canvas canvas = new Canvas();
            ScrollPane scrollable = new ScrollPane();
            scrollable.setPadding(new Insets(0.0));
            scrollable.setStyle("-fx-background: rgb(255,255,255);\n -fx-background-color: rgb(255,255,255)");
            scrollable.setContent((Node)canvas);
            layout.setCenter((Node)scrollable);
            canvas.setOnMouseClicked(event -> {
                for (RunnablePainter p : painters) {
                    if (p.equals(selectedPainter) || !p.getRunnableRectangle().contains(event.getX(), event.getY())) continue;
                    HashMap<String, List<Runnable>> data = new HashMap<String, List<Runnable>>();
                    data.put("modelElements", Arrays.asList(p.getRunnable()));
                    broker.send("org/eclipse/app4mc/amalthea/editor/SELECT", data);
                }
            });
            canvas.setOnScroll(event -> {
                if (event.isControlDown()) {
                    double deltaY = event.getDeltaY();
                    if (deltaY < 0.0) {
                        zoomOut.fire();
                    } else {
                        zoomIn.fire();
                    }
                    event.consume();
                }
            });
            canvas.setOnMouseMoved(event -> {
                Point2D screenToLocal = canvas.screenToLocal(event.getScreenX(), event.getScreenY());
                double x = screenToLocal.getX();
                double y = screenToLocal.getY();
                boolean activate = false;
                for (RunnablePainter p : painters) {
                    if (p.equals(selectedPainter) || !p.getRunnableRectangle().contains(x, y)) continue;
                    activate = true;
                    break;
                }
                if (activate) {
                    scene.setCursor(Cursor.HAND);
                } else {
                    scene.setCursor(Cursor.DEFAULT);
                }
            });
            GraphicsContext gc = canvas.getGraphicsContext2D();
            parent.addPaintListener(e -> {
                double parentBoundsHeight;
                org.eclipse.swt.graphics.Rectangle parentBounds = parent.getBounds();
                double[] scaledColumnWidths = Arrays.stream(columnWidths).map(width -> width * selectedPainter.getScaleFactor()).toArray();
                double[] scaledRowHeights = Arrays.stream(rowHeights).map(height -> height * selectedPainter.getScaleFactor()).toArray();
                double minWidth1 = Arrays.stream(scaledColumnWidths).sum();
                double minHeight1 = Arrays.stream(scaledRowHeights).sum();
                double canvasWidth = minWidth1;
                double canvasHeight = minHeight1;
                double parentBoundsWidth = (double)parentBounds.width - 30.0 - vBox.getWidth();
                if (parentBoundsWidth > minWidth1) {
                    canvasWidth = parentBoundsWidth;
                }
                if ((parentBoundsHeight = (double)parentBounds.height - 30.0) > minHeight1) {
                    canvasHeight = parentBoundsHeight;
                }
                canvasWidth = Math.min(6000.0, canvasWidth);
                canvasHeight = Math.min(6000.0, canvasHeight);
                canvas.setWidth(canvasWidth);
                canvas.setHeight(canvasHeight);
                gc.clearRect(0.0, 0.0, canvasWidth, canvasHeight);
                double xStart = parentBounds.x;
                double yStart = parentBounds.y;
                Rectangle bounds = null;
                int row = 0;
                int column = 0;
                for (RunnablePainter p1 : readPainter) {
                    bounds = new Rectangle(Double.valueOf(xStart).doubleValue(), Double.valueOf(yStart).doubleValue(), scaledColumnWidths[column], scaledRowHeights[row]);
                    p1.paint(gc, bounds);
                    yStart += scaledRowHeights[row];
                    ++row;
                }
                xStart = (double)parentBounds.x + scaledColumnWidths[0];
                yStart = parentBounds.y;
                selectedPainter.setRunnableHeaderFontFill(Color.WHITE);
                selectedPainter.setRunnableColor(Color.GREEN);
                row = 0;
                column = 1;
                bounds = new Rectangle(Double.valueOf(xStart).doubleValue(), Double.valueOf(yStart).doubleValue(), scaledColumnWidths[column], scaledRowHeights[row]);
                selectedPainter.paint(gc, bounds);
                xStart = (double)parentBounds.x + scaledColumnWidths[0] + scaledColumnWidths[1];
                yStart = parentBounds.y;
                row = 0;
                column = 2;
                for (RunnablePainter p2 : writePainter) {
                    bounds = new Rectangle(Double.valueOf(xStart).doubleValue(), Double.valueOf(yStart).doubleValue(), scaledColumnWidths[column], scaledRowHeights[row]);
                    p2.paint(gc, bounds);
                    yStart += scaledRowHeights[row];
                    ++row;
                }
                for (RunnablePainter rp : painters) {
                    Map<Label, Rectangle> writeRectangles = rp.getWriteRectangles();
                    writeRectangles.entrySet().forEach(entry -> {
                        for (RunnablePainter rp2 : painters) {
                            Rectangle readRect = rp2.getReadRectangle((Label)entry.getKey());
                            if (readRect == null) continue;
                            Rectangle writeRect = (Rectangle)entry.getValue();
                            double startX = writeRect.getX() + writeRect.getWidth();
                            double startY = writeRect.getY() + writeRect.getHeight() / 10.0 * 9.0;
                            double endX = readRect.getX();
                            double endY = readRect.getY() + readRect.getHeight() / 10.0 * 9.0;
                            this.arrowPainter.paint(gc, startX, startY, endX, endY);
                        }
                    });
                }
            });
        }
    }

    private static double[] calculateColumnWidths(List<RunnablePainter> readPainter, RunnablePainter selectedPainter, List<RunnablePainter> writePainter) {
        double[] widths = new double[]{0.0, 0.0, 0.0};
        for (RunnablePainter runnablePainter : readPainter) {
            widths[0] = Math.max(widths[0], runnablePainter.getPreferredMinimumWidth());
        }
        widths[1] = selectedPainter.getPreferredMinimumWidth();
        for (RunnablePainter runnablePainter : writePainter) {
            widths[2] = Math.max(widths[2], runnablePainter.getPreferredMinimumWidth());
        }
        return widths;
    }

    private static double[] calculateRowHeights(List<RunnablePainter> readPainter, RunnablePainter selectedPainter, List<RunnablePainter> writePainter) {
        int rowCount = Math.max(readPainter.size(), writePainter.size());
        if (rowCount == 0) {
            rowCount = 1;
        }
        double[] heights = new double[rowCount];
        int row = 0;
        while (row < rowCount) {
            double height = 0.0;
            if (readPainter.size() > row) {
                height = Math.max(height, readPainter.get(row).getPreferredMinimumHeight());
            }
            if (row == 0) {
                height = Math.max(height, selectedPainter.getPreferredMinimumHeight());
            }
            if (writePainter.size() > row) {
                height = Math.max(height, writePainter.get(row).getPreferredMinimumHeight());
            }
            heights[row] = height;
            ++row;
        }
        return heights;
    }
}

