/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea._import.atdb;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.app4mc.amalthea._import.atdb.AConverter;
import org.eclipse.app4mc.amalthea._import.atdb.AmaltheaModelUtil;
import org.eclipse.app4mc.amalthea.model.Amalthea;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.Event;
import org.eclipse.app4mc.amalthea.model.EventModel;
import org.eclipse.app4mc.amalthea.model.IReferable;
import org.eclipse.app4mc.amalthea.model.util.ModelUtil;
import org.eclipse.app4mc.atdb.ATDBConnection;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class EventConverter
extends AConverter {
    private final Map<ThrowingSupplier<List<String>, SQLException>, EClass> eventSupplier2EClass = new LinkedHashMap<ThrowingSupplier<List<String>, SQLException>, EClass>();
    private static final Map<EClass, EReference> eClass2SourceReference = new LinkedHashMap<EClass, EReference>();

    static {
        eClass2SourceReference.put(AmaltheaPackage.eINSTANCE.getRunnableEvent(), AmaltheaPackage.eINSTANCE.getRunnableEvent_Process());
        eClass2SourceReference.put(AmaltheaPackage.eINSTANCE.getProcessEvent(), AmaltheaPackage.eINSTANCE.getProcessEvent_ProcessingUnit());
        eClass2SourceReference.put(AmaltheaPackage.eINSTANCE.getLabelEvent(), AmaltheaPackage.eINSTANCE.getLabelEvent_Runnable());
    }

    public EventConverter(Amalthea model, ATDBConnection con) {
        super(model, con, "events");
        this.eventSupplier2EClass.put(() -> ((ATDBConnection)this.con).getAllRunnableEvents(), AmaltheaPackage.eINSTANCE.getRunnableEvent());
        this.eventSupplier2EClass.put(() -> ((ATDBConnection)this.con).getAllProcessEvents(), AmaltheaPackage.eINSTANCE.getProcessEvent());
        this.eventSupplier2EClass.put(() -> ((ATDBConnection)this.con).getAllLabelEvents(), AmaltheaPackage.eINSTANCE.getLabelEvent());
        this.eventSupplier2EClass.put(() -> ((ATDBConnection)this.con).getAllStimulusEvents(), AmaltheaPackage.eINSTANCE.getStimulusEvent());
    }

    @Override
    protected void execute() throws SQLException {
        EventModel evModel = ModelUtil.getOrCreateEventModel((Amalthea)this.model);
        ArrayList events = new ArrayList();
        for (Map.Entry<ThrowingSupplier<List<String>, SQLException>, EClass> evSup2ECl : this.eventSupplier2EClass.entrySet()) {
            evSup2ECl.getKey().get().forEach(eventName -> {
                boolean bl = events.add(AmaltheaModelUtil.getOrAddNew((EObject)evModel, AmaltheaPackage.eINSTANCE.getEventModel_Events(), eventName, Event.class, (EClass)evSup2ECl.getValue()));
            });
        }
        for (Event event : events) {
            this.updateEventType(event);
            this.updateEntity(event);
            this.updateSourceEntity(event);
        }
    }

    private void updateEventType(Event event) throws SQLException {
        EStructuralFeature eventTypeESF = event.eClass().getEStructuralFeature("eventType");
        String eventType = this.con.getEventTypeForEvent(event.getName());
        Optional<Enumerator> eventTypeEnumLiteral = AmaltheaModelUtil.getEnumLiteralByNameForFeature(eventType, eventTypeESF);
        eventTypeEnumLiteral.ifPresent(eLiteral -> event.eSet(eventTypeESF, eLiteral));
    }

    private void updateEntity(Event event) throws SQLException {
        EReference eventEntityESF = (EReference)event.eClass().getEStructuralFeature("entity");
        String entityName = this.con.getEntityForEvent(event.getName());
        AmaltheaModelUtil.getOrAddNew((EObject)event, eventEntityESF, entityName, IReferable.class);
    }

    private void updateSourceEntity(Event event) throws SQLException {
        String sourceEntityName = this.con.getSourceEntityForEvent(event.getName());
        if (sourceEntityName.length() == 0) {
            return;
        }
        if (eClass2SourceReference.containsKey(event.eClass())) {
            AmaltheaModelUtil.getOrAddNew((EObject)event, eClass2SourceReference.get(event.eClass()), sourceEntityName, IReferable.class);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T, E extends Exception> {
        public T get() throws E;
    }
}

