/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.converters093.impl;

import java.io.File;
import java.util.List;
import java.util.Map;
import org.eclipse.app4mc.amalthea.converters.common.base.ICache;
import org.eclipse.app4mc.amalthea.converters.common.base.IConverter;
import org.eclipse.app4mc.amalthea.converters.common.converter.AbstractConverter;
import org.eclipse.app4mc.amalthea.converters.common.utils.AmaltheaNamespaceRegistry;
import org.eclipse.app4mc.amalthea.converters.common.utils.HelperUtil;
import org.eclipse.app4mc.amalthea.converters.common.utils.ModelVersion;
import org.eclipse.app4mc.amalthea.converters093.utils.HelperUtils_092_093;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(property={"input_model_version=0.9.2", "output_model_version=0.9.3"}, service={IConverter.class})
public class OsConverter
extends AbstractConverter {
    private static final String AM = "am";
    private static final String XSI = "xsi";
    private static final String TYPE = "type";
    private static final String VALUE = "value";
    private static final String AMLT_PREFIX = "amlt://#";
    private static final Logger LOGGER = LoggerFactory.getLogger(OsConverter.class);

    @Activate
    protected void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    public void convert(File targetFile, Map<File, Document> filename2documentMap, List<ICache> caches) {
        LOGGER.info("Migration from 0.9.2 to 0.9.3 : Executing Os converter for model file : {}", (Object)targetFile.getName());
        Document root = filename2documentMap.get(targetFile);
        if (root == null) {
            return;
        }
        Element rootElement = root.getRootElement();
        this.updateOsOverheadRef(rootElement);
        this.updateOsAPIInstructionsAndOsISRInstructions(rootElement);
    }

    private void updateOsOverheadRef(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/operatingSystems");
        List operatingSystems = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element operatingSystemElement : operatingSystems) {
            String overHead_Element_Name = HelperUtil.getSingleElementNameFromAttributeOrChildeElement((String)"overhead", (Element)operatingSystemElement);
            operatingSystemElement.removeAttribute("overhead");
            operatingSystemElement.removeChild("overhead");
            if (overHead_Element_Name == null) continue;
            Element osOverHeadRefElement = new Element("overhead");
            Attribute hrefAttribute = new Attribute("href", AMLT_PREFIX + overHead_Element_Name + "?type=OsOverhead");
            osOverHeadRefElement.setAttribute(hrefAttribute);
            operatingSystemElement.addContent((Content)osOverHeadRefElement);
        }
    }

    private void updateOsAPIInstructionsAndOsISRInstructions(Element rootElement) {
        StringBuilder xpathBuffer = new StringBuilder();
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSendMessage");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiTerminateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSchedule");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiRequestResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiReleaseResource");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSetEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiWaitEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiClearEvent");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiActivateTask");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiEnforcedMigration");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSuspendOsInterrupts");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiResumeOsInterrupts");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiRequestSpinlock");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiReleaseSpinlock");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSenderReceiverRead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSenderReceiverWrite");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiSynchronousServerCallPoint");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiIocRead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/apiOverhead/apiIocWrite");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory1Overhead/postExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/preExecutionOverhead");
        xpathBuffer.append("|");
        xpathBuffer.append("./osModel/osOverheads/isrCategory2Overhead/postExecutionOverhead");
        List osInstructionsSubElements = HelperUtil.getXpathResult((Element)rootElement, (String)xpathBuffer.toString(), Element.class, (Namespace[])new Namespace[]{AmaltheaNamespaceRegistry.getNamespace((ModelVersion)ModelVersion._093, (String)AM), AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)});
        for (Element osInstructionsSubElement : osInstructionsSubElements) {
            Element deviationElement;
            String typeAttributeValue = osInstructionsSubElement.getAttributeValue(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            String value = osInstructionsSubElement.getAttributeValue(VALUE);
            osInstructionsSubElement.removeAttribute(TYPE, AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI));
            osInstructionsSubElement.removeAttribute(VALUE);
            osInstructionsSubElement.removeChild("fetchStatistic");
            if (typeAttributeValue.equals("am:InstructionsConstant")) {
                Element defaultElement = new Element("default");
                defaultElement.setAttribute(new Attribute(TYPE, "am:DiscreteValueConstant", AmaltheaNamespaceRegistry.getGenericNamespace((String)XSI)));
                defaultElement.setAttribute(VALUE, value != null ? value : "0");
                osInstructionsSubElement.addContent((Content)defaultElement);
                continue;
            }
            if (!typeAttributeValue.equals("am:InstructionsDeviation") || (deviationElement = osInstructionsSubElement.getChild("deviation")) == null) continue;
            Element migratedElement = HelperUtils_092_093.migrateDeviationElementContainingLongValue(deviationElement, "default", 1.0);
            osInstructionsSubElement.removeContent((Content)deviationElement);
            if (migratedElement == null) continue;
            osInstructionsSubElement.addContent((Content)migratedElement);
        }
    }
}

