/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Arrays;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.graphics3d.Graphics3D;
import org.eclipse.draw3d.graphics3d.Graphics3DDescriptor;
import org.eclipse.draw3d.graphics3d.Graphics3DRegistry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.widgets.Display;

public class Export3DOperation {
    final IFigure3D rootFigure;
    final String rendererID;
    final String exportfilename;

    public Export3DOperation(String i_exportfilename, String i_rendererID, IFigure3D i_rootFigure) {
        this.exportfilename = i_exportfilename;
        this.rendererID = i_rendererID;
        this.rootFigure = i_rootFigure;
    }

    public void run() {
        RenderContext renderContext = this.rootFigure.getRenderContext();
        Graphics3D g3dSave = renderContext.getGraphics3D();
        try {
            Graphics3DDescriptor descr = Graphics3DRegistry.getRenderer((String)this.rendererID);
            Graphics3D g3dExport = descr.createInstance(null);
            g3dExport.setProperty("exportfile", this.exportfilename);
            renderContext.setGraphics3D(g3dExport);
            Graphics dummy = this.createDummyGraphics();
            this.rootFigure.invalidateTree();
            this.rootFigure.paint(dummy);
        }
        finally {
            renderContext.setGraphics3D(g3dSave);
        }
    }

    private Graphics createDummyGraphics() {
        int width = 100;
        int height = 100;
        int size = width * height;
        int alpha = 255;
        byte[] data = new byte[size * 3];
        PaletteData pal = new PaletteData(0xFF0000, 65280, 255);
        ImageData imageData = new ImageData(width, height, 24, pal, 1, data);
        imageData.alphaData = new byte[size];
        Arrays.fill(imageData.alphaData, (byte)alpha);
        Image image = new Image((Device)Display.getCurrent(), imageData);
        GC gc = new GC((Drawable)image);
        SWTGraphics dummyGraphics = new SWTGraphics(gc);
        return dummyGraphics;
    }
}

