/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.gen.ide;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.amp.amf.gen.ide.PluginProjectWizard;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.xtext.generator.MergeableManifest;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginTemplateProjectWizard
extends PluginProjectWizard
implements IExecutableExtension {
    public static final String CONF_EXTPOINT_ID = "org.eclipse.amp.amf.gen.ide.newProjectWizardConfigurations";
    private IConfigurationElement wizardConfiguration;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        this.wizardConfiguration = config;
    }

    public String getId() {
        return this.wizardConfiguration.getAttribute("id");
    }

    @Override
    public void createFiles() throws CoreException, IOException {
        try {
            this.createManifest();
            this.copyProperties();
        }
        finally {
            this.getProject().refreshLocal(2, null);
        }
    }

    private void createManifest() throws IOException, CoreException, FileNotFoundException {
        Manifest original = new Manifest(this.openStream(this.getPluginID(), "META-INF/MANIFEST.MF"));
        String manifestVersion = original.getMainAttributes().getValue(Attributes.Name.MANIFEST_VERSION);
        String bundleManifestVersion = original.getMainAttributes().getValue("Bundle-ManifestVersion");
        String bundleVersion = original.getMainAttributes().getValue(MergeableManifest.BUNDLE_VERSION);
        String jre = original.getMainAttributes().getValue(MergeableManifest.BUNDLE_REQUIRED_EXECUTION_ENV);
        MergeableManifest manifest = new MergeableManifest((InputStream)new ByteArrayInputStream(new byte[0]));
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, manifestVersion);
        manifest.getMainAttributes().put(new Attributes.Name("Bundle-ManifestVersion"), bundleManifestVersion);
        manifest.getMainAttributes().put(MergeableManifest.BUNDLE_NAME, this.getProject().getName());
        manifest.getMainAttributes().put(MergeableManifest.BUNDLE_SYMBOLIC_NAME, this.getProject().getName());
        manifest.getMainAttributes().put(MergeableManifest.BUNDLE_VERSION, bundleVersion);
        manifest.getMainAttributes().put(MergeableManifest.BUNDLE_REQUIRED_EXECUTION_ENV, jre);
        manifest.addRequiredBundles(this.getDependenciesForManifest());
        manifest.addImportedPackages(this.getImportsForManifest());
        IFolder metaInfFolder = this.getProject().getFolder("META-INF");
        metaInfFolder.create(true, true, null);
        IPath targetFile = metaInfFolder.getFile("MANIFEST.MF").getRawLocation();
        FileOutputStream out = new FileOutputStream(targetFile.toFile());
        try {
            manifest.write((OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    private void copyProperties() throws CoreException {
        InputStream original = this.openStream(this.getPluginID(), "res/build_template.properties");
        IFile target = this.getProject().getFile("build.properties");
        target.create(original, true, null);
    }

    public InputStream openStream(String pluginID, String path) {
        try {
            Bundle bundle = Platform.getBundle((String)pluginID);
            URL entry = bundle.getEntry(path);
            if (entry == null) {
                throw new RuntimeException("No resource:" + path + " found in plugin: " + pluginID);
            }
            return entry.openStream();
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't load project resource from plugin.", e);
        }
    }

    @Override
    public List<String> getBuilders() {
        List<String> builderIDs = super.getBuilders();
        builderIDs.add("org.eclipse.amp.amf.gen.ide.docBuilder");
        builderIDs.addAll(this.findBuilderIdsForWizard(this.getId()));
        return builderIDs;
    }

    @Override
    public List<String> getNatures() {
        List<String> natures = super.getNatures();
        natures.add("org.eclipse.pde.PluginNature");
        return natures;
    }

    @Override
    public String getSourceDirName() {
        return "srcgen";
    }

    public Set<String> getImportsForManifest() {
        return this.findImportedPackages(this.getId());
    }

    public Set<String> getDependenciesForManifest() {
        return this.findRequiredBundles(this.getId());
    }

    public HashSet<String> findBuilderIdsForWizard(String wizardId) {
        return this.findAttributes(wizardId, "builder", "builderID");
    }

    public HashSet<String> findRequiredBundles(String wizardId) {
        return this.findAttributes(wizardId, "dependency", "requiredBundleID");
    }

    public HashSet<String> findImportedPackages(String wizardId) {
        return this.findAttributes(wizardId, "import", "package");
    }

    private HashSet<String> findAttributes(String wizardId, String elementName, String attributeName) {
        IConfigurationElement[] configs;
        HashSet<String> attributes = new HashSet<String>();
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor(CONF_EXTPOINT_ID);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (wizardId != null && wizardId.equals(config.getAttribute("newWizardID"))) {
                IConfigurationElement[] iConfigurationElementArray2 = config.getChildren(elementName);
                int n3 = iConfigurationElementArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray2[n4];
                    attributes.add(element.getAttribute(attributeName));
                    ++n4;
                }
            }
            ++n2;
        }
        return attributes;
    }
}

