/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.tests;

import java.io.File;
import junit.framework.TestCase;
import junit.textui.TestRunner;
import org.metaabm.MetaABMFactory;
import org.metaabm.SContext;
import org.metaabm.SImplementation;
import org.metaabm.SImplemented;
import org.metaabm.impl.SImplementationImpl;

public class SImplementationTest
extends TestCase {
    protected SImplementation fixture = null;
    private SContext parentContext;
    private SImplementation parentImpl;
    private SContext agent;

    public static void main(String[] args) {
        TestRunner.run(SImplementationTest.class);
    }

    public SImplementationTest(String name) {
        super(name);
    }

    protected void setFixture(SImplementation fixture) {
        this.fixture = fixture;
    }

    protected SImplementation getFixture() {
        return this.fixture;
    }

    protected void setUp() throws Exception {
        this.setFixture(MetaABMFactory.eINSTANCE.createSImplementation());
        this.agent = MetaABMFactory.eINSTANCE.createSContext();
        this.agent.setImplementation(this.fixture);
        this.parentContext = MetaABMFactory.eINSTANCE.createSContext();
        this.parentContext.getAgents().add((Object)this.agent);
        this.parentImpl = MetaABMFactory.eINSTANCE.createSImplementation();
        this.parentContext.setImplementation(this.parentImpl);
        this.fixture.setClassName("SomeClass");
        this.parentImpl.setTarget((SImplemented)this.parentContext);
        this.parentImpl.setBasePath("../someBase");
        this.parentImpl.setBinDir("bin");
        this.parentImpl.setSrcDir("src");
        this.parentImpl.setPackage("org.someorg");
    }

    protected void tearDown() throws Exception {
        this.setFixture(null);
    }

    public void testGetClassName() {
        SImplementationTest.assertEquals((String)this.fixture.getClassName(), (String)"SomeClass");
    }

    public void testSetClassName() {
        this.fixture.setClassName("SomeClass");
    }

    public void testGetQualifiedName() {
        SImplementationTest.assertEquals((String)this.fixture.getQualifiedName(), (String)"org.someorg.SomeClass");
    }

    public void testGetDerivedPath() {
        SImplementationTest.assertEquals((String)this.fixture.getDerivedPath(), (String)"../someBase");
        this.fixture.setPackage("org.someother");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedPackage(), (String)"org.someother");
    }

    public void testGetDerivedPackage() {
        SImplementationTest.assertEquals((String)this.fixture.getDerivedPackage(), (String)"org.someorg");
        this.fixture.setPackage("org.someother");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedPackage(), (String)"org.someother");
    }

    public void testGetJavaFileLoc() {
        SImplementationTest.assertEquals((String)this.fixture.getJavaFileLoc(), (String)"../someBase/srcgen/org/someorg/SomeClass.java");
        this.fixture.setBasePath("/Hello");
        this.fixture.setPackage("org.someother");
        SImplementationTest.assertEquals((String)this.fixture.getJavaFileLoc(), (String)"/Hello/srcgen/org/someother/SomeClass.java");
    }

    public void testGetClassFileLoc() {
        SImplementationTest.assertEquals((String)this.fixture.getClassFileLoc(), (String)"../someBase/bin/org/someorg/SomeClass.class");
        this.fixture.setBasePath("/Hello");
        this.fixture.setPackage("org.someother");
        SImplementationTest.assertEquals((String)this.fixture.getClassFileLoc(), (String)"/Hello/bin/org/someother/SomeClass.class");
    }

    public void testGetDerivedBinDir() throws Exception {
        SImplementationTest.assertEquals((String)this.fixture.getBinDir(), (String)"bin");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedBinDir(), (String)"bin");
        this.parentContext.getImplementation().setBinDir("lib");
        this.fixture.setBinDir(null);
        SImplementationTest.assertEquals((String)this.fixture.getDerivedBinDir(), (String)"lib");
        this.fixture.setBinDir("bin2");
        SImplementationTest.assertEquals((String)this.fixture.getBinDir(), (String)"bin2");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedBinDir(), (String)"bin2");
    }

    public void testGetDerivedSrcDir() {
        SImplementationTest.assertEquals((String)this.fixture.getSrcDir(), (String)"srcgen");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedSrcDir(), (String)"srcgen");
        this.parentContext.getImplementation().setSrcDir("src");
        this.fixture.setSrcDir(null);
        SImplementationTest.assertEquals((String)this.fixture.getDerivedSrcDir(), (String)"src");
        this.fixture.setSrcDir("src2");
        SImplementationTest.assertEquals((String)this.fixture.getDerivedSrcDir(), (String)"src2");
    }

    public void testLookup() {
        char sc = File.separatorChar;
        SImplementationTest.assertEquals((String)SImplementationImpl.addDir((String)"", (String)""), (String)"");
        SImplementationTest.assertEquals((String)SImplementationImpl.addDir((String)"a", (String)""), (String)"a");
        SImplementationTest.assertEquals((String)SImplementationImpl.addDir((String)"", (String)"b"), (String)"b");
        SImplementationTest.assertEquals((String)SImplementationImpl.addDir((String)"a", (String)"b"), (String)("a" + sc + "b"));
        this.parentImpl.setClassName("Foo");
        this.parentImpl.setPackage("com.blah");
        this.parentImpl.setBasePath("/Some/path");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getQualifiedName(), (String)"com.blah.Foo");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getDerivedPath(), (String)"/Some/path");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getJavaFileLoc(), (String)("/Some/path" + sc + "src" + sc + "com" + sc + "blah" + sc + "Foo.java"));
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getClassFileLoc(), (String)("/Some/path" + sc + "bin" + sc + "com" + sc + "blah" + sc + "Foo.class"));
        this.parentImpl.setPackage("");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getClassFileLoc(), (String)("/Some/path" + sc + "bin" + sc + "Foo.class"));
        this.parentImpl.setPackage("com.foo");
        this.parentImpl.setBasePath("");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getClassFileLoc(), (String)("bin" + sc + "com" + sc + "foo" + sc + "Foo.class"));
        this.parentImpl.setBinDir("");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getClassFileLoc(), (String)("com" + sc + "foo" + sc + "Foo.class"));
        this.parentImpl.setSrcDir("");
        this.parentImpl.setBasePath("/Some/Other");
        SImplementationTest.assertEquals((String)this.parentContext.getImplementation().getJavaFileLoc(), (String)("/Some/Other" + sc + "com" + sc + "foo" + sc + "Foo.java"));
        this.agent.getImplementation().setClassName("Bar");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getQualifiedName(), (String)"com.foo.Bar");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getDerivedPath(), (String)"/Some/Other");
        this.agent.getImplementation().setPackage("com.blah2");
        this.agent.getImplementation().setBasePath("/Some/other");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getQualifiedName(), (String)"com.blah2.Bar");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getDerivedPath(), (String)"/Some/other");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getJavaFileLoc(), (String)("/Some/other" + sc + "srcgen" + sc + "com" + sc + "blah2" + sc + "Bar.java"));
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getClassFileLoc(), (String)("/Some/other/bin" + sc + "com" + sc + "blah2" + sc + "Bar.class"));
        this.agent.getImplementation().setPackage(null);
        this.agent.getImplementation().setBasePath(null);
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getQualifiedName(), (String)"com.foo.Bar");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getDerivedPath(), (String)"/Some/Other");
        this.agent.getImplementation().setPackage("");
        this.agent.getImplementation().setBasePath("");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getQualifiedName(), (String)"com.foo.Bar");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getDerivedPath(), (String)"/Some/Other");
        SImplementationTest.assertEquals((String)this.agent.getImplementation().getJavaFileLoc(), (String)("/Some/Other" + sc + "srcgen" + sc + "com" + sc + "foo" + sc + "Bar.java"));
    }
}

