/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.agf.chart;

import com.ibm.icu.util.ULocale;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.eclipse.amp.agf.chart.CachedColorProvider;
import org.eclipse.amp.agf.chart.ChartType;
import org.eclipse.amp.agf.chart.IChartDesignStrategy;
import org.eclipse.amp.agf.chart.IDataProvider;
import org.eclipse.amp.agf.chart.IDataSelectionListener;
import org.eclipse.amp.agf.chart.NameColorPair;
import org.eclipse.amp.axf.core.ILifeCycleListener;
import org.eclipse.amp.axf.core.IModel;
import org.eclipse.amp.axf.core.IObservationProvider;
import org.eclipse.amp.axf.view.SWTAsyncModelListener;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.ICallBackNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.CallBackValue;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.script.IChartScriptContext;
import org.eclipse.birt.chart.script.IExternalContext;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.statushandlers.StatusManager;

public class ChartEditPart
extends AbstractGraphicalEditPart
implements ICallBackNotifier {
    private static final long serialVersionUID = 1L;
    private Chart chart;
    private IDeviceRenderer renderer;
    private GeneratedChartState chartState;
    private IDataProvider dataProvider;
    private IColorProvider seriesColorProvider;
    private Palette genericPalette;
    private Object dataSource;
    private GC imageGC;
    private Image image;
    private ChartModelListener chartListener;
    IFigure imageFigure;
    Collection<NameColorPair> seriesCache = new HashSet<NameColorPair>();
    private IDataSelectionListener dataListener;
    private int nextOpenPaletteIndex;
    IChartScriptContext csc = new IChartScriptContext(){

        public void setProperty(Object key, Object value) {
        }

        public ULocale getULocale() {
            return null;
        }

        public Object getProperty(Object key) {
            return null;
        }

        public ILogger getLogger() {
            return null;
        }

        public Locale getLocale() {
            return null;
        }

        public IExternalContext getExternalContext() {
            return null;
        }

        public Chart getChartInstance() {
            return ChartEditPart.this.chart;
        }
    };
    private IChartDesignStrategy chartStrategy;
    boolean chartUpated = false;

    public void setSeriesColorProvider(IColorProvider seriesColorProvider) {
        this.seriesColorProvider = seriesColorProvider;
    }

    public ChartEditPart() {
        PlatformConfig config = new PlatformConfig();
        try {
            config.setProperty("device.component", (Object)this);
            this.renderer = ChartEngine.instance((PlatformConfig)config).getRenderer("dv.SWT");
        }
        catch (ChartException e) {
            throw new RuntimeException(e);
        }
        this.genericPalette = PaletteImpl.create((int)0, (boolean)true);
        this.genericPalette.shift(0);
    }

    private void updateValueSetColor(Object valueSet, int index) {
        String seriesLabel = this.dataProvider.getText(valueSet);
        Color swtColor = this.seriesColorProvider.getForeground((Object)seriesLabel);
        EList entries = this.chartStrategy.getValueSetsDefinition().getSeriesPalette().getEntries();
        ColorDefinition cd = null;
        if (swtColor == null) {
            if (this.seriesColorProvider instanceof CachedColorProvider) {
                cd = (ColorDefinition)this.genericPalette.getEntries().get(this.nextOpenPaletteIndex++);
                if (this.nextOpenPaletteIndex > this.genericPalette.getEntries().size() - 1) {
                    this.nextOpenPaletteIndex = 0;
                }
                swtColor = new Color((Device)Display.getCurrent(), cd.getRed(), cd.getGreen(), cd.getBlue());
                ((CachedColorProvider)this.seriesColorProvider).putForegroundColor(seriesLabel, swtColor);
            }
        } else {
            cd = ColorDefinitionImpl.create((int)swtColor.getRed(), (int)swtColor.getGreen(), (int)swtColor.getBlue());
        }
        entries.add(cd);
    }

    protected IFigure createFigure() {
        this.chartListener.setWidget(this.getViewer().getControl());
        this.imageFigure = new Figure(){

            public void paintFigure(Graphics graphics) {
                if (ChartEditPart.this.image != null) {
                    graphics.drawImage(ChartEditPart.this.image, 0, 0);
                    if (ChartEditPart.this.chartListener != null) {
                        ChartEditPart.this.chartListener.endPainting();
                    }
                }
            }
        };
        this.imageFigure.setLayoutManager((LayoutManager)new AbstractLayout(){

            public Dimension getMinimumSize(IFigure container, int hintWidth, int hintHeight) {
                return new Dimension(hintWidth < 1 ? 1 : hintWidth, hintHeight < 1 ? 1 : hintHeight);
            }

            protected Dimension calculatePreferredSize(IFigure container, int hintWidth, int hintHeight) {
                return new Dimension(hintWidth < 1 ? 100 : hintWidth, hintHeight < 1 ? 100 : hintHeight);
            }

            public void layout(IFigure container) {
                ChartEditPart.this.imageFigure.setLocation(new Point(0, 0));
            }
        });
        this.imageFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                ChartEditPart.this.regenerateChart();
            }
        });
        return this.imageFigure;
    }

    protected void createEditPolicies() {
    }

    public void refresh() {
        new Thread(){

            public void run() {
                ChartEditPart.this.regenerateChart(true);
            }
        }.run();
    }

    public void setModel(Object model) {
        super.setModel(model);
        this.chartListener = new ChartModelListener();
        ((IModel)model).addModelListener((ILifeCycleListener)this.chartListener);
        IAdapterManager adapterManager = Platform.getAdapterManager();
        Object provider = adapterManager.loadAdapter(this.getModel(), "org.eclipse.amp.agf.chart.IDataProvider");
        if (!(provider instanceof IDataProvider)) {
            throw new RuntimeException("Couldn't find data provider for chart model. Please ensure that a data provider adapter has been defined for the class: " + this.getModel().getClass());
        }
        this.setDataProvider((IDataProvider)provider);
    }

    public void regenerateChart() {
        this.regenerateChart(true);
    }

    public synchronized void regenerateChart(boolean forceNewImage) {
        if (forceNewImage) {
            this.image = null;
        }
        try {
            if (this.chart != null && this.chartStrategy.isInitialized() && this.getFigure() != null && !this.getFigure().getSize().isEmpty()) {
                this.createImage();
                Dimension area = this.getFigure().getSize();
                Bounds chartBounds = BoundsImpl.create((double)0.0, (double)0.0, (double)area.width, (double)area.height);
                chartBounds.scale(72.0 / (double)this.renderer.getDisplayServer().getDpiResolution());
                Generator gr = Generator.instance();
                RunTimeContext rtc = new RunTimeContext();
                rtc.setScriptingEnabled(false);
                this.chartState = gr.build(this.renderer.getDisplayServer(), this.chart, chartBounds, rtc);
                gr.render(this.renderer, this.chartState);
                this.imageFigure.repaint();
            } else {
                this.chartListener.endPainting();
            }
        }
        catch (ChartException ce) {
            StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.agf.chart", "Couldn't generate chart.", (Throwable)ce));
            this.chartListener.endPainting();
        }
    }

    public void createImage() {
        Dimension area = this.getFigure().getSize();
        Rectangle swtBounds = new Rectangle(0, 0, Math.max(area.width, 10), Math.max(area.height, 10));
        if (this.image == null || !this.image.getBounds().equals((Object)swtBounds)) {
            if (this.image != null) {
                this.image.dispose();
                this.imageGC.dispose();
            }
            this.image = new Image((Device)this.getViewer().getControl().getDisplay(), swtBounds);
            this.imageGC = new GC((Drawable)this.image);
            this.renderer.setProperty("device.output.context", (Object)this.imageGC);
        }
    }

    public synchronized void createChart() {
        this.chart = this.chartStrategy.createChart(this.dataProvider, this.dataSource);
        this.chart.getTitle().getLabel().setVisible(false);
    }

    public synchronized void updateChartSelection() {
        this.chartStrategy.updateSelection();
        List valueSets = this.dataProvider.getValueSets(this.dataSource);
        this.chartStrategy.getValueSetsDefinition().getSeriesPalette().getEntries().clear();
        int index = 0;
        for (Object valueSet : valueSets) {
            this.updateValueSetColor(valueSet, index);
            ++index;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public Chart getDesignTimeModel() {
        return this.chart;
    }

    public Chart getRunTimeModel() {
        return this.chartState.getChartModel();
    }

    public Object peerInstance() {
        return this;
    }

    public void callback(Object arg0, Object arg1, CallBackValue arg2) {
    }

    public Chart getChart() {
        return this.chart;
    }

    public void repaintChart() {
        this.refresh();
    }

    public void deactivate() {
        super.deactivate();
        this.dataProvider.removeListener(this.dataSource, this.dataListener);
    }

    public IDataProvider getDataProvider() {
        return this.dataProvider;
    }

    public synchronized void setDataProvider(IDataProvider dataProvider) {
        this.dataProvider = dataProvider;
        this.dataSource = dataProvider.getDataSource(this.getModel());
        this.dataListener = new IDataSelectionListener(){

            public void selectionChanged(Object dataSet) {
                if (ChartEditPart.this.getParent() != null && ChartEditPart.this.getRoot() != null && ChartEditPart.this.getViewer() != null && ChartEditPart.this.chart != null) {
                    ChartEditPart.this.updateChartSelection();
                    ChartEditPart.this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ChartEditPart.this.regenerateChart(true);
                        }
                    });
                }
            }
        };
        dataProvider.addListener(this.dataSource, this.dataListener);
    }

    public void setChartStrategy(IChartDesignStrategy chartStrategy) {
        this.chartStrategy = chartStrategy;
        this.createChart();
        this.updateChartSelection();
        if (this.getViewer().getControl().getDisplay() != null) {
            this.getViewer().getControl().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ChartEditPart.this.repaintChart();
                }
            });
        }
    }

    public IColorProvider getSeriesColorProvider() {
        return this.seriesColorProvider;
    }

    class ChartModelListener
    extends SWTAsyncModelListener {
        private static final long serialVersionUID = -6061682325662130469L;

        public ChartModelListener() {
            super(null, "Chart Updated View", 10000L);
        }

        public void observing(IObservationProvider observed) {
            while (ChartEditPart.this.dataProvider == null) {
                try {
                    Thread.sleep(25L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            ChartEditPart.this.setChartStrategy(ChartType.TIME_SERIES.createStrategy());
            ChartEditPart.this.chartUpated = true;
        }

        public void observeStart(IObservationProvider observed) {
            ChartEditPart.this.updateChartSelection();
            this.endPainting();
        }

        public void observeInitialize(IObservationProvider model) {
            ChartEditPart.this.image = null;
        }

        public void update(IModel model) {
            this.beginPainting();
            ChartEditPart.this.chartStrategy.update();
            ChartEditPart.this.refresh();
        }

        public void observationEnd(IObservationProvider model) {
            ChartEditPart.this.dataProvider.removeListener(ChartEditPart.this.dataSource, ChartEditPart.this.dataListener);
            model = null;
        }
    }
}

