/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.view.vis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.TooManyListenersException;
import org.ascape.model.Agent;
import org.ascape.model.CellOccupant;
import org.ascape.model.HostCell;
import org.ascape.model.LocatedAgent;
import org.ascape.model.event.ScapeEvent;
import org.eclipse.amp.escape.ascape.gef.GraphicsEditPart;
import org.eclipse.amp.escape.ascape.view.EditPartScapeView;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class GraphicsView
extends EditPartScapeView
implements ISelectionProvider {
    private static final long serialVersionUID = 1L;
    List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    ISelection currentSelection = StructuredSelection.EMPTY;
    Collection<LocatedAgent> selectedAgents;
    protected Image image;
    protected IFigure imageFigure;
    protected Graphics imageGraphics;
    protected int agentSize = 20;
    protected GC imageGC;

    public GraphicsView(String name) {
        super("org.eclipse.amp.escape.view.GraphicsView", null, name);
    }

    protected void updateScapeGraphics(Graphics graphics) {
    }

    public EditPart createEditPart(EditPart context, Object model) {
        return new GraphicsEditPart(this, model);
    }

    public void createImageFigure() {
        this.imageFigure = new Figure(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void paintFigure(Graphics graphics) {
                1 var2_2 = this;
                synchronized (var2_2) {
                    if (GraphicsView.this.image != null && !GraphicsView.this.image.isDisposed()) {
                        graphics.drawImage(GraphicsView.this.image, 0, 0);
                    }
                }
            }
        };
        this.imageFigure.setLayoutManager((LayoutManager)new AbstractLayout(){

            public Dimension getMinimumSize(IFigure container, int hintWidth, int hintHeight) {
                if (GraphicsView.this.getScape() != null) {
                    return GraphicsView.this.getMinimumSizeWithin(new Dimension(hintWidth, hintHeight));
                }
                return new Dimension(500, 500);
            }

            protected Dimension calculatePreferredSize(IFigure container, int hintWidth, int hintHeight) {
                if (GraphicsView.this.getScape() != null) {
                    return GraphicsView.this.getPreferredSizeWithin(new Dimension(hintWidth, hintHeight));
                }
                return new Dimension(500, 500);
            }

            public void layout(IFigure container) {
                GraphicsView.this.imageFigure.setLocation(new Point(0, 0));
            }
        });
        this.imageFigure.addFigureListener(new FigureListener(){

            public void figureMoved(IFigure source) {
                GraphicsView.this.refresh();
            }
        });
        this.imageFigure.addMouseListener(new MouseListener(){

            public void mouseDoubleClicked(MouseEvent me) {
            }

            public void mousePressed(MouseEvent me) {
                LocatedAgent agentAtPixel = (LocatedAgent)GraphicsView.this.getAgentAtPixel(me.getLocation().x, me.getLocation().y);
                if (agentAtPixel instanceof LocatedAgent) {
                    CellOccupant occupant;
                    if (agentAtPixel instanceof HostCell && (me.getState() & 0x40000) == 0 && (occupant = (CellOccupant)((HostCell)agentAtPixel).getOccupant()) != null) {
                        agentAtPixel = occupant;
                    }
                    if ((me.getState() & 0x20000) > 0) {
                        if (!GraphicsView.this.selectedAgents.contains(agentAtPixel)) {
                            GraphicsView.this.selectedAgents.add(agentAtPixel);
                        } else {
                            GraphicsView.this.selectedAgents.remove(agentAtPixel);
                        }
                    } else {
                        GraphicsView.this.selectedAgents = new HashSet<LocatedAgent>();
                        GraphicsView.this.selectedAgents.add(agentAtPixel);
                    }
                } else {
                    GraphicsView.this.currentSelection = StructuredSelection.EMPTY;
                }
                GraphicsView.this.currentSelection = new StructuredSelection(GraphicsView.this.selectedAgents.toArray());
                GraphicsView.this.setSelection(GraphicsView.this.currentSelection);
                GraphicsView.this.fireSelectionChanged();
                ((Display)GraphicsView.this.getImage().getDevice()).syncExec(new Runnable(){

                    @Override
                    public void run() {
                        GraphicsView.this.refresh();
                    }
                });
            }

            public void mouseReleased(MouseEvent me) {
            }
        });
    }

    public Agent getAgentAtPixel(int x, int y) {
        return null;
    }

    public void createImage() {
        Dimension size = this.getPreferredSizeWithin(this.imageFigure.getSize());
        if (size.width <= 0 || size.height <= 0) {
            size = new Dimension(1, 1);
        }
        if (this.image == null || this.image.getBounds().width != size.width || this.image.getBounds().height != size.height) {
            if (this.image != null && !this.image.isDisposed()) {
                this.image.dispose();
                this.imageGC.dispose();
                this.imageGraphics.dispose();
            }
            this.image = new Image((Device)Display.getCurrent(), new Rectangle(0, 0, size.width, size.height));
            this.imageGC = new GC((Drawable)this.image);
            this.imageGraphics = new SWTGraphics(this.imageGC);
        }
    }

    public void refresh() {
        this.createImage();
        this.updateScapeGraphics(this.imageGraphics);
        if (this.getSelection() != null) {
            StructuredSelection sel = (StructuredSelection)this.getSelection();
            for (LocatedAgent agent : sel) {
                if (agent.isDelete()) continue;
                this.drawSelectedAgent(this.imageGraphics, agent);
            }
        }
        this.imageFigure.repaint();
    }

    protected void drawSelectedAgent(Graphics graphics, LocatedAgent a) {
    }

    @Override
    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        this.createFeatures();
    }

    public void scapeIterated(ScapeEvent scapeEvent) {
        super.scapeIterated(scapeEvent);
    }

    public void createFeatures() {
    }

    public Dimension getSize() {
        return new Dimension(this.image.getBounds().width, this.image.getBounds().height);
    }

    public Dimension getPreferredSizeWithin(Dimension d) {
        return new Dimension(d.width < 1 ? 500 : d.width, d.height < 1 ? 500 : d.height);
    }

    public Dimension getMinimumSizeWithin(Dimension d) {
        return new Dimension(1, 1);
    }

    public Image getImage() {
        return this.image;
    }

    public IFigure getImageFigure() {
        return this.imageFigure;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    void fireSelectionChanged() {
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this.currentSelection));
        }
    }

    public void setSelection(ISelection selection) {
        this.currentSelection = selection;
    }
}

