/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.escape.view;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TooManyListenersException;
import org.ascape.model.event.ScapeEvent;
import org.ascape.util.PropertyAccessor;
import org.ascape.util.data.DataSeries;
import org.ascape.view.nonvis.DataView;
import org.eclipse.amp.amf.adata.Catalog;
import org.eclipse.amp.amf.adata.DataPackage;
import org.eclipse.amp.amf.adata.DataPoint;
import org.eclipse.amp.amf.adata.Measurement;
import org.eclipse.amp.amf.adata.Parameter;
import org.eclipse.amp.amf.adata.ParameterSet;
import org.eclipse.amp.amf.adata.Run;
import org.eclipse.amp.amf.adata.ScaleType;
import org.eclipse.amp.amf.adata.impl.DataFactoryImpl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ui.statushandlers.StatusManager;
import org.metaabm.IValue;
import org.metaabm.SAgent;
import org.metaabm.SAttribute;
import org.metaabm.SContext;
import org.metaabm.SState;
import org.metaabm.SStateValue;

public class EMFSimDataCollector
extends DataView {
    private Run currentRun;
    private Catalog catalog;
    private Map<DataSeries, Measurement> measureForSeries;
    private final SContext model;

    public EMFSimDataCollector(SContext model) {
        assert (model != null);
        this.model = model;
        this.measureForSeries = new HashMap<DataSeries, Measurement>();
        this.catalog = DataFactoryImpl.eINSTANCE.createCatalog();
    }

    public void scapeStopped(ScapeEvent scapeEvent) {
        super.scapeStopped(scapeEvent);
        this.currentRun.setFinished(new Date());
    }

    public void scapeStarted(ScapeEvent scapeEvent) {
        super.scapeStarted(scapeEvent);
        this.currentRun = DataFactoryImpl.eINSTANCE.createRun();
        this.currentRun.setStarted(new Date());
        this.catalog.getRuns().add((Object)this.currentRun);
        this.currentRun.setModel(this.model);
        this.currentRun.setName(this.getScape().getName());
        ParameterSet createParameterSet = DataFactoryImpl.eINSTANCE.createParameterSet();
        this.currentRun.getParameterSets().add((Object)createParameterSet);
        List accessors = this.scape.retrieveAllAccessorsOrdered();
        for (PropertyAccessor accessor : accessors) {
            this.addParameter(createParameterSet, accessor.getName(), accessor.getValue());
        }
        this.measureForSeries = new HashMap<DataSeries, Measurement>();
        int i = 0;
        while (i < this.dataSelection.getSelectionSize()) {
            DataSeries selectedSeries = this.dataSelection.getSelectedSeries(i);
            Measurement measure = DataFactoryImpl.eINSTANCE.createMeasurement();
            String measureName = selectedSeries.getDataPoint().getName();
            IValue valueForName = this.getValueForName(measureName);
            measure.setValue(valueForName);
            measure.setName(measureName);
            if (selectedSeries.getMeasureName() == "Count") {
                measure.setType(ScaleType.COUNT);
            } else if (selectedSeries.getMeasureName() == "Sum") {
                measure.setType(ScaleType.SUM);
            } else if (selectedSeries.getMeasureName() == "Average") {
                measure.setType(ScaleType.AVERAGE);
            } else if (selectedSeries.getMeasureName() == "Minimum") {
                measure.setType(ScaleType.MINIMUM);
            } else if (selectedSeries.getMeasureName() == "Maximum") {
                measure.setType(ScaleType.MAXIMUM);
            } else if (selectedSeries.getMeasureName() == "Standard Deviation") {
                measure.setType(ScaleType.STANDARD_DEVIATION);
            } else if (selectedSeries.getMeasureName() == "Variance") {
                measure.setType(ScaleType.VARIANCE);
            }
            this.measureForSeries.put(selectedSeries, measure);
            this.currentRun.getMeasurements().add((Object)measure);
            ++i;
        }
        super.scapeStarted(scapeEvent);
    }

    public void scapeIterated(ScapeEvent scapeEvent) {
        super.scapeIterated(scapeEvent);
        for (Object selected : this.dataSelection.getSelectedSeries()) {
            DataSeries selectedSeries = (DataSeries)selected;
            DataPoint dataPoint = DataFactoryImpl.eINSTANCE.createDataPoint();
            Measurement measurement = this.measureForSeries.get(selectedSeries);
            dataPoint.setPeriod((long)this.getScape().getPeriod());
            dataPoint.setMeasurement(measurement);
            dataPoint.setValue(selectedSeries.getValue());
            measurement.getEntries().add((Object)dataPoint);
        }
    }

    public void scapeAdded(ScapeEvent scapeEvent) throws TooManyListenersException {
        super.scapeAdded(scapeEvent);
        this.getDataSelection().selectAll();
    }

    private void addParameter(ParameterSet set, String attrName, Object object) {
        Parameter param = DataFactoryImpl.eINSTANCE.createParameter();
        IValue valueForName = this.getValueForName(attrName);
        if (valueForName instanceof SAttribute) {
            param.setAttribute((SAttribute)valueForName);
        }
        param.setName(attrName);
        param.eSet((EStructuralFeature)DataPackage.Literals.PARAMETER__VALUE, (Object)object.toString());
        set.getMembers().add((Object)param);
    }

    private IValue getValueForName(String attrName) {
        String searchName = attrName.toLowerCase().replace(" ", "");
        for (EObject object : this.model.getAllAgents()) {
            SAgent agent = (SAgent)object;
            for (SAttribute attribute : agent.getAttributes()) {
                String matchName = attribute.getLabel();
                if (attribute instanceof SState) {
                    for (SStateValue value : ((SState)attribute).getOptions()) {
                        String stateName = String.valueOf(value.getLabel()) + " " + matchName;
                        if (agent.getOwner() != null) {
                            stateName = String.valueOf(agent.getLabel()) + " " + stateName;
                        }
                        if (!(stateName = stateName.toLowerCase().replace(" ", "")).equals(searchName)) continue;
                        return value;
                    }
                    continue;
                }
                if (agent.getOwner() != null) {
                    matchName = String.valueOf(agent.getLabel()) + " " + matchName;
                }
                if (!(matchName = matchName.toLowerCase().replace(" ", "")).equals(searchName)) continue;
                return attribute;
            }
        }
        StatusManager.getManager().handle((IStatus)new Status(2, "org.eclipse.amp.escape.amf.ide", "Couldn't find attribute for parameter name: " + attrName));
        return null;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }
}

