/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amp.amf.acore.edit.commands.test;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTest;
import org.eclipse.amp.amf.acore.edit.commands.test.CommandTransformer;
import org.eclipse.amp.amf.acore.edit.commands.test.ModelConstructionCommandTest;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.metaabm.act.AAct;
import org.metaabm.act.ARule;
import org.metaabm.act.MetaABMActFactory;
import org.metaabm.act.MetaABMActPackage;

public class AgentComplexActsTest
extends CommandTest {
    public AgentComplexActsTest(String name) {
        super(name);
    }

    protected static String getAgentRuleID() {
        return "rootContextAgentRule";
    }

    public static void buildAddActs(List<CommandTransformer> cmds) {
        cmds.add(new AddRuleCommand());
    }

    public void testAddActs() {
        ArrayList<CommandTransformer> cmds = new ArrayList<CommandTransformer>();
        ModelConstructionCommandTest.buildRoot(cmds);
        ModelConstructionCommandTest.buildAgents(cmds);
        AgentComplexActsTest.buildAddActs(cmds);
        this.executeTests(cmds);
    }

    static abstract class AddActCommand
    extends CommandTransformer {
        EClass clazz;
        EReference feature;
        int expectedMembers;

        public AddActCommand(EClass clazz, EReference feature, int expectedMembers) {
            super("Add " + feature.getName());
            this.feature = feature;
            this.clazz = clazz;
            this.expectedMembers = expectedMembers;
        }

        @Override
        public Command getCommand() {
            CompoundCommand cmd = new CompoundCommand();
            EObject object = MetaABMActFactory.eINSTANCE.create(this.clazz);
            CreateChildCommand cc = new CreateChildCommand(this.domain, (EObject)this.getParent(), (EStructuralFeature)this.feature, (Object)object, Collections.singleton(object));
            cmd.append((Command)cc);
            return cmd;
        }

        @Override
        public void preCondition() {
            AgentComplexActsTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)this.expectedMembers);
        }

        @Override
        public void postCondition() {
            AgentComplexActsTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)(this.expectedMembers + 1));
        }

        public abstract AAct getParent();
    }

    static class AddRuleCommand
    extends CommandTransformer {
        AddRuleCommand() {
        }

        @Override
        public Command getCommand() {
            CompoundCommand cmd = new CompoundCommand();
            ARule createdAct = MetaABMActFactory.eINSTANCE.createARule();
            AddCommand cc = new AddCommand(this.domain, (EObject)this.agentRootAct(), (EStructuralFeature)MetaABMActPackage.Literals.AGROUP__MEMBERS, (Object)createdAct);
            cmd.append((Command)cc);
            return cmd;
        }

        @Override
        public void preCondition() {
            AgentComplexActsTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)0);
        }

        @Override
        public void postCondition() {
            AgentComplexActsTest.assertEquals((int)this.agentRootAct().getMembers().size(), (int)1);
        }
    }
}

