/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics;

import java.util.EmptyStackException;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.graphics.GraphicsState;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Pattern;

public abstract class StatefulGraphics
extends Graphics {
    private GraphicsState m_defaultState = GraphicsState.createDefaultState();
    private boolean m_disposed = false;
    private GraphicsState m_state = new GraphicsState(this.m_defaultState);

    protected void checkDisposed() {
        if (this.m_disposed) {
            throw new IllegalStateException((Object)((Object)this) + " is disposed");
        }
    }

    public void clipRect(Rectangle i_r) {
        this.m_state.clipRect(i_r);
    }

    protected int[] convertDash(float[] i_dash) {
        if (i_dash == null) {
            return null;
        }
        int[] result = new int[i_dash.length];
        int i = 0;
        while (i < i_dash.length) {
            result[i] = (int)i_dash[i];
            ++i;
        }
        return result;
    }

    public void dispose() {
        this.checkDisposed();
        this.m_disposed = true;
    }

    public boolean getAdvanced() {
        this.checkDisposed();
        return this.m_state.getAdvanced();
    }

    public int getAlpha() {
        this.checkDisposed();
        return this.m_state.getAlpha();
    }

    public int getAntialias() {
        this.checkDisposed();
        return this.m_state.getAntialias();
    }

    public Color getBackgroundColor() {
        this.checkDisposed();
        return this.m_state.getBackgroundColor();
    }

    public Rectangle getClip(Rectangle o_rect) {
        this.checkDisposed();
        PrecisionRectangle clip = this.m_state.getClip();
        o_rect.setBounds((Rectangle)clip);
        return o_rect;
    }

    public int getFillRule() {
        this.checkDisposed();
        return this.m_state.getFillRule();
    }

    public Font getFont() {
        this.checkDisposed();
        return this.m_state.getFont();
    }

    public FontMetrics getFontMetrics() {
        this.checkDisposed();
        return this.m_state.getFontMetrics();
    }

    public Color getForegroundColor() {
        this.checkDisposed();
        return this.m_state.getForegroundColor();
    }

    public int getInterpolation() {
        this.checkDisposed();
        return this.m_state.getInterpolation();
    }

    public LineAttributes getLineAttributes() {
        this.checkDisposed();
        LineAttributes attrs = new LineAttributes(this.m_state.getLineWidth());
        attrs.cap = this.m_state.getLineCap();
        attrs.dashOffset = 0.0f;
        attrs.join = this.m_state.getLineJoin();
        attrs.miterLimit = this.m_state.getLineMiterLimit();
        attrs.style = this.m_state.getLineStyle();
        int[] lineDash = this.m_state.getLineDash();
        if (lineDash == null) {
            attrs.dash = null;
        } else {
            attrs.dash = new float[lineDash.length];
            int i = 0;
            while (i < lineDash.length) {
                attrs.dash[i] = lineDash[i];
                ++i;
            }
        }
        return attrs;
    }

    public int getLineCap() {
        this.checkDisposed();
        return this.m_state.getLineCap();
    }

    public int getLineJoin() {
        this.checkDisposed();
        return this.m_state.getLineJoin();
    }

    public float getLineMiterLimit() {
        this.checkDisposed();
        return this.m_state.getLineMiterLimit();
    }

    public int getLineStyle() {
        this.checkDisposed();
        return this.m_state.getLineStyle();
    }

    public int getLineWidth() {
        this.checkDisposed();
        return Math.round(this.m_state.getLineWidth());
    }

    public float getLineWidthFloat() {
        this.checkDisposed();
        return this.m_state.getLineWidth();
    }

    protected GraphicsState getState() {
        return this.m_state;
    }

    public int getTextAntialias() {
        this.checkDisposed();
        return this.m_state.getTextAntialias();
    }

    public boolean getXORMode() {
        this.checkDisposed();
        return this.m_state.getXORMode();
    }

    public void popState() {
        this.checkDisposed();
        if (this.m_state.getParent() == this.m_defaultState) {
            throw new EmptyStackException();
        }
        this.m_state = this.m_state.getParent();
    }

    public void pushState() {
        this.checkDisposed();
        this.m_state = new GraphicsState(this.m_state);
    }

    public void restoreState() {
        this.checkDisposed();
        this.m_state = new GraphicsState(this.m_state.getParent());
    }

    public void rotate(float i_degrees) {
        this.checkDisposed();
        if (i_degrees != 0.0f) {
            this.m_state.rotate(i_degrees);
        }
    }

    public void scale(double i_amount) {
        this.checkDisposed();
        if (i_amount != 0.0) {
            this.m_state.scale((float)i_amount, (float)i_amount);
        }
    }

    public void scale(float i_horizontal, float i_vertical) {
        this.checkDisposed();
        if (i_horizontal != 0.0f || i_vertical != 0.0f) {
            this.m_state.scale(i_horizontal, i_vertical);
        }
    }

    public void setAdvanced(boolean i_advanced) {
        this.checkDisposed();
        this.m_state.setAdvanced(i_advanced);
    }

    public void setAlpha(int i_alpha) {
        this.checkDisposed();
        this.m_state.setAlpha(i_alpha);
    }

    public void setAntialias(int i_antialias) {
        this.checkDisposed();
        this.m_state.setAntialias(i_antialias);
    }

    public void setBackgroundColor(Color i_backgroundColor) {
        this.checkDisposed();
        this.m_state.setBackgroundColor(i_backgroundColor);
    }

    public void setBackgroundPattern(Pattern i_backgroundPattern) {
        this.checkDisposed();
        this.m_state.setBackgroundPattern(i_backgroundPattern);
    }

    public void setClip(Rectangle i_r) {
        this.checkDisposed();
        this.m_state.setClip(i_r);
    }

    public void setFillRule(int i_fillRule) {
        this.checkDisposed();
        this.m_state.setFillRule(i_fillRule);
    }

    public void setFont(Font i_font) {
        this.checkDisposed();
        this.m_state.setFont(i_font);
    }

    public void setForegroundColor(Color i_foregroundColor) {
        this.checkDisposed();
        this.m_state.setForegroundColor(i_foregroundColor);
    }

    public void setInterpolation(int i_interpolation) {
        this.checkDisposed();
        this.m_state.setInterpolation(i_interpolation);
    }

    public void setLineAttributes(LineAttributes i_attributes) {
        this.checkDisposed();
        if (i_attributes == null) {
            return;
        }
        this.m_state.setLineCap(i_attributes.cap);
        this.m_state.setLineJoin(i_attributes.join);
        this.m_state.setLineMiterLimit(i_attributes.miterLimit);
        this.m_state.setLineStyle(i_attributes.style);
        this.m_state.setLineWidth(i_attributes.width);
        this.m_state.setLineDash(this.convertDash(i_attributes.dash));
        if (i_attributes.dash != null) {
            this.m_state.setLineStyle(6);
        } else {
            this.m_state.setLineStyle(1);
        }
    }

    public void setLineCap(int i_cap) {
        this.checkDisposed();
        this.m_state.setLineCap(i_cap);
    }

    public void setLineDash(float[] i_dash) {
        this.checkDisposed();
        if (i_dash != null) {
            this.m_state.setLineStyle(6);
            this.m_state.setLineDash(this.convertDash(i_dash));
        } else {
            this.m_state.setLineStyle(1);
            this.m_state.setLineDash(null);
        }
    }

    public void setLineDash(int[] i_dash) {
        this.checkDisposed();
        if (i_dash != null) {
            this.m_state.setLineStyle(6);
        } else {
            this.m_state.setLineStyle(1);
        }
        this.m_state.setLineDash(i_dash);
    }

    public void setLineJoin(int i_lineJoin) {
        this.checkDisposed();
        this.m_state.setLineJoin(i_lineJoin);
    }

    public void setLineMiterLimit(float i_lineMiterLimit) {
        this.checkDisposed();
        this.m_state.setLineMiterLimit(i_lineMiterLimit);
    }

    public void setLineStyle(int i_lineStyle) {
        this.checkDisposed();
        this.m_state.setLineStyle(i_lineStyle);
    }

    public void setLineWidth(int i_lineWidth) {
        this.checkDisposed();
        this.m_state.setLineWidth(i_lineWidth);
    }

    public void setLineWidthFloat(float i_lineWidth) {
        this.checkDisposed();
        this.m_state.setLineWidth(i_lineWidth);
    }

    public void setTextAntialias(int i_textAntialias) {
        this.checkDisposed();
        this.m_state.setTextAntialias(i_textAntialias);
    }

    public void setXORMode(boolean i_enabled) {
        this.checkDisposed();
        this.m_state.setXORMode(i_enabled);
    }

    public void shear(float i_horz, float i_vert) {
        this.checkDisposed();
        if (i_horz != 0.0f || i_vert != 0.0f) {
            this.m_state.shear(i_horz, i_vert);
        }
    }

    public void translate(float i_dx, float i_dy) {
        this.checkDisposed();
        if (i_dx != 0.0f || i_dy != 0.0f) {
            this.m_state.translate(i_dx, i_dy);
        }
    }

    public void translate(int i_dx, int i_dy) {
        this.checkDisposed();
        if (i_dx != 0 || i_dy != 0) {
            this.m_state.translate(i_dx, i_dy);
        }
    }
}

