/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.util.data;

import java.io.Serializable;
import java.util.Observable;
import java.util.Vector;
import org.ascape.model.Scape;
import org.ascape.util.data.DataSeries;
import org.ascape.util.data.DataSeriesStore;
import org.ascape.util.data.StatCollector;

public class DataGroup
extends Observable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Scape scape;
    private StatCollector[] stats = new StatCollector[0];
    private Vector periods = new Vector();
    private DataSeries[] dataSeries = new DataSeries[0];
    private boolean collectingLongitudinalData = true;

    public void add(StatCollector[] addedStatCollectors) {
        Vector<DataSeries> vectorStatCollectorsSeries = new Vector<DataSeries>();
        int j = 0;
        while (j < addedStatCollectors.length) {
            DataSeries[] tempDataSeries = addedStatCollectors[j].getAllDataSeries();
            int k = 0;
            while (k < tempDataSeries.length) {
                if (tempDataSeries[k] != null) {
                    vectorStatCollectorsSeries.addElement(tempDataSeries[k]);
                }
                ++k;
            }
            ++j;
        }
        DataSeries[] newStatCollectorsSeries = new DataSeries[this.dataSeries.length + vectorStatCollectorsSeries.size()];
        int j2 = 0;
        while (j2 < this.dataSeries.length) {
            newStatCollectorsSeries[j2] = this.dataSeries[j2];
            ++j2;
        }
        while (j2 < newStatCollectorsSeries.length) {
            newStatCollectorsSeries[j2] = (DataSeries)vectorStatCollectorsSeries.elementAt(j2 - this.dataSeries.length);
            ++j2;
        }
        this.dataSeries = newStatCollectorsSeries;
        if (this.periods == null) {
            this.periods = new Vector();
        }
        StatCollector[] newStatCollectors = new StatCollector[this.stats.length + addedStatCollectors.length];
        int i = 0;
        while (i < this.stats.length) {
            newStatCollectors[i] = this.stats[i];
            ++i;
        }
        while (i < newStatCollectors.length) {
            newStatCollectors[i] = addedStatCollectors[i - this.stats.length];
            ++i;
        }
        this.stats = newStatCollectors;
        this.setChanged();
        this.notifyObservers();
    }

    public boolean removeStatCollector(StatCollector toBeRemoved) {
        StatCollector[] temp = new StatCollector[this.stats.length - 1];
        boolean found = false;
        int i = 0;
        int j = 0;
        while (i < this.stats.length) {
            StatCollector statCollector = this.stats[i];
            if (statCollector.getName().equalsIgnoreCase(toBeRemoved.getName())) {
                found = true;
            } else {
                temp[j++] = this.stats[i];
            }
            ++i;
        }
        this.stats = temp;
        return found;
    }

    public StatCollector[] getStatCollectors() {
        return this.stats;
    }

    public void update() {
        if (this.scape != null) {
            this.periods.addElement(new Integer(this.scape.getPeriod()));
        }
        int i = 0;
        while (i < this.dataSeries.length) {
            this.dataSeries[i].addValue();
            ++i;
        }
    }

    public void clear() {
        this.periods.clear();
        int i = 0;
        while (i < this.dataSeries.length) {
            this.dataSeries[i].clear();
            ++i;
        }
        this.setChanged();
        this.notifyObservers();
    }

    public void setScape(Scape scape) {
        this.scape = scape;
    }

    public Scape getScape() {
        return this.scape;
    }

    public Vector getPeriods() {
        return this.periods;
    }

    public int getSize() {
        return this.dataSeries.length;
    }

    public int getIndexOfSeries(String name) {
        if (name.startsWith("Total")) {
            this.getScape().getEnvironment().getConsole().println("***Warning, using \"" + name + "\" to reference statistic series.");
            name = "Sum " + name.substring(6, Integer.MAX_VALUE);
            this.getScape().getEnvironment().getConsole().println("Usage is deprecated, use \"" + name + "\" instead.***");
        }
        int i = 0;
        while (i < this.dataSeries.length) {
            if (this.dataSeries[i].getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndexOfSeries(DataSeries series) {
        int i = 0;
        while (i < this.dataSeries.length) {
            if (this.dataSeries[i] == series) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public DataSeries getSeries(int index) {
        if (this.dataSeries[index].isCollecting()) {
            return (DataSeriesStore)this.dataSeries[index];
        }
        return this.dataSeries[index];
    }

    public DataSeries getSeries(String name) {
        if (this.dataSeries[this.getIndexOfSeries(name)].isCollecting()) {
            return (DataSeriesStore)this.dataSeries[this.getIndexOfSeries(name)];
        }
        return this.dataSeries[this.getIndexOfSeries(name)];
    }

    public String[] getSeriesNames() {
        String[] names = new String[this.dataSeries.length];
        int i = 0;
        while (i < this.dataSeries.length) {
            names[i] = this.dataSeries[i].getName();
            ++i;
        }
        return names;
    }

    protected int getIndexOfStatCollector(String name) {
        int i = 0;
        while (i < this.stats.length) {
            if (this.stats[i].getName().equals(name)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public StatCollector getStatCollector(int index) {
        return this.stats[index];
    }

    public StatCollector getStatCollector(String name) {
        int index = this.getIndexOfStatCollector(name);
        if (index >= 0) {
            return this.stats[this.getIndexOfStatCollector(name)];
        }
        return null;
    }

    public String[] getStatCollectorNames() {
        String[] names = new String[this.stats.length];
        int i = 0;
        while (i < this.stats.length) {
            names[i] = this.stats[i].getName();
            ++i;
        }
        return names;
    }

    public boolean isCollectingLongitudinalData() {
        return this.collectingLongitudinalData;
    }

    public void setCollectingLongitudinalData(boolean collectingLongitudinalData) {
        this.collectingLongitudinalData = collectingLongitudinalData;
    }
}

