/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw3d.AbstractSurface;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.IScene;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.camera.ICameraListener;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.picking.Hit;
import org.eclipse.draw3d.picking.Picker;
import org.eclipse.draw3d.util.Draw3DCache;

public class VoidSurface
extends AbstractSurface
implements ISceneListener {
    private ICameraListener m_cameraListener = new ICameraListener(){

        public void cameraChanged() {
            VoidSurface.this.coordinateSystemChanged();
        }
    };
    private float m_depth;
    private IFigure3D m_host;
    private IScene m_scene;

    public VoidSurface(IFigure3D i_host, IScene i_scene, float i_depth) {
        if (i_host == null) {
            throw new NullPointerException("i_host must not be null");
        }
        if (i_scene == null) {
            throw new NullPointerException("i_scene must not be null");
        }
        this.m_host = i_host;
        this.m_scene = i_scene;
        this.m_depth = i_depth;
        this.m_scene.getCamera().addCameraListener(this.m_cameraListener);
    }

    protected void calculateNormal(Vector3f io_normal) {
        io_normal.set(IVector3f.NULLVEC3f);
    }

    public void cameraChanged(ICamera i_oldCamera, ICamera i_newCamera) {
        i_oldCamera.removeCameraListener(this.m_cameraListener);
        i_newCamera.addCameraListener(this.m_cameraListener);
        this.coordinateSystemChanged();
    }

    public IFigure findFigureAt(int i_sx, int i_sy, TreeSearch i_search) {
        Vector3f rayPoint;
        Point sLocation;
        block4: {
            block3: {
                IFigure iFigure;
                sLocation = Draw3DCache.getPoint();
                rayPoint = Draw3DCache.getVector3f();
                try {
                    Picker picker = this.m_scene.getPicker();
                    ISurface currentSurface = picker.getCurrentSurface();
                    sLocation.setLocation(i_sx, i_sy);
                    currentSurface.getWorldLocation(sLocation, rayPoint);
                    Hit hit = picker.getHit((IVector3f)rayPoint, i_search);
                    if (hit == null) break block3;
                    iFigure = hit.getSearchResult();
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnPoint(sLocation);
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
                    throw throwable;
                }
                Draw3DCache.returnPoint(sLocation);
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
                return iFigure;
            }
            if (i_search != null && (i_search.prune((IFigure)this.m_host) || !i_search.accept((IFigure)this.m_host))) break block4;
            IFigure3D iFigure3D = this.m_host;
            Draw3DCache.returnPoint(sLocation);
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
            return iFigure3D;
        }
        Draw3DCache.returnPoint(sLocation);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{rayPoint});
        return null;
    }

    public IFigure3D getHost() {
        return this.m_host;
    }

    protected Vector3f getOrigin(Vector3f io_result) {
        ICamera camera = this.m_scene.getCamera();
        return camera.unProject(0, 0, this.m_depth, null, io_result);
    }

    public Vector3f getSurfaceRotation(Vector3f o_result) {
        Vector3f vector3f;
        Vector3f zAxis = Draw3DCache.getVector3f();
        try {
            this.getZAxis(zAxis);
            vector3f = Math3D.eulerAngles((IVector3f)zAxis, (IVector3f)IVector3f.Z_AXIS, (Vector3f)o_result);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{zAxis});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{zAxis});
        return vector3f;
    }

    protected Vector3f getXAxis(Vector3f io_result) {
        ICamera camera = this.m_scene.getCamera();
        return camera.getRightVector(io_result);
    }

    protected Vector3f getYAxis(Vector3f io_result) {
        ICamera camera = this.m_scene.getCamera();
        Vector3f yAxis = camera.getUpVector(io_result);
        yAxis.scale(-1.0f);
        return yAxis;
    }

    protected Vector3f getZAxis(Vector3f io_result) {
        ICamera camera = this.m_scene.getCamera();
        return camera.getViewDirection(io_result);
    }

    public boolean is2DHost() {
        return false;
    }

    public void renderPassFinished(RenderContext i_renderContext) {
    }

    public void renderPassStarted(RenderContext i_renderContext) {
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("Void surface with origin ");
        b.append(this.getOrigin(null));
        b.append(" and depth " + this.m_depth);
        return b.toString();
    }
}

