/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.rule;

import java.util.Comparator;
import org.ascape.model.Agent;
import org.ascape.model.rule.Rule;

public class SearchRule
extends Rule {
    private static final long serialVersionUID = 1L;
    private Agent foundAgent;
    private Comparator comparator;
    private Object key;
    public static final int SEARCH_EQUAL = 1;
    public static final int SEARCH_MIN = 2;
    public static final int SEARCH_MAX = 3;
    private final Comparison COMPARE_EQUALS = new Comparison(){

        @Override
        public void execute(Agent a) {
            if (SearchRule.this.comparator.compare(a, SearchRule.this.key) == 0) {
                SearchRule.this.foundAgent = a;
            }
        }
    };
    private final Comparison COMPARE_MIN = new Comparison(){

        @Override
        public void execute(Agent a) {
            if (SearchRule.this.foundAgent == null || SearchRule.this.comparator.compare(a, SearchRule.this.foundAgent) < 0) {
                SearchRule.this.foundAgent = a;
            }
        }
    };
    private final Comparison COMPARE_MAX = new Comparison(){

        @Override
        public void execute(Agent a) {
            if (SearchRule.this.foundAgent == null || SearchRule.this.comparator.compare(a, SearchRule.this.foundAgent) > 0) {
                SearchRule.this.foundAgent = a;
            }
        }
    };
    private Comparison comparison = this.COMPARE_EQUALS;

    public SearchRule(String name) {
        super(name);
    }

    @Override
    public void execute(Agent agent) {
        this.comparison.execute(agent);
    }

    public void clear() {
        this.foundAgent = null;
    }

    public boolean isRandom() {
        return false;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        this.comparator = comparator;
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public Agent getFoundAgent() {
        return this.foundAgent;
    }

    public void setSearchType(int type) {
        switch (type) {
            case 1: {
                this.comparison = this.COMPARE_EQUALS;
                break;
            }
            case 2: {
                this.comparison = this.COMPARE_MIN;
                break;
            }
            case 3: {
                this.comparison = this.COMPARE_MAX;
                break;
            }
            default: {
                throw new RuntimeException("Tried to set a bad search type rule: " + type);
            }
        }
    }

    public int getType() {
        if (this.comparison == this.COMPARE_EQUALS) {
            return 1;
        }
        if (this.comparison == this.COMPARE_MIN) {
            return 2;
        }
        if (this.comparison == this.COMPARE_MAX) {
            return 3;
        }
        throw new RuntimeException("Bad search type rule: " + this.comparison);
    }

    private abstract class Comparison {
        private Comparison() {
        }

        public abstract void execute(Agent var1);
    }
}

