/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class SphereTriangle {
    private IVector3f m_a;
    private IVector3f m_b;
    private IVector3f m_c;

    public SphereTriangle(IVector3f i_a, IVector3f i_b, IVector3f i_c) {
        this.m_a = i_a;
        this.m_b = i_b;
        this.m_c = i_c;
    }

    public SphereTriangle[] divide(IVector3f i_center, float i_radius) {
        SphereTriangle[] sphereTriangleArray;
        Vector3f ta = Draw3DCache.getVector3f();
        Vector3f tb = Draw3DCache.getVector3f();
        Vector3f tc = Draw3DCache.getVector3f();
        try {
            Math3D.sub((IVector3f)this.m_a, (IVector3f)i_center, (Vector3f)ta);
            Math3D.sub((IVector3f)this.m_b, (IVector3f)i_center, (Vector3f)tb);
            Math3D.sub((IVector3f)this.m_c, (IVector3f)i_center, (Vector3f)tc);
            Vector3fImpl d = new Vector3fImpl();
            Math3D.add((IVector3f)ta, (IVector3f)tb, (Vector3f)d);
            Math3D.scale((float)(i_radius / d.length()), (IVector3f)d, (Vector3f)d);
            Math3D.add((IVector3f)d, (IVector3f)i_center, (Vector3f)d);
            Vector3fImpl e = new Vector3fImpl();
            Math3D.add((IVector3f)tb, (IVector3f)tc, (Vector3f)e);
            Math3D.scale((float)(i_radius / e.length()), (IVector3f)e, (Vector3f)e);
            Math3D.add((IVector3f)e, (IVector3f)i_center, (Vector3f)e);
            Vector3fImpl f = new Vector3fImpl();
            Math3D.add((IVector3f)tc, (IVector3f)ta, (Vector3f)f);
            Math3D.scale((float)(i_radius / f.length()), (IVector3f)f, (Vector3f)f);
            Math3D.add((IVector3f)f, (IVector3f)i_center, (Vector3f)f);
            SphereTriangle[] result = new SphereTriangle[]{new SphereTriangle((IVector3f)f, (IVector3f)e, this.m_c), new SphereTriangle(this.m_a, (IVector3f)d, (IVector3f)f), new SphereTriangle((IVector3f)f, (IVector3f)e, (IVector3f)d), new SphereTriangle((IVector3f)d, this.m_b, (IVector3f)e)};
            sphereTriangleArray = result;
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ta, tb, tc});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ta, tb, tc});
        return sphereTriangleArray;
    }

    public IVector3f getA() {
        return this.m_a;
    }

    public IVector3f getB() {
        return this.m_b;
    }

    public IVector3f getC() {
        return this.m_c;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SphereTriangle [A:");
        b.append(this.m_a);
        b.append(", B:");
        b.append(this.m_b);
        b.append(", C:");
        b.append(this.m_c);
        b.append("]\n");
        return b.toString();
    }
}

