/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.draw2d.AnchorListener;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.DelegatingLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.RoutingListener;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw3d.ArrowLocator3D;
import org.eclipse.draw3d.Connection3D;
import org.eclipse.draw3d.ConnectionAnchor3D;
import org.eclipse.draw3d.ConnectionRouter3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.Polyline3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class PolylineConnection3D
extends Polyline3D
implements Connection3D,
AnchorListener {
    private static final Logger log = Logger.getLogger(PolylineConnection3D.class.getName());
    private ConnectionAnchor startAnchor;
    private ConnectionAnchor endAnchor;
    private ConnectionRouter connectionRouter = ConnectionRouter3D.NULL;
    private RotatableDecoration startArrow;
    private RotatableDecoration endArrow;

    public PolylineConnection3D() {
        this.setLayoutManager((LayoutManager)new DelegatingLayout());
        this.addPoint((IVector3f)new Vector3fImpl(0.0f, 0.0f, 0.0f));
        this.addPoint((IVector3f)new Vector3fImpl(1.0f, 1.0f, 1.0f));
    }

    public void addNotify() {
        super.addNotify();
        this.hookSourceAnchor();
        this.hookTargetAnchor();
    }

    public void addRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.add(listener);
        } else {
            this.connectionRouter = new RoutingNotifier(this.connectionRouter, listener);
        }
    }

    public void anchorMoved(ConnectionAnchor anchor) {
        this.revalidate();
    }

    public Rectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = super.getBounds();
            int i = 0;
            while (i < this.getChildren().size()) {
                IFigure child = (IFigure)this.getChildren().get(i);
                this.bounds.union(child.getBounds());
                ++i;
            }
        }
        return this.bounds;
    }

    public ConnectionRouter getConnectionRouter() {
        if (this.connectionRouter instanceof RoutingNotifier) {
            return ((RoutingNotifier)this.connectionRouter).realRouter;
        }
        return this.connectionRouter;
    }

    public Object getRoutingConstraint() {
        if (this.getConnectionRouter() != null) {
            return this.getConnectionRouter().getConstraint((Connection)this);
        }
        return null;
    }

    public ConnectionAnchor getSourceAnchor() {
        return this.startAnchor;
    }

    protected RotatableDecoration getSourceDecoration() {
        return this.startArrow;
    }

    public ConnectionAnchor getTargetAnchor() {
        return this.endAnchor;
    }

    protected RotatableDecoration getTargetDecoration() {
        return this.endArrow;
    }

    private void hookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    private void hookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().addAnchorListener((AnchorListener)this);
        }
    }

    public void layout() {
        if (this.getSourceAnchor() != null && this.getTargetAnchor() != null) {
            this.connectionRouter.route((Connection)this);
        }
        Rectangle oldBounds = this.bounds;
        super.layout();
        if (!this.getBounds().contains(oldBounds)) {
            this.getParent().translateToParent((Translatable)oldBounds);
            this.getUpdateManager().addDirtyRegion(this.getParent(), oldBounds);
        }
        this.repaint();
        this.fireFigureMoved();
    }

    public void removeNotify() {
        this.unhookSourceAnchor();
        this.unhookTargetAnchor();
        this.connectionRouter.remove((Connection)this);
        super.removeNotify();
    }

    public void removeRoutingListener(RoutingListener listener) {
        if (this.connectionRouter instanceof RoutingNotifier) {
            RoutingNotifier notifier = (RoutingNotifier)this.connectionRouter;
            notifier.listeners.remove(listener);
            if (notifier.listeners.isEmpty()) {
                this.connectionRouter = notifier.realRouter;
            }
        }
    }

    public void revalidate() {
        super.revalidate();
        if (this.connectionRouter != null) {
            this.connectionRouter.invalidate((Connection)this);
        }
    }

    public void setConnectionRouter(ConnectionRouter cr) {
        ConnectionRouter oldRouter;
        if (cr == null) {
            cr = ConnectionRouter3D.NULL;
        }
        if ((oldRouter = this.getConnectionRouter()) != cr) {
            this.connectionRouter.remove((Connection)this);
            if (this.connectionRouter instanceof RoutingNotifier) {
                ((RoutingNotifier)this.connectionRouter).realRouter = cr;
            } else {
                this.connectionRouter = cr;
            }
            this.firePropertyChange("connectionRouter", oldRouter, cr);
            this.revalidate();
        }
    }

    public void setRoutingConstraint(Object cons) {
        if (this.connectionRouter != null) {
            this.connectionRouter.setConstraint((Connection)this, cons);
        }
        this.revalidate();
    }

    public void setSourceAnchor(ConnectionAnchor anchor) {
        if (anchor == this.startAnchor) {
            return;
        }
        if (!(anchor instanceof ConnectionAnchor3D) && anchor != null && Figure3DHelper.getAncestor3D(anchor.getOwner()) == null) {
            throw new IllegalArgumentException("Cannot set 2D anchor w/o available 3D owner, you probablywould subclass your connection edit part from a 3D base class");
        }
        this.unhookSourceAnchor();
        this.startAnchor = anchor;
        if (this.getParent() != null) {
            this.hookSourceAnchor();
        }
        this.revalidate();
    }

    public void setSourceDecoration(RotatableDecoration dec) {
        if (this.startArrow == dec) {
            return;
        }
        if (this.startArrow != null) {
            this.remove((IFigure)this.startArrow);
        }
        this.startArrow = dec;
        if (this.startArrow != null) {
            this.add((IFigure)this.startArrow, (Object)new ArrowLocator3D(this, 2));
        }
    }

    public void setTargetAnchor(ConnectionAnchor anchor) {
        if (anchor == this.endAnchor) {
            return;
        }
        if (!(anchor instanceof ConnectionAnchor3D) && anchor != null && Figure3DHelper.getAncestor3D(anchor.getOwner()) == null) {
            throw new IllegalArgumentException("Cannot set 2D anchor w/o available 3D owner, you probablywould subclass your connection edit part from a 3D base class");
        }
        this.unhookTargetAnchor();
        this.endAnchor = anchor;
        if (this.getParent() != null) {
            this.hookTargetAnchor();
        }
        this.revalidate();
    }

    public void setTargetDecoration(RotatableDecoration dec) {
        if (this.endArrow == dec) {
            return;
        }
        if (this.endArrow != null) {
            this.remove((IFigure)this.endArrow);
        }
        this.endArrow = dec;
        if (this.endArrow != null) {
            this.add((IFigure)this.endArrow, (Object)new ArrowLocator3D(this, 3));
        }
    }

    private void unhookSourceAnchor() {
        if (this.getSourceAnchor() != null) {
            this.getSourceAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    private void unhookTargetAnchor() {
        if (this.getTargetAnchor() != null) {
            this.getTargetAnchor().removeAnchorListener((AnchorListener)this);
        }
    }

    public void setValid(boolean i_value) {
        super.setValid(i_value);
    }

    static final class RoutingNotifier
    implements ConnectionRouter {
        ConnectionRouter realRouter;
        List<RoutingListener> listeners = new ArrayList<RoutingListener>(1);

        RoutingNotifier(ConnectionRouter router, RoutingListener listener) {
            this.realRouter = router;
            this.listeners.add(listener);
        }

        public Object getConstraint(Connection connection) {
            return this.realRouter.getConstraint(connection);
        }

        public void invalidate(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).invalidate(connection);
                ++i;
            }
            this.realRouter.invalidate(connection);
        }

        public void route(Connection connection) {
            boolean consumed = false;
            int i = 0;
            while (i < this.listeners.size()) {
                consumed |= this.listeners.get(i).route(connection);
                ++i;
            }
            if (!consumed) {
                this.realRouter.route(connection);
            }
            i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).postRoute(connection);
                ++i;
            }
        }

        public void remove(Connection connection) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).remove(connection);
                ++i;
            }
            this.realRouter.remove(connection);
        }

        public void setConstraint(Connection connection, Object constraint) {
            int i = 0;
            while (i < this.listeners.size()) {
                this.listeners.get(i).setConstraint(connection, constraint);
                ++i;
            }
            this.realRouter.setConstraint(connection, constraint);
        }
    }
}

