/*
 * Decompiled with CFR 0.152.
 */
package org.metaabm.commands;

import java.util.Collection;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.metaabm.IID;
import org.metaabm.MetaABMPackage;
import org.metaabm.SAttribute;
import org.metaabm.SAttributeType;
import org.metaabm.SNDimensional;
import org.metaabm.commands.SetLabelCommand;
import org.metaabm.commands.SuggestLabelCommand;
import org.metaabm.impl.MetaABMFactoryImpl;

public class SetDimensionalAttributesCommand
extends SetCommand {
    CompoundCommand command;
    SuggestLabelCommand suggestLabelCommand;
    static DimAttributeVals[][] ATTR_DESCS = new DimAttributeVals[][]{new DimAttributeVals[0], {new DimAttributeVals("Length", "The extent and size of the space.")}, {new DimAttributeVals("Width", "The horizontal extent of the space."), new DimAttributeVals("Height", "The vertical extent of the space.")}, {new DimAttributeVals("X Extent", "The horizontal extent of the space."), new DimAttributeVals("Y Extent", "The vertical extent of the space."), new DimAttributeVals("Z Extent", "The depth extent of the space.")}};
    static DimAttributeVals ARRAY_DESC = new DimAttributeVals("Dimensions", "The size of each dimension.");

    public SetDimensionalAttributesCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object value, int index) {
        super(domain, owner, feature, value, index);
    }

    protected Command createDependents(EditingDomain domain, SNDimensional proj, int newDim) {
        this.command = new CompoundCommand();
        EList attrs = proj.getAttributes();
        if (newDim > 0) {
            while (attrs.size() > newDim) {
                this.command.appendAndExecute(RemoveCommand.create((EditingDomain)domain, (Object)proj, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attrs.get(attrs.size() - 1)));
            }
            while (attrs.size() < newDim) {
                SAttribute attr = MetaABMFactoryImpl.eINSTANCE.createSAttribute();
                this.command.appendAndExecute(AddCommand.create((EditingDomain)domain, (Object)proj, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Object)attr));
            }
            if (newDim > 3) {
                newDim = 0;
            }
            if (newDim > 0) {
                int index = 0;
                DimAttributeVals[] dimAttributeValsArray = ATTR_DESCS[newDim];
                int n = dimAttributeValsArray.length;
                int n2 = 0;
                while (n2 < n) {
                    DimAttributeVals attrVal = dimAttributeValsArray[n2];
                    SAttribute attr = (SAttribute)attrs.get(index);
                    this.command.appendAndExecute(SetLabelCommand.create(domain, attr, MetaABMPackage.Literals.IID__LABEL, attrVal.name));
                    this.command.appendAndExecute(SetCommand.create((EditingDomain)domain, (Object)attr, (Object)MetaABMPackage.Literals.SNAMED__DESCRIPTION, (Object)attrVal.desc));
                    this.command.appendAndExecute(SetCommand.create((EditingDomain)domain, (Object)attr, (Object)MetaABMPackage.Literals.ITYPED__STYPE, (Object)SAttributeType.INTEGER_LITERAL));
                    ++index;
                    ++n2;
                }
            }
        } else {
            this.command.appendAndExecute(RemoveCommand.create((EditingDomain)domain, (Object)proj, (Object)MetaABMPackage.Literals.SATTRIBUTED__ATTRIBUTES, (Collection)attrs));
        }
        return this.command;
    }

    public void doRedo() {
        super.doRedo();
        this.command.redo();
    }

    public void doUndo() {
        this.suggestLabelCommand = new SuggestLabelCommand(this.domain, (IID)((SNDimensional)this.getOwner()));
        this.command.undo();
        super.doUndo();
        this.suggestLabelCommand.execute();
    }

    public void doExecute() {
        this.oldValue = this.owner.eGet(this.getFeature());
        this.suggestLabelCommand = new SuggestLabelCommand(this.domain, (IID)((SNDimensional)this.getOwner()));
        super.doExecute();
        this.createDependents(this.getDomain(), (SNDimensional)this.getOwner(), (Integer)this.getValue());
        this.command.appendAndExecute((Command)this.suggestLabelCommand);
        this.suggestLabelCommand.execute();
    }

    static class DimAttributeVals {
        String name;
        String desc;

        DimAttributeVals(String name, String desc) {
            this.name = name;
            this.desc = desc;
        }
    }
}

